/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.tags;

import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.icc.tags.ICCTag;

public class ICCCurveType
extends ICCTag {
    private static final String eol = System.getProperty("line.separator");
    public final int type;
    public final int reserved;
    public final int nEntries;
    public final int[] entry;

    @Override
    public String toString() {
        StringBuffer rep = new StringBuffer("[").append(super.toString()).append(" nentries = ").append(String.valueOf(this.nEntries)).append(", length = " + String.valueOf(this.entry.length) + " ... ");
        return rep.append("]").toString();
    }

    public static double CurveToDouble(int entry) {
        return (double)entry / 65535.0;
    }

    public static short DoubleToCurve(double entry) {
        return (short)Math.floor(entry * 65535.0 + 0.5);
    }

    public static double CurveGammaToDouble(int entry) {
        return (double)entry / 256.0;
    }

    protected ICCCurveType(int signature, byte[] data, int offset, int length) {
        super(signature, data, offset, offset + 8);
        this.type = ICCProfile.getInt(data, offset);
        this.reserved = ICCProfile.getInt(data, offset + 4);
        this.nEntries = ICCProfile.getInt(data, offset + 8);
        this.entry = new int[this.nEntries];
        for (int i = 0; i < this.nEntries; ++i) {
            this.entry[i] = ICCProfile.getShort(data, offset + 12 + i * 2) & 0xFFFF;
        }
    }

    public final int entry(int i) {
        return this.entry[i];
    }
}

