/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft2.simpgeometry.SimpleGeometryFeature;
import ucar.nc2.ft2.simpgeometry.adapter.SimpleGeometryCS;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.geoloc.LatLonRect;

public class SimpleGeometryFeatureDataset
implements FeatureDataset {
    private NetcdfDataset ncd;

    public static SimpleGeometryFeatureDataset open(String location) throws IOException {
        return SimpleGeometryFeatureDataset.open(location, NetcdfDataset.getDefaultEnhanceMode());
    }

    public static SimpleGeometryFeatureDataset open(String location, Set<NetcdfDataset.Enhance> enhanceMode) throws IOException {
        NetcdfDataset ds = NetcdfDataset.acquireDataset(null, DatasetUrl.findDatasetUrl(location), enhanceMode, -1, null, null);
        return new SimpleGeometryFeatureDataset(ds);
    }

    public SimpleGeometryFeatureDataset(NetcdfDataset ncd) throws IOException {
        this.ncd = ncd;
        Set<NetcdfDataset.Enhance> enhance = ncd.getEnhanceMode();
        if (enhance == null || enhance.isEmpty()) {
            enhance = NetcdfDataset.getDefaultEnhanceMode();
        }
        ncd.enhance(enhance);
    }

    @Override
    public String getTitle() {
        String title = this.ncd.getTitle();
        if (title == null) {
            title = this.ncd.getRootGroup().findAttValueIgnoreCase("title", null);
        }
        if (title == null) {
            title = this.getName();
        }
        return title;
    }

    @Override
    public String getDescription() {
        String desc = this.ncd.getRootGroup().findAttValueIgnoreCase("description", null);
        if (desc == null) {
            desc = this.ncd.getRootGroup().findAttValueIgnoreCase("history", null);
        }
        return desc == null ? this.getName() : desc;
    }

    @Override
    public String getLocation() {
        return this.ncd != null ? this.ncd.getLocation() : "";
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        return null;
    }

    @Override
    public CalendarDate getCalendarDateStart() {
        return null;
    }

    @Override
    public CalendarDate getCalendarDateEnd() {
        return null;
    }

    @Override
    public LatLonRect getBoundingBox() {
        return null;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.ncd.getGlobalAttributes();
    }

    @Override
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.ncd.findGlobalAttributeIgnoreCase(name);
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        return null;
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        return this.ncd.getRootGroup().findVariable(shortName);
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.ncd;
    }

    @Override
    public void close() throws IOException {
        this.ncd.close();
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public void setFileCache(FileCacheIF fileCache) {
        this.ncd.setFileCache(fileCache);
    }

    @Override
    public void getDetailInfo(Formatter sf) {
        this.ncd.getDetailInfo(sf);
    }

    public String getName() {
        String loc = this.ncd.getLocation();
        int pos = loc.lastIndexOf(47);
        if (pos < 0) {
            pos = loc.lastIndexOf(92);
        }
        return pos < 0 ? loc : loc.substring(pos + 1);
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ncd;
    }

    @Override
    public FeatureType getFeatureType() {
        return FeatureType.SIMPLE_GEOMETRY;
    }

    @Override
    public String getImplementationName() {
        return this.ncd.getConventionUsed();
    }

    @Override
    public void release() throws IOException {
        if (this.ncd != null) {
            this.ncd.release();
        }
    }

    @Override
    public void reacquire() throws IOException {
        if (this.ncd != null) {
            this.ncd.reacquire();
        }
    }

    public static class SimpleGeometryCovSet {
        private SimpleGeometryCS gcc;
        private List<SimpleGeometryFeature> covs = new ArrayList<SimpleGeometryFeature>();

        private SimpleGeometryCovSet(SimpleGeometryCS gcc) {
            this.gcc = gcc;
        }

        private void add(SimpleGeometryFeature cov) {
            this.covs.add(cov);
        }

        public List<SimpleGeometryFeature> getGrids() {
            return this.covs;
        }

        public SimpleGeometryCS getSGCoordSys() {
            return this.gcc;
        }
    }
}

