/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;

public class Geostationary
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "geostationary";
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        this.readStandardParams(ctv, geoCoordinateUnits);
        double subLonDegrees = this.readAttributeDouble(ctv, "longitude_of_projection_origin", Double.NaN);
        if (Double.isNaN(subLonDegrees)) {
            throw new IllegalArgumentException("Must specify longitude_of_projection_origin");
        }
        double perspective_point_height = this.readAttributeDouble(ctv, "perspective_point_height", Double.NaN);
        if (Double.isNaN(perspective_point_height)) {
            throw new IllegalArgumentException("Must specify perspective_point_height");
        }
        double semi_minor_axis = this.readAttributeDouble(ctv, "semi_minor_axis", Double.NaN);
        if (Double.isNaN(semi_minor_axis)) {
            throw new IllegalArgumentException("Must specify semi_minor_axis");
        }
        double semi_major_axis = this.readAttributeDouble(ctv, "semi_major_axis", Double.NaN);
        if (Double.isNaN(semi_major_axis)) {
            throw new IllegalArgumentException("Must specify semi_major_axis");
        }
        double inv_flattening = this.readAttributeDouble(ctv, "inverse_flattening", Double.NaN);
        String sweep_angle = ctv.findAttValueIgnoreCase("sweep_angle_axis", null);
        String fixed_angle = ctv.findAttValueIgnoreCase("fixed_angle_axis", null);
        if (sweep_angle == null && fixed_angle == null) {
            throw new IllegalArgumentException("Must specify sweep_angle_axis or fixed_angle_axis");
        }
        boolean isSweepX = sweep_angle != null ? sweep_angle.equals("x") : fixed_angle.equals("y");
        ucar.unidata.geoloc.projection.sat.Geostationary proj = new ucar.unidata.geoloc.projection.sat.Geostationary(subLonDegrees, perspective_point_height, semi_minor_axis, semi_major_axis, inv_flattening, isSweepX);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

