/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.bufr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.constants.CDM;
import ucar.nc2.ft.point.bufr.BufrCdmIndexProto;
import ucar.nc2.ft.point.bufr.BufrField;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.stream.NcStream;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

public class BufrCdmIndex {
    private static Logger log = LoggerFactory.getLogger(BufrCdmIndex.class);
    public static final String MAGIC_START = "BufrCdmIndex";
    public static final String NCX_IDX = ".ncx";
    private static final int version = 1;
    public String idxFilename;
    public String bufrFilename;
    public BufrCdmIndexProto.Field root;
    public List<BufrCdmIndexProto.Station> stations;
    public long start;
    public long end;
    public long nobs;

    public static File calcIndexFile(String bufrFilename) {
        File bufrFile = new File(bufrFilename);
        String name = bufrFile.getName();
        File result = new File(bufrFile.getParent(), name + NCX_IDX);
        if (result.exists()) {
            return result;
        }
        int pos = name.indexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
            result = new File(bufrFile.getParent(), name + NCX_IDX);
            if (result.exists()) {
                return result;
            }
        }
        return null;
    }

    public static boolean writeIndex(String bufrFilename, BufrConfig config, File idxFile) throws IOException {
        return new BufrCdmIndex().writeIndex2(bufrFilename, config, idxFile);
    }

    public static BufrCdmIndex readIndex(String indexFilename) throws IOException {
        BufrCdmIndex index = new BufrCdmIndex();
        try (RandomAccessFile raf = RandomAccessFile.acquire(indexFilename);){
            index.readIndex(raf);
        }
        return index;
    }

    private boolean writeIndex2(String bufrFilename, BufrConfig config, File indexFile) throws IOException {
        if (indexFile.exists() && !indexFile.delete()) {
            log.warn(" BufrCdmIndex cant delete index file {}", (Object)indexFile.getPath());
        }
        log.debug(" createIndex for {}", (Object)indexFile.getPath());
        try (RandomAccessFile raf = new RandomAccessFile(indexFile.getPath(), "rw");){
            raf.order(0);
            raf.write(MAGIC_START.getBytes(CDM.utf8Charset));
            raf.writeInt(1);
            BufrCdmIndexProto.BufrIndex.Builder indexBuilder = BufrCdmIndexProto.BufrIndex.newBuilder();
            indexBuilder.setFilename(bufrFilename);
            this.root = BufrCdmIndex.buildField(config.getRootConverter());
            indexBuilder.setRoot(this.root);
            indexBuilder.setStart(config.getStart());
            indexBuilder.setEnd(config.getEnd());
            indexBuilder.setNobs(config.getNobs());
            Map<String, BufrConfig.BufrStation> smaps = config.getStationMap();
            if (smaps != null) {
                ArrayList<BufrConfig.BufrStation> stations = new ArrayList<BufrConfig.BufrStation>(smaps.values());
                Collections.sort(stations);
                for (BufrConfig.BufrStation s : stations) {
                    indexBuilder.addStations(this.buildStation(s));
                }
            }
            BufrCdmIndexProto.BufrIndex index = indexBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt(raf, b.length);
            raf.write(b);
            log.debug("  file size =  %d bytes", (Object)raf.length());
            boolean bl = true;
            return bl;
        }
    }

    public static boolean writeIndex(BufrCdmIndex index, BufrField root, File indexFile) throws IOException {
        if (indexFile.exists() && !indexFile.delete()) {
            log.warn(" BufrCdmIndex cant delete index file {}", (Object)indexFile.getPath());
        }
        log.debug(" createIndex for {}", (Object)indexFile.getPath());
        try (RandomAccessFile raf = new RandomAccessFile(indexFile.getPath(), "rw");){
            raf.order(0);
            raf.write(MAGIC_START.getBytes(CDM.utf8Charset));
            raf.writeInt(1);
            BufrCdmIndexProto.BufrIndex.Builder indexBuilder = BufrCdmIndexProto.BufrIndex.newBuilder();
            indexBuilder.setFilename(index.bufrFilename);
            BufrCdmIndexProto.Field rootf = BufrCdmIndex.buildField(root);
            indexBuilder.setRoot(rootf);
            indexBuilder.setStart(index.start);
            indexBuilder.setEnd(index.end);
            indexBuilder.setNobs(index.nobs);
            if (index.stations != null) {
                for (BufrCdmIndexProto.Station s : index.stations) {
                    indexBuilder.addStations(s);
                }
            }
            BufrCdmIndexProto.BufrIndex indexOut = indexBuilder.build();
            byte[] b = indexOut.toByteArray();
            NcStream.writeVInt(raf, b.length);
            raf.write(b);
            log.debug("  write BufrCdmIndexProto= {} bytes", (Object)b.length);
            log.debug("  file size =  %d bytes", (Object)raf.length());
            boolean bl = true;
            return bl;
        }
    }

    private BufrCdmIndexProto.Station buildStation(BufrConfig.BufrStation s) {
        BufrCdmIndexProto.Station.Builder builder = BufrCdmIndexProto.Station.newBuilder();
        builder.setId(s.getName());
        builder.setCount(s.count);
        if (s.getWmoId() != null) {
            builder.setWmoId(s.getWmoId());
        }
        if (s.getDescription() != null) {
            builder.setDesc(s.getDescription());
        }
        builder.setLat(s.getLatitude());
        builder.setLon(s.getLongitude());
        builder.setAlt(s.getAltitude());
        return builder.build();
    }

    private static BufrCdmIndexProto.Field buildField(BufrField fld) {
        BufrCdmIndexProto.Field.Builder fldBuilder = BufrCdmIndexProto.Field.newBuilder();
        fldBuilder.setFxy(fld.getFxy());
        fldBuilder.setScale(fld.getScale());
        fldBuilder.setReference(fld.getReference());
        fldBuilder.setBitWidth(fld.getBitWidth());
        if (fld.getName() != null) {
            fldBuilder.setName(fld.getName());
        }
        if (fld.getDesc() != null) {
            fldBuilder.setDesc(fld.getDesc());
        }
        if (fld.getUnits() != null) {
            fldBuilder.setUnits(fld.getUnits());
        }
        if (fld.getChildren() != null) {
            for (BufrField bufrField : fld.getChildren()) {
                fldBuilder.addFlds(BufrCdmIndex.buildField(bufrField));
            }
        }
        if (fld.getAction() != null && fld.getAction() != BufrCdmIndexProto.FldAction.none) {
            fldBuilder.setAction(fld.getAction());
        }
        if (fld.getType() != null) {
            fldBuilder.setType(fld.getType());
        }
        if (fld.isSeq()) {
            fldBuilder.setMin(fld.getMin());
            fldBuilder.setMax(fld.getMax());
        }
        return fldBuilder.build();
    }

    protected boolean readIndex(RandomAccessFile raf) throws IOException {
        this.idxFilename = raf.getLocation();
        try {
            boolean versionOk;
            raf.order(0);
            raf.seek(0L);
            if (!NcStream.readAndTest(raf, MAGIC_START.getBytes(CDM.utf8Charset))) {
                log.error("BufrCdmIndex {}: invalid index", (Object)raf.getLocation());
                return false;
            }
            int indexVersion = raf.readInt();
            boolean bl = versionOk = indexVersion == 1;
            if (!versionOk) {
                log.warn("BufrCdmIndex {}: index found version={}, want version= {}", raf.getLocation(), indexVersion, 1);
                return false;
            }
            int size = NcStream.readVInt(raf);
            if (size < 0 || size > 100000000) {
                log.warn("BufrCdmIndex {}: invalid or empty index ", (Object)raf.getLocation());
                return false;
            }
            byte[] m = new byte[size];
            raf.readFully(m);
            BufrCdmIndexProto.BufrIndex proto = BufrCdmIndexProto.BufrIndex.parseFrom(m);
            this.bufrFilename = proto.getFilename();
            this.root = proto.getRoot();
            this.stations = proto.getStationsList();
            this.start = proto.getStart();
            this.end = proto.getEnd();
            this.nobs = proto.getNobs();
        }
        catch (Throwable t) {
            log.error("Error reading index " + raf.getLocation(), t);
            return false;
        }
        return true;
    }

    static void showProtoRoot(BufrCdmIndexProto.Field fld) {
        String act = fld.getAction() != BufrCdmIndexProto.FldAction.defa ? fld.getAction().toString() : "-";
        System.out.printf("%10s %s%n", act, fld.getName());
        for (BufrCdmIndexProto.Field child : fld.getFldsList()) {
            BufrCdmIndex.showProtoRoot(child);
        }
    }

    public void showIndex(Formatter f) {
        f.format("BufrCdmIndex %n", new Object[0]);
        f.format("  idxFilename=%s%n", this.idxFilename);
        f.format("  bufrFilename=%s%n", this.bufrFilename);
        f.format("  dates=[%s,%s]%n", CalendarDate.of(this.start), CalendarDate.of(this.end));
        f.format("  nobs=%s%n", this.nobs);
        if (this.stations != null) {
            f.format("  # stations=%d%n", this.stations.size());
            int count = 0;
            for (BufrCdmIndexProto.Station s : this.stations) {
                count += s.getCount();
            }
            f.format("  # stations obs=%d%n", count);
        }
    }
}

