/*
 * Decompiled with CFR 0.152.
 */
package opendap.servers.parsers;

import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DFloat64;
import opendap.dap.DInt32;
import opendap.dap.DString;
import opendap.dap.NoSuchFunctionException;
import opendap.dap.NoSuchVariableException;
import opendap.servers.DAP2ServerSideException;
import opendap.servers.ServerMethods;
import opendap.servers.SubClause;
import opendap.servers.parsers.AST;
import opendap.servers.parsers.ASTvalue;

class ASTconstant
extends ASTvalue {
    int tag = 0;
    String text = null;
    long intvalue = 0L;
    double floatvalue = 0.0;

    public ASTconstant(List<AST> nodes) {
        super(nodes);
    }

    @Override
    SubClause translate() throws DAP2ServerSideException, DAP2Exception, NoSuchFunctionException, NoSuchVariableException {
        SubClause subclause = null;
        switch (this.tag) {
            case 24: {
                String s = String.format("%d", this.intvalue);
                DInt32 i = this.getFactory().newDInt32(s);
                i.setValue((int)this.intvalue);
                ((ServerMethods)i).setRead(true);
                ((ServerMethods)i).setProject(true);
                subclause = this.getClauseFactory().newValueClause((BaseType)i, false);
                break;
            }
            case 25: {
                String s = String.format("%.1f", this.floatvalue);
                DFloat64 f = this.getFactory().newDFloat64(s);
                f.setValue(this.floatvalue);
                subclause = this.getClauseFactory().newValueClause((BaseType)f, false);
                break;
            }
            case 23: {
                DString s = this.getFactory().newDString(this.text);
                s.setValue(this.text);
                ((ServerMethods)s).setRead(true);
                ((ServerMethods)s).setProject(true);
                subclause = this.getClauseFactory().newValueClause((BaseType)s, false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return subclause;
    }
}

