/*
 * Decompiled with CFR 0.152.
 */
package opendap.servers;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.BaseType;
import opendap.dap.ConstraintException;
import opendap.dap.DAP2Exception;
import opendap.dap.DArrayDimension;
import opendap.dap.NoSuchFunctionException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.parsers.ParseException;
import opendap.servers.Clause;
import opendap.servers.ClauseFactory;
import opendap.servers.DAP2ServerSideException;
import opendap.servers.InvalidOperatorException;
import opendap.servers.InvalidParameterException;
import opendap.servers.SBHException;
import opendap.servers.SDArray;
import opendap.servers.SDGrid;
import opendap.servers.ServerDDS;
import opendap.servers.ServerMethods;
import opendap.servers.TopLevelClause;
import opendap.servers.WrongTypeException;
import opendap.servers.parsers.CeParser;
import opendap.servlet.ReqState;
import opendap.util.Debug;

public class CEEvaluator {
    private static boolean _Debug;
    private ServerDDS _dds;
    private Vector<Clause> _cv;
    private ClauseFactory clauseFactory;

    public CEEvaluator(ServerDDS dds) {
        this._dds = dds;
        this._cv = new Vector();
        _Debug = Debug.isSet((String)"CE");
        if (_Debug) {
            System.out.println("CE debugging enabled.");
        }
    }

    public CEEvaluator(ServerDDS dds, ClauseFactory clauseFactory) {
        this._dds = dds;
        this._cv = new Vector();
        _Debug = Debug.isSet((String)"CE");
        if (_Debug) {
            System.out.println("CE debugging enabled.");
        }
        this.clauseFactory = clauseFactory;
        _Debug = Debug.isSet((String)"CEEvaluator");
    }

    public ServerDDS getDDS() {
        return this._dds;
    }

    public void parseConstraint(String constraint, String urlencoded) throws ParseException, DAP2Exception, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, InvalidParameterException, SBHException, WrongTypeException {
        if (this.clauseFactory == null) {
            this.clauseFactory = new ClauseFactory();
        }
        try {
            CeParser.constraint_expression(this, this._dds.getFactory(), this.clauseFactory, constraint, urlencoded);
        }
        catch (ConstraintException ce) {
            ce.printStackTrace();
            throw new DAP2Exception((Exception)((Object)ce));
        }
        if (_Debug) {
            int it = 0;
            Enumeration ec = this.getClauses();
            System.out.println("Results of clause parsing:");
            if (!ec.hasMoreElements()) {
                System.out.println("    No Clauses Found.");
            }
            while (ec.hasMoreElements()) {
                System.out.println("    Clause " + ++it + ": " + String.valueOf(ec.nextElement()));
            }
        }
    }

    public void parseConstraint(ReqState rs) throws ParseException, DAP2Exception, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, InvalidParameterException, SBHException, WrongTypeException {
        this.parseConstraint(rs.getConstraintExpression(), rs.getRequestURL().toString());
    }

    public void appendClause(Clause c) {
        if (c != null) {
            this._cv.add(c);
        }
    }

    public boolean removeClause(Clause c) {
        if (c != null) {
            return this._cv.remove(c);
        }
        return false;
    }

    public final Enumeration getClauses() {
        return this._cv.elements();
    }

    public void send(String dataset, OutputStream sink, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        Enumeration e = this._dds.getVariables();
        while (e.hasMoreElements()) {
            ServerMethods s = (ServerMethods)e.nextElement();
            if (_Debug) {
                System.out.println("Sending variable: " + ((BaseType)s).getEncodedName());
            }
            if (!s.isProject()) continue;
            if (_Debug) {
                System.out.println("Calling " + ((BaseType)s).getTypeName() + ".serialize() (Name: " + ((BaseType)s).getEncodedName() + ")");
            }
            s.serialize(dataset, (DataOutputStream)sink, this, specialO);
        }
    }

    public boolean evalClauses(Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        boolean result = true;
        Enumeration ec = this.getClauses();
        while (ec.hasMoreElements() && result) {
            Object o = ec.nextElement();
            if (_Debug) {
                System.out.println("Evaluating clause: " + String.valueOf(ec.nextElement()));
            }
            result = ((TopLevelClause)o).evaluate();
        }
        return result;
    }

    public void markAll(boolean state) throws DAP2Exception, NoSuchVariableException, SBHException {
        Enumeration e = this._dds.getVariables();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (state) {
                if (o instanceof SDArray) {
                    SDArray SDA = (SDArray)o;
                    Enumeration eSDA = SDA.getDimensions();
                    while (eSDA.hasMoreElements()) {
                        DArrayDimension dad = (DArrayDimension)eSDA.nextElement();
                        dad.setProjection(0, 1, dad.getSize() - 1);
                    }
                } else if (o instanceof SDGrid) {
                    SDGrid SDG = (SDGrid)o;
                    SDArray sdgA = (SDArray)SDG.getVar(0);
                    Enumeration eSDA = sdgA.getDimensions();
                    while (eSDA.hasMoreElements()) {
                        DArrayDimension dad = (DArrayDimension)eSDA.nextElement();
                        dad.setProjection(0, 1, dad.getSize() - 1);
                    }
                }
            }
            ServerMethods s = (ServerMethods)o;
            s.setProject(state);
        }
    }

    public void printConstraint(PrintWriter pw) {
        Enumeration ec = this.getClauses();
        boolean first = true;
        while (ec.hasMoreElements()) {
            Clause cl = (Clause)ec.nextElement();
            if (!first) {
                pw.print(" & ");
            }
            cl.printConstraint(pw);
            first = false;
        }
        pw.flush();
    }
}

