/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parsers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DDS;
import opendap.dap.DGrid;
import opendap.dap.DSequence;
import opendap.dap.parsers.Daplex;
import opendap.dap.parsers.ParseException;
import ucar.nc2.util.net.EscapeStrings;

public abstract class Dapparse {
    public static final int DapNUL = 0;
    public static final int DapDAS = 1;
    public static final int DapDDS = 2;
    public static final int DapERR = 3;
    static final int NA = 1;
    BaseTypeFactory factory = null;
    Daplex lexstate = null;
    Dapparse parsestate = this;
    DDS ddsobject = null;
    DAS dasobject = null;
    DAP2Exception errobject = null;
    int parseClass = 0;
    protected int dapdebug = 0;

    public Dapparse() {
        this(null);
    }

    public Dapparse(BaseTypeFactory factory) {
        if (factory == null) {
            throw new RuntimeException("Dapparse: no factory specified");
        }
        this.factory = factory;
    }

    public abstract boolean parse(String var1) throws ParseException;

    public abstract int getDebugLevel();

    public abstract void setDebugLevel(int var1);

    public abstract void setURL(String var1);

    public abstract String getURL();

    String strdup(String s) {
        return s;
    }

    public DDS getDDS() {
        return this.ddsobject;
    }

    public DAS getDAS() {
        return this.dasobject;
    }

    public DAP2Exception getERR() {
        return this.errobject;
    }

    public int dapparse(String text, DDS dds, DAS das, DAP2Exception err) throws ParseException {
        this.ddsobject = dds;
        this.dasobject = das;
        this.errobject = err == null ? new DAP2Exception() : err;
        this.dapdebug = this.getDebugLevel();
        Boolean accept = this.parse(text);
        return this.parseClass;
    }

    public int ddsparse(String text, DDS dds) throws ParseException {
        return this.dapparse(text, dds, null, null);
    }

    public int dasparse(String text, DAS das) throws ParseException {
        return this.dapparse(text, null, das, null);
    }

    public int errparse(String text, DAP2Exception err) throws ParseException {
        return this.dapparse(text, null, null, err);
    }

    void tagparse(Dapparse parsestate, int kind) throws ParseException {
        String expected = this.parseactual();
        switch (kind) {
            case 263: {
                this.parseClass = 2;
                if (this.ddsobject != null) break;
                throw new ParseException("DapParse: found DDS, expected " + expected);
            }
            case 260: {
                this.parseClass = 1;
                if (this.dasobject == null) {
                    throw new ParseException("DapParse: found DAS, expected " + this.parseactual());
                }
                this.lexstate.dassetup();
                break;
            }
            case 265: {
                this.parseClass = 3;
                if (this.errobject != null) break;
                throw new ParseException("DapParse: found error{}, expected " + this.parseactual());
            }
            default: {
                throw new ParseException("Unknown tag argument: " + kind);
            }
        }
    }

    private String parseactual() {
        String actual = "";
        if (this.ddsobject != null) {
            actual = actual + " DDS";
        }
        if (this.dasobject != null) {
            actual = actual + " DAS";
        }
        if (this.errobject != null) {
            actual = actual + " error{}";
        }
        return "one of" + actual;
    }

    Object datasetbody(Dapparse state, Object name, Object decls) throws ParseException {
        this.ddsobject.setEncodedName((String)name);
        for (Object o : (List)decls) {
            this.ddsobject.addVariable((BaseType)o);
        }
        if (this.dapdebug > 0) {
            System.err.println("datasetbody: |");
            this.ddsobject.print(System.err);
            System.err.println("|");
        }
        return null;
    }

    Object attributebody(Dapparse state, Object attrlist) throws ParseException {
        try {
            for (Object o : (List)attrlist) {
                if (o instanceof Attribute) {
                    Attribute a = (Attribute)o;
                    Iterator it = a.getValuesIterator();
                    while (it.hasNext()) {
                        this.dasobject.appendAttribute(a.getEncodedName(), a.getType(), (String)it.next());
                    }
                    continue;
                }
                if (o instanceof AttributeTable) {
                    AttributeTable aset = (AttributeTable)o;
                    this.dasobject.addAttributeTable(aset.getEncodedName(), aset);
                    continue;
                }
                throw new Exception("attribute body: unknown object: " + o);
            }
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        return null;
    }

    void errorbody(Dapparse state, Object code, Object msg, Object ptype, Object prog) throws ParseException {
        int n;
        this.errobject.setErrorMessage(msg.toString());
        this.errobject.setProgramSource((String)prog);
        try {
            n = code == null ? -1 : Integer.decode((String)code);
            this.errobject.setErrorCode(n);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Error code is not a legal integer");
        }
        try {
            n = ptype == null ? -1 : Integer.decode((String)ptype);
            this.errobject.setProgramType(n);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Error program type is not a legal integer");
        }
    }

    void unrecognizedresponse(Dapparse state) throws ParseException {
        this.errorbody(state, "0", state.lexstate.text, null, null);
    }

    Object declarations(Dapparse state, Object decls, Object decl) throws ParseException {
        ArrayList<BaseType> alist = (ArrayList<BaseType>)decls;
        if (alist == null) {
            alist = new ArrayList<BaseType>();
        } else {
            alist.add((BaseType)decl);
        }
        return alist;
    }

    Object arraydecls(Dapparse state, Object arraydecls, Object arraydecl) throws ParseException {
        ArrayList<Object> alist = (ArrayList<Object>)arraydecls;
        if (alist == null) {
            alist = new ArrayList<Object>();
        } else {
            alist.add(arraydecl);
        }
        return alist;
    }

    Object arraydecl(Dapparse state, Object name, Object size) throws ParseException {
        int value;
        try {
            value = Integer.decode((String)size);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Dimension " + name + " is not an integer: " + size, nfe);
        }
        DArrayDimension dim = new DArrayDimension(value, this.clearName((String)name));
        return dim;
    }

    Object attrlist(Dapparse state, Object attrlist, Object attrtuple) throws ParseException {
        ArrayList<Object> alist = (ArrayList<Object>)attrlist;
        if (alist == null) {
            alist = new ArrayList<Object>();
        } else if (attrtuple != null) {
            alist.add(attrtuple);
            String dupname = this.scopeduplicates(alist);
            if (dupname != null) {
                this.dap_parse_error(state, "Duplicate attribute names in same scope: %s", dupname);
                alist.remove(alist.size() - 1);
            }
        }
        return alist;
    }

    Object attrvalue(Dapparse state, Object valuelist, Object value, Object etype) throws ParseException {
        ArrayList<Object> alist = (ArrayList<Object>)valuelist;
        if (alist == null) {
            alist = new ArrayList<Object>();
        }
        if (value == null) {
            value = "";
        }
        alist.add(value);
        return alist;
    }

    Object attribute(Dapparse state, Object name, Object values, Object etype) throws ParseException {
        int typ = (Integer)etype;
        Attribute att = new Attribute(this.clearName((String)name), this.attributetypefor((Integer)etype));
        try {
            for (Object o : (List)values) {
                if (typ == 274) {
                    att.appendValue(this.unescapeAttributeString((String)o), true);
                    continue;
                }
                att.appendValue((String)o, true);
            }
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        return att;
    }

    Object attrset(Dapparse state, Object name, Object attributes) throws ParseException {
        try {
            AttributeTable attset = new AttributeTable(this.clearName((String)name));
            for (Object o : (List)attributes) {
                if (o instanceof Attribute) {
                    Attribute a = (Attribute)o;
                    Iterator it = a.getValuesIterator();
                    while (it.hasNext()) {
                        attset.appendAttribute(a.getClearName(), a.getType(), (String)it.next());
                    }
                    continue;
                }
                if (o instanceof AttributeTable) {
                    AttributeTable at = (AttributeTable)o;
                    attset.addContainer(at.getEncodedName(), at);
                    continue;
                }
                throw new ParseException("attrset: unexpected object: " + o);
            }
            return attset;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    Object makebase(Dapparse state, Object name, Object etype, Object dimensions) throws ParseException {
        List dims = (List)dimensions;
        BaseType node = this.basetypefor((Integer)etype, (String)name);
        if (dims.size() > 0) {
            DArray array = state.factory.newDArray();
            array.addVariable(node);
            this.dimension(array, dims);
            node = array;
        }
        return node;
    }

    void dimension(DArray node, List<Object> dimensions) throws ParseException {
        int rank = dimensions.size();
        for (Object o : dimensions) {
            DArrayDimension dim = (DArrayDimension)o;
            node.appendDim(dim.getSize(), dim.getClearName());
        }
    }

    Object makestructure(Dapparse state, Object name, Object dimensions, Object fields) throws ParseException {
        List dimset = (List)dimensions;
        String dupname = this.scopeduplicates((List)fields);
        if (dupname != null) {
            this.dap_parse_error(state, "Duplicate structure field names in same scope: %s.%s", (String)name, dupname);
            return null;
        }
        BaseType node = this.factory.newDStructure(this.clearName((String)name));
        List list = (List)fields;
        for (Object o : list) {
            node.addVariable((BaseType)o, 1);
        }
        if (dimset.size() > 0) {
            DArray anode = this.factory.newDArray();
            anode.addVariable(node);
            this.dimension(anode, (List)dimensions);
            node = anode;
        }
        return node;
    }

    Object makesequence(Dapparse state, Object name, Object members) throws ParseException {
        String dupname = this.scopeduplicates((List)members);
        if (dupname != null) {
            this.dap_parse_error(state, "Duplicate sequence member names in same scope: %s.%s", (String)name, dupname);
            return null;
        }
        DSequence node = this.factory.newDSequence(this.clearName((String)name));
        List list = (List)members;
        for (Object o : list) {
            node.addVariable((BaseType)o, 1);
        }
        return node;
    }

    Object makegrid(Dapparse state, Object name, Object arraydecl0, Object mapdecls0) throws ParseException {
        DArray arraydecl = (DArray)arraydecl0;
        List mapdecls = (List)mapdecls0;
        String dupname = this.scopeduplicates(mapdecls);
        if (dupname != null) {
            this.dap_parse_error(state, "Duplicate grid map names in same scope: %s.%s", (String)name, dupname);
            return null;
        }
        DGrid node = this.factory.newDGrid(this.clearName((String)name));
        node.addVariable(arraydecl, 1);
        for (Object m : mapdecls) {
            node.addVariable((BaseType)m, 2);
        }
        return node;
    }

    String flatten(String s) {
        boolean whitespace = false;
        StringBuilder buf = new StringBuilder();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\t': {
                    buf.append(' ');
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    int daperror(Dapparse state, String msg) throws ParseException {
        this.dap_parse_error(state, msg, new Object[0]);
        return 0;
    }

    void dap_parse_error(Dapparse state, String fmt, Object ... args) throws ParseException {
        System.err.println(String.format(fmt, args));
        String tmp = null;
        int len = this.lexstate.getInput().length();
        tmp = this.flatten(this.lexstate.getInput());
        throw new ParseException("context: " + tmp + "^");
    }

    BaseType basetypefor(Integer etype, String name) throws ParseException {
        switch (etype) {
            case 261: {
                return this.factory.newDByte(this.clearName(name));
            }
            case 269: {
                return this.factory.newDInt16(this.clearName(name));
            }
            case 276: {
                return this.factory.newDUInt16(this.clearName(name));
            }
            case 270: {
                return this.factory.newDInt32(this.clearName(name));
            }
            case 277: {
                return this.factory.newDUInt32(this.clearName(name));
            }
            case 266: {
                return this.factory.newDFloat32(this.clearName(name));
            }
            case 267: {
                return this.factory.newDFloat64(this.clearName(name));
            }
            case 278: {
                return this.factory.newDURL(this.clearName(name));
            }
            case 274: {
                return this.factory.newDString(this.clearName(name));
            }
        }
        throw new ParseException("basetypefor: illegal type: " + etype);
    }

    int attributetypefor(Integer etype) throws ParseException {
        switch (etype) {
            case 261: {
                return 3;
            }
            case 269: {
                return 4;
            }
            case 276: {
                return 5;
            }
            case 270: {
                return 6;
            }
            case 277: {
                return 7;
            }
            case 266: {
                return 8;
            }
            case 267: {
                return 9;
            }
            case 278: {
                return 11;
            }
            case 274: {
                return 10;
            }
        }
        throw new ParseException("attributetypefor: illegal type: " + etype);
    }

    String scopeduplicates(List<Object> list) throws ParseException {
        for (int i = 0; i < list.size(); ++i) {
            Object io = list.get(i);
            String iname = this.extractname(io);
            for (int j = i + 1; j < list.size(); ++j) {
                Object jo = list.get(j);
                String jname = this.extractname(jo);
                if (!iname.equals(jname)) continue;
                return iname;
            }
        }
        return null;
    }

    String extractname(Object o) throws ParseException {
        if (o instanceof BaseType) {
            return ((BaseType)o).getClearName();
        }
        if (o instanceof Attribute) {
            return ((Attribute)o).getClearName();
        }
        if (o instanceof AttributeTable) {
            return ((AttributeTable)o).getClearName();
        }
        throw new ParseException("extractname: illegal object class: " + o);
    }

    String unescapeDAPName(Object name) {
        return EscapeStrings.unescapeDAPIdentifier((String)((String)name));
    }

    String unescapeAttributeString(String s) {
        String news = "";
        for (char c : s.toCharArray()) {
            if (c == '\\') continue;
            news = news + c;
        }
        return news;
    }

    String clearName(String name) {
        return name;
    }
}

