/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.parsers.ParseException;
import opendap.servers.CEEvaluator;
import opendap.servers.ServerDDS;
import opendap.servlet.AsciiWriter;
import opendap.servlet.GetDirHandler;
import opendap.servlet.GetHTMLInterfaceHandler;
import opendap.servlet.GetInfoHandler;
import opendap.servlet.GuardedDataset;
import opendap.servlet.ReqState;
import opendap.util.Debug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.EscapeStrings;

public abstract class AbstractServlet
extends HttpServlet {
    public static Logger log = LoggerFactory.getLogger(AbstractServlet.class);
    protected boolean allowDeflate = true;
    private boolean track = false;
    private Object syncLock = new Object();
    private int HitCounter = 0;
    private ServletConfig servletConfig = null;
    private ServletContext servletContext = null;
    private String rootpath = null;
    private ArrayList prArr = null;

    public static void setLog(Class cl) {
        log = LoggerFactory.getLogger((Class)cl);
    }

    public static void printDODSException(DAP2Exception de) {
        de.printStackTrace();
    }

    public static void printThrowable(Throwable t) {
        log.error(t.getMessage());
        t.printStackTrace();
    }

    public String getRootPath() {
        return this.rootpath;
    }

    public abstract String getServerVersion();

    public abstract String getDefaultContextPath();

    protected abstract GuardedDataset getDataset(ReqState var1) throws Exception;

    public void init() throws ServletException {
        super.init();
        String debugOn = this.getInitParameter("DebugOn");
        if (debugOn != null) {
            StringTokenizer toker = new StringTokenizer(debugOn);
            while (toker.hasMoreTokens()) {
                Debug.set(toker.nextToken(), true);
            }
        }
        this.servletConfig = this.getServletConfig();
        this.servletContext = this.servletConfig.getServletContext();
        this.rootpath = this.servletContext.getRealPath("/");
    }

    public void parseExceptionHandler(ParseException pe, HttpServletResponse response) {
        log.error("DODSServlet.parseExceptionHandler", (Throwable)pe);
        if (Debug.isSet("showException")) {
            log.debug(pe.toString());
            pe.printStackTrace();
            AbstractServlet.printThrowable(pe);
        }
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            String msg = pe.getMessage().replace('\"', '\'');
            DAP2Exception de2 = new DAP2Exception(5, msg);
            de2.print(eOut);
        }
        catch (IOException ioe) {
            log.error("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void dap2ExceptionHandler(DAP2Exception de, HttpServletResponse response) {
        log.info("DODSServlet.dodsExceptionHandler (" + de.getErrorCode() + ") " + de.getErrorMessage());
        if (Debug.isSet("showException")) {
            de.print(System.err);
            de.printStackTrace(System.err);
            AbstractServlet.printDODSException(de);
        }
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            de.print(eOut);
        }
        catch (IOException ioe) {
            log.error("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void IOExceptionHandler(IOException e, ReqState rs) {
        HttpServletResponse response = rs.getResponse();
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            String msg = e.getMessage();
            if (msg != null) {
                msg = msg.replace('\"', '\'');
            }
            DAP2Exception de2 = new DAP2Exception(5, msg);
            de2.print(eOut);
            if (Debug.isSet("showException")) {
                log.error("DODServlet ERROR (IOExceptionHandler): " + e);
                log.error(rs.toString());
                if (this.track) {
                    RequestDebug reqD = (RequestDebug)rs.getUserObject();
                    log.error("  request number: " + reqD.reqno + " thread: " + reqD.threadDesc);
                }
                e.printStackTrace();
                AbstractServlet.printThrowable(e);
            }
        }
        catch (IOException ioe) {
            log.error("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void anyExceptionHandler(Throwable e, ReqState rs) {
        if (rs == null) {
            boolean x = true;
        }
        HttpServletResponse response = rs.getResponse();
        try {
            log.error("DODServlet ERROR (anyExceptionHandler): " + e);
            log.error(rs.toString());
            if (this.track) {
                RequestDebug reqD = (RequestDebug)rs.getUserObject();
                log.error("  request number: " + reqD.reqno + " thread: " + reqD.threadDesc);
            }
            e.printStackTrace();
            AbstractServlet.printThrowable(e);
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            String msg = e.getMessage();
            if (msg != null) {
                msg = msg.replace('\"', '\'');
            }
            DAP2Exception de2 = new DAP2Exception(-1, msg);
            de2.print(eOut);
        }
        catch (IOException ioe) {
            log.error("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void sendDODSError(HttpServletRequest request, HttpServletResponse response, String clientMsg, String serverMsg) throws IOException, ServletException {
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-error");
        ServletOutputStream Out = response.getOutputStream();
        DAP2Exception de = new DAP2Exception(0, clientMsg);
        de.print((OutputStream)Out);
        response.setStatus(200);
        log.error(serverMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAS(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("doGetDAS for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            rs.getResponse().setContentType("text/plain");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-das");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)rs.getResponse().getOutputStream());
            DAS myDAS = ds.getDAS();
            myDAS.print(Out);
            rs.getResponse().setStatus(200);
            if (Debug.isSet("showResponse")) {
                // empty if block
            }
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDS(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("doGetDDS for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            rs.getResponse().setContentType("text/plain");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-dds");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)rs.getResponse().getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.print(Out);
                ((OutputStream)Out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(Out));
                myDDS.printConstrained(pw);
                pw.flush();
            }
            rs.getResponse().setStatus(200);
            if (Debug.isSet("showResponse")) {
                if (rs.getConstraintExpression().equals("")) {
                    log.debug("Unconstrained DDS=\n");
                } else {
                    log.debug("Constrained DDS=\n");
                }
            }
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDX(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("doGetDDX for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            rs.getResponse().setContentType("text/plain");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-ddx");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)rs.getResponse().getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.printXML(Out);
                ((OutputStream)Out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(Out));
                myDDS.printConstrainedXML(pw);
                pw.flush();
            }
            rs.getResponse().setStatus(200);
            if (Debug.isSet("showResponse")) {
                if (rs.getConstraintExpression().equals("")) {
                    log.debug("Unconstrained DDX=\n");
                    myDDS.printXML(System.out);
                } else {
                    log.debug("Constrained DDX=\n");
                    myDDS.printConstrainedXML(System.out);
                }
            }
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetBLOB(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("doGetBLOB For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            BufferedOutputStream bOut;
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            rs.getResponse().setContentType("application/octet-stream");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-blob");
            ServletOutputStream sOut = rs.getResponse().getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                rs.getResponse().setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            ce.parseConstraint(rs.getConstraintExpression(), rs.getRequestURL().toString());
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getEncodedName(), sink, ds);
            sink.flush();
            if (null != dOut) {
                dOut.finish();
            }
            ((OutputStream)bOut).flush();
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException ioe) {
            this.IOExceptionHandler(ioe, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAP2Data(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("doGetDAP2Data For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            BufferedOutputStream bOut;
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            rs.getResponse().setContentType("application/octet-stream");
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setHeader("Content-Description", "dods-data");
            ServletOutputStream sOut = rs.getResponse().getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                rs.getResponse().setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            ce.parseConstraint(rs);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(bOut));
            myDDS.printConstrained(pw);
            pw.flush();
            ((OutputStream)bOut).write("\nData:\n".getBytes());
            ((OutputStream)bOut).flush();
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getEncodedName(), sink, ds);
            sink.flush();
            if (null != dOut) {
                dOut.finish();
            }
            ((OutputStream)bOut).flush();
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException ioe) {
            this.IOExceptionHandler(ioe, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetDIR(ReqState rs) throws Exception {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("Content-Description", "dods-directory");
        try {
            GetDirHandler di = new GetDirHandler();
            di.sendDIR(rs);
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
    }

    public void doGetVER(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("Sending Version Tag.");
        }
        rs.getResponse().setContentType("text/plain");
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setHeader("Content-Description", "dods-version");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)rs.getResponse().getOutputStream()));
        pw.println("Server Version: " + this.getServerVersion());
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    public void doGetHELP(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("Sending Help Page.");
        }
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setHeader("Content-Description", "dods-help");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)rs.getResponse().getOutputStream()));
        this.printHelpPage(pw);
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    public void badURL(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("Sending Bad URL Page.");
        }
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setHeader("Content-Description", "dods-error");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)rs.getResponse().getOutputStream()));
        this.printBadURLPage(pw);
        this.printHelpPage(pw);
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetASC(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("doGetASC For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setContentType("text/plain");
            rs.getResponse().setHeader("Content-Description", "dods-ascii");
            boolean debug = false;
            if (debug) {
                log.debug("Sending OPeNDAP ASCII Data For: " + rs + "  CE: '" + rs.getConstraintExpression() + "'");
            }
            ServerDDS dds = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(dds);
            ce.parseConstraint(rs);
            PrintWriter pw = new PrintWriter((OutputStream)rs.getResponse().getOutputStream());
            dds.printConstrained(pw);
            pw.println("---------------------------------------------");
            AsciiWriter writer = new AsciiWriter();
            writer.toASCII(pw, dds, ds);
            pw.flush();
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetINFO(ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            log.debug("doGetINFO For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            PrintStream pw = new PrintStream((OutputStream)rs.getResponse().getOutputStream());
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setContentType("text/html");
            rs.getResponse().setHeader("Content-Description", "dods-description");
            GetInfoHandler di = new GetInfoHandler();
            di.sendINFO(pw, ds, rs);
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetHTML(ReqState rs) throws Exception {
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
            rs.getResponse().setContentType("text/html");
            rs.getResponse().setHeader("Content-Description", "dods-form");
            ServerDDS myDDS = ds.getDDS();
            DAS das = ds.getDAS();
            GetHTMLInterfaceHandler di = new GetHTMLInterfaceHandler();
            di.sendDataRequestForm(rs, rs.getDataSet(), myDDS, das);
            rs.getResponse().setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, rs.getResponse());
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, rs.getResponse());
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetCatalog(ReqState rs) throws Exception {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/xml");
        rs.getResponse().setHeader("Content-Description", "dods-catalog");
        PrintWriter pw = new PrintWriter((OutputStream)rs.getResponse().getOutputStream());
        this.printCatalog(rs, pw);
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    protected void printCatalog(ReqState rs, PrintWriter os) throws IOException {
        os.println("Catalog not available for this server");
        os.println("Server version = " + this.getServerVersion());
    }

    public void doDebug(ReqState rs) throws IOException {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("Content-Description", "dods_debug");
        PrintStream pw = new PrintStream((OutputStream)rs.getResponse().getOutputStream());
        pw.println("<title>Debugging</title>");
        pw.println("<body><pre>");
        StringTokenizer tz = new StringTokenizer(rs.getConstraintExpression(), "=;");
        while (tz.hasMoreTokens()) {
            String cmd = tz.nextToken();
            pw.println("Cmd= " + cmd);
            if (cmd.equals("help")) {
                pw.println(" help;log;logEnd;logShow");
                pw.println(" showFlags;showInitParameters;showRequest");
                pw.println(" on|off=(flagName)");
                this.doDebugCmd(cmd, tz, pw);
                continue;
            }
            if (cmd.equals("on")) {
                Debug.set(tz.nextToken(), true);
                continue;
            }
            if (cmd.equals("off")) {
                Debug.set(tz.nextToken(), false);
                continue;
            }
            if (cmd.equals("showFlags")) {
                for (String key : Debug.keySet()) {
                    pw.println("  " + key + " " + Debug.isSet(key));
                }
                continue;
            }
            if (cmd.equals("showInitParameters")) {
                pw.println(rs.toString());
                continue;
            }
            if (cmd.equals("showRequest")) {
                this.probeRequest(pw, rs);
                continue;
            }
            if (this.doDebugCmd(cmd, tz, pw)) continue;
            pw.println("  unrecognized command");
        }
        pw.println("--------------------------------------");
        pw.println("Logging is on");
        for (String key : Debug.keySet()) {
            boolean val = Debug.isSet(key);
            if (!val) continue;
            pw.println("  " + key + " " + Debug.isSet(key));
        }
        pw.println("</pre></body>");
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    protected boolean doDebugCmd(String cmd, StringTokenizer tz, PrintStream pw) {
        return false;
    }

    public void doGetSystemProps(ReqState rs) throws Exception {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("Content-Description", "dods-status");
        PrintWriter pw = new PrintWriter((OutputStream)rs.getResponse().getOutputStream());
        pw.println("<html>");
        pw.println("<title>System Properties</title>");
        pw.println("<hr>");
        pw.println("<body><h2>System Properties</h2>");
        pw.println("<h3>Date: " + new Date() + "</h3>");
        Properties sysp = System.getProperties();
        Enumeration<?> e = sysp.propertyNames();
        pw.println("<ul>");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = System.getProperty(name);
            pw.println("<li>" + name + ": " + value + "</li>");
        }
        pw.println("</ul>");
        pw.println("<h3>Runtime Info:</h3>");
        Runtime rt = Runtime.getRuntime();
        pw.println("JVM Max Memory:   " + (double)(rt.maxMemory() / 1024L) / 1000.0 + " MB (JVM Maximum Allowable Heap)<br>");
        pw.println("JVM Total Memory: " + (double)(rt.totalMemory() / 1024L) / 1000.0 + " MB (JVM Heap size)<br>");
        pw.println("JVM Free Memory:  " + (double)(rt.freeMemory() / 1024L) / 1000.0 + " MB (Unused part of heap)<br>");
        pw.println("JVM Used Memory:  " + (double)((rt.totalMemory() - rt.freeMemory()) / 1024L) / 1000.0 + " MB (Currently active memory)<br>");
        pw.println("<hr>");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    public void doGetStatus(ReqState rs) throws Exception {
        rs.getResponse().setHeader("XDODS-Server", this.getServerVersion());
        rs.getResponse().setContentType("text/html");
        rs.getResponse().setHeader("Content-Description", "dods-status");
        PrintWriter pw = new PrintWriter((OutputStream)rs.getResponse().getOutputStream());
        pw.println("<title>Server Status</title>");
        pw.println("<body><ul>");
        this.printStatus(pw);
        pw.println("</ul></body>");
        pw.flush();
        rs.getResponse().setStatus(200);
    }

    protected void printStatus(PrintWriter os) throws IOException {
        os.println("<h2>Server version = " + this.getServerVersion() + "</h2>");
        os.println("<h2>Number of Requests Received = " + this.HitCounter + "</h2>");
        if (this.track) {
            int n = this.prArr.size();
            int pending = 0;
            String preqs = "";
            for (int i = 0; i < n; ++i) {
                ReqState rs = (ReqState)this.prArr.get(i);
                RequestDebug reqD = (RequestDebug)rs.getUserObject();
                if (rs == null || reqD.done) continue;
                preqs = preqs + "<pre>-----------------------\n";
                preqs = preqs + "Request[" + reqD.reqno + "](" + reqD.threadDesc + ") is pending.\n";
                preqs = preqs + rs.toString();
                preqs = preqs + "</pre>";
                ++pending;
            }
            os.println("<h2>" + pending + " Pending Request(s)</h2>");
            os.println(preqs);
        }
    }

    public void probeRequest(PrintStream ps, ReqState rs) {
        String s;
        ps.println("####################### PROBE ##################################");
        ps.println("The HttpServletRequest object is actually a: " + rs.getRequest().getClass().getName());
        ps.println("");
        ps.println("HttpServletRequest Interface:");
        ps.println("    getAuthType:           " + rs.getRequest().getAuthType());
        ps.println("    getMethod:             " + rs.getRequest().getMethod());
        ps.println("    getPathInfo:           " + rs.getRequest().getPathInfo());
        ps.println("    getPathTranslated:     " + rs.getRequest().getPathTranslated());
        ps.println("    getRequestURL:         " + rs.getRequest().getRequestURL());
        ps.println("    getQueryString:        " + rs.getRequest().getQueryString());
        ps.println("    getRemoteUser:         " + rs.getRequest().getRemoteUser());
        ps.println("    getRequestedSessionId: " + rs.getRequest().getRequestedSessionId());
        ps.println("    getRequestURI:         " + rs.getRequest().getRequestURI());
        ps.println("    getServletPath:        " + rs.getRequest().getServletPath());
        ps.println("    isRequestedSessionIdFromCookie: " + rs.getRequest().isRequestedSessionIdFromCookie());
        ps.println("    isRequestedSessionIdValid:      " + rs.getRequest().isRequestedSessionIdValid());
        ps.println("    isRequestedSessionIdFromURL:    " + rs.getRequest().isRequestedSessionIdFromURL());
        ps.println("");
        int i = 0;
        Enumeration e = rs.getRequest().getHeaderNames();
        ps.println("    Header Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Header[" + ++i + "]: " + s);
            ps.println(": " + rs.getRequest().getHeader(s));
        }
        ps.println("");
        ps.println("ServletRequest Interface:");
        ps.println("    getCharacterEncoding:  " + rs.getRequest().getCharacterEncoding());
        ps.println("    getContentType:        " + rs.getRequest().getContentType());
        ps.println("    getContentLength:      " + rs.getRequest().getContentLength());
        ps.println("    getProtocol:           " + rs.getRequest().getProtocol());
        ps.println("    getScheme:             " + rs.getRequest().getScheme());
        ps.println("    getServerName:         " + rs.getRequest().getServerName());
        ps.println("    getServerPort:         " + rs.getRequest().getServerPort());
        ps.println("    getRemoteAddr:         " + rs.getRequest().getRemoteAddr());
        ps.println("    getRemoteHost:         " + rs.getRequest().getRemoteHost());
        ps.println(".............................");
        ps.println("");
        i = 0;
        e = rs.getRequest().getAttributeNames();
        ps.println("    Attribute Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Attribute[" + ++i + "]: " + s);
            ps.println(" Type: " + rs.getRequest().getAttribute(s));
        }
        ps.println(".............................");
        ps.println("");
        i = 0;
        e = rs.getRequest().getParameterNames();
        ps.println("    Parameter Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Parameter[" + ++i + "]: " + s);
            ps.println(" Value: " + rs.getRequest().getParameter(s));
        }
        ps.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        ps.println(" . . . . . . . . . Servlet Infomation API  . . . . . . . . . . . . . .");
        ps.println("");
        ps.println("Servlet Context:");
        ps.println("");
        i = 0;
        e = this.servletContext.getAttributeNames();
        ps.println("    Attribute Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Attribute[" + ++i + "]: " + s);
            ps.println(" Type: " + this.servletContext.getAttribute(s));
        }
        ps.println("    ServletContext.getRealPath(\".\"): " + this.servletContext.getRealPath("."));
        ps.println("    ServletContext.getMajorVersion(): " + this.servletContext.getMajorVersion());
        ps.println("    ServletContext.getMinorVersion(): " + this.servletContext.getMinorVersion());
        ps.println(".............................");
        ps.println("Servlet Config:");
        ps.println("");
        ServletConfig scnfg = this.getServletConfig();
        i = 0;
        e = scnfg.getInitParameterNames();
        ps.println("    InitParameters:");
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            ps.print("        InitParameter[" + i + "]: " + p);
            ps.println(" Value: " + scnfg.getInitParameter(p));
            ++i;
        }
        ps.println("");
        ps.println("######################## END PROBE ###############################");
        ps.println("");
    }

    public String getServerName() {
        String servletName = ((Object)((Object)this)).getClass().getName();
        return servletName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        boolean isDebug = false;
        ReqState rs = null;
        RequestDebug reqD = null;
        try {
            Object ds;
            if (Debug.isSet("probeRequest")) {
                this.probeRequest(System.out, rs);
            }
            if ((rs = this.getRequestState(request, rs.getResponse())) != null) {
                ds = rs.getDataSet();
                String suff = rs.getRequestSuffix();
                isDebug = ds != null && ((String)ds).equals("debug") && suff != null && suff.equals("");
            }
            ds = this.syncLock;
            synchronized (ds) {
                if (!isDebug) {
                    long reqno = this.HitCounter++;
                    if (this.track) {
                        reqD = new RequestDebug(reqno, Thread.currentThread().toString());
                        rs.setUserObject(reqD);
                        if (this.prArr == null) {
                            this.prArr = new ArrayList(10000);
                        }
                        this.prArr.add((int)reqno, rs);
                    }
                    if (Debug.isSet("showRequest")) {
                        log.debug("-------------------------------------------");
                        log.debug("Server: " + this.getServerName() + "   Request #" + reqno);
                        log.debug("Client: " + rs.getRequest().getRemoteHost());
                        log.debug(rs.toString());
                        log.debug("Request dataset: '" + rs.getDataSet() + "' suffix: '" + rs.getRequestSuffix() + "' CE: '" + rs.getConstraintExpression() + "'");
                    }
                }
            }
            if (rs != null) {
                String dataSet = rs.getDataSet();
                String requestSuffix = rs.getRequestSuffix();
                if (dataSet == null) {
                    this.doGetDIR(rs);
                } else if (dataSet.equals("/")) {
                    this.doGetDIR(rs);
                } else if (dataSet.equals("")) {
                    this.doGetDIR(rs);
                } else if (dataSet.equalsIgnoreCase("/version") || dataSet.equalsIgnoreCase("/version/")) {
                    this.doGetVER(rs);
                } else if (dataSet.equalsIgnoreCase("/help") || dataSet.equalsIgnoreCase("/help/")) {
                    this.doGetHELP(rs);
                } else if (dataSet.equalsIgnoreCase("/" + requestSuffix)) {
                    this.doGetHELP(rs);
                } else if (requestSuffix.equalsIgnoreCase("dds")) {
                    this.doGetDDS(rs);
                } else if (requestSuffix.equalsIgnoreCase("das")) {
                    this.doGetDAS(rs);
                } else if (requestSuffix.equalsIgnoreCase("ddx")) {
                    this.doGetDDX(rs);
                } else if (requestSuffix.equalsIgnoreCase("blob")) {
                    this.doGetBLOB(rs);
                } else if (requestSuffix.equalsIgnoreCase("dods")) {
                    this.doGetDAP2Data(rs);
                } else if (requestSuffix.equalsIgnoreCase("asc") || requestSuffix.equalsIgnoreCase("ascii")) {
                    this.doGetASC(rs);
                } else if (requestSuffix.equalsIgnoreCase("info")) {
                    this.doGetINFO(rs);
                } else if (requestSuffix.equalsIgnoreCase("html") || requestSuffix.equalsIgnoreCase("htm")) {
                    this.doGetHTML(rs);
                } else if (requestSuffix.equalsIgnoreCase("ver") || requestSuffix.equalsIgnoreCase("version")) {
                    this.doGetVER(rs);
                } else if (requestSuffix.equalsIgnoreCase("help")) {
                    this.doGetHELP(rs);
                } else if (requestSuffix.equals("")) {
                    this.badURL(rs);
                } else {
                    this.badURL(rs);
                }
            } else {
                this.badURL(rs);
            }
            if (reqD != null) {
                reqD.done = true;
            }
        }
        catch (Throwable e) {
            this.anyExceptionHandler(e, rs);
        }
    }

    protected ReqState getRequestState(HttpServletRequest request, HttpServletResponse response) {
        ReqState rs = null;
        String baseurl = request.getRequestURL().toString();
        baseurl = EscapeStrings.unescapeURL((String)baseurl);
        String query = request.getQueryString();
        query = EscapeStrings.unescapeURLQuery((String)query);
        try {
            rs = new ReqState(request, response, this, this.getServerName(), baseurl, query);
        }
        catch (Exception bue) {
            rs = null;
        }
        return rs;
    }

    void showMemUsed(String from) {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        log.debug("****showMemUsed " + from);
        log.debug(" totalMemory " + totalMemory);
        log.debug(" freeMemory " + freeMemory);
        log.debug(" usedMemory " + usedMemory);
    }

    private void printHelpPage(PrintWriter pw) {
        pw.println("<h3>OPeNDAP Server Help</h3>");
        pw.println("To access most of the features of this OPeNDAP server, append");
        pw.println("one of the following a eight suffixes to a URL: .das, .dds, .dods, .ddx, .blob, .info,");
        pw.println(".ver or .help. Using these suffixes, you can ask this server for:");
        pw.println("<dl>");
        pw.println("<dt> das  </dt> <dd> Dataset Attribute Structure (DAS)</dd>");
        pw.println("<dt> dds  </dt> <dd> Dataset Descriptor Structure (DDS)</dd>");
        pw.println("<dt> dods </dt> <dd> DataDDS object (A constrained DDS populated with data)</dd>");
        pw.println("<dt> ddx  </dt> <dd> XML version of the DDS/DAS</dd>");
        pw.println("<dt> blob </dt> <dd> Serialized binary data content for requested data set, with the constraint expression applied.</dd>");
        pw.println("<dt> info </dt> <dd> info object (attributes, types and other information)</dd>");
        pw.println("<dt> html </dt> <dd> html form for this dataset</dd>");
        pw.println("<dt> ver  </dt> <dd> return the version number of the server</dd>");
        pw.println("<dt> help </dt> <dd> help information (this text)</dd>");
        pw.println("</dl>");
        pw.println("For example, to request the DAS object from the FNOC1 dataset at URI/GSO (a");
        pw.println("test dataset) you would appand `.das' to the URL:");
        pw.println("http://opendap.gso.url.edu/cgi-bin/nph-nc/data/fnoc1.nc.das.");
        pw.println("<p><b>Note</b>: Many OPeNDAP clients supply these extensions for you so you don't");
        pw.println("need to append them (for example when using interfaces supplied by us or");
        pw.println("software re-linked with a OPeNDAP client-library). Generally, you only need to");
        pw.println("add these if you are typing a URL directly into a WWW browser.");
        pw.println("<p><b>Note</b>: If you would like version information for this server but");
        pw.println("don't know a specific data file or data set name, use `/version' for the");
        pw.println("filename. For example: http://opendap.gso.url.edu/cgi-bin/nph-nc/version will");
        pw.println("return the version number for the netCDF server used in the first example. ");
        pw.println("<p><b>Suggestion</b>: If you're typing this URL into a WWW browser and");
        pw.println("would like information about the dataset, use the `.info' extension.");
        pw.println("<p>If you'd like to see a data values, use the `.html' extension and submit a");
        pw.println("query using the customized form.");
    }

    private void printBadURLPage(PrintWriter pw) {
        pw.println("<h3>Error in URL</h3>");
        pw.println("The URL extension did not match any that are known by this");
        pw.println("server. Below is a list of the five extensions that are be recognized by");
        pw.println("all OPeNDAP servers. If you think that the server is broken (that the URL you");
        pw.println("submitted should have worked), then please contact the");
        pw.println("OPeNDAP user support coordinator at: ");
        pw.println("<a href=\"mailto:support@unidata.ucar.edu\">support@unidata.ucar.edu</a><p>");
    }

    private class RequestDebug {
        long reqno;
        String threadDesc;
        boolean done = false;

        RequestDebug(long reqno, String threadDesc) {
            this.reqno = reqno;
            this.threadDesc = threadDesc;
        }
    }
}

