/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.servlet.AbstractServlet;
import ucar.nc2.util.net.HTTPSession;

public class ReqState {
    private String defaultDDXcache;
    private String defaultDDScache;
    private String defaultDAScache;
    private String defaultINFOcache;
    private final String defaultSchemaName = "opendap-0.0.0.xsd";
    private String defaultSchemaLocation;
    private String testdatasetspath = "/WEB-INF/resources/testdatasets";
    private String dataSetName;
    private String requestSuffix;
    private String CE;
    private Object obj = null;
    private String serverClassName;
    private String requestURL;
    private HttpServletRequest myHttpRequest;
    private HttpServletResponse response;
    private AbstractServlet myServlet;
    private ServletConfig myServletConfig;
    private ServletContext myServletContext;
    private String rootpath;

    public ReqState(HttpServletRequest myRequest, HttpServletResponse response, AbstractServlet sv, String serverClassName, String encodedurl, String encodedquery) {
        this.myServlet = sv;
        this.myServletConfig = sv.getServletConfig();
        this.myServletContext = sv.getServletContext();
        this.rootpath = HTTPSession.canonicalpath((String)this.myServletContext.getRealPath("/"));
        if (this.rootpath == null) {
            AbstractServlet.log.error("ReqState: cannot locate dts root path");
            this.rootpath = "";
        }
        AbstractServlet.log.debug("RootPath: " + this.rootpath);
        this.myHttpRequest = myRequest;
        this.response = response;
        this.serverClassName = serverClassName;
        this.CE = encodedquery;
        if (this.CE == null) {
            this.CE = "";
        }
        this.processDodsURL();
        AbstractServlet.log.debug("datasetname=|" + this.dataSetName + "|");
        this.defaultDDXcache = this.rootpath + this.testdatasetspath + "/ddx";
        this.defaultDDScache = this.rootpath + this.testdatasetspath + "/dds";
        this.defaultDAScache = this.rootpath + this.testdatasetspath + "/das";
        this.defaultINFOcache = this.rootpath + this.testdatasetspath + "/info";
        StringBuffer url = this.myHttpRequest.getRequestURL();
        if (url == null || url.length() == 0) {
            AbstractServlet.log.error("ReqState: no url specified");
        } else {
            int index = url.lastIndexOf(this.myHttpRequest.getServletPath());
            if (index < 0) {
                index = url.length();
            }
            this.defaultSchemaLocation = url.substring(0, index) + "/schema/" + "opendap-0.0.0.xsd";
        }
        this.requestURL = encodedurl;
    }

    public String getDataSet() {
        return this.dataSetName;
    }

    public String getServerClassName() {
        return this.serverClassName;
    }

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public String getConstraintExpression() {
        return this.CE;
    }

    public HttpServletRequest getRequest() {
        return this.myHttpRequest;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getRootPath() {
        return this.rootpath;
    }

    public String getDDXCache(String realpath) {
        return this.getCachedString(realpath, "DDXcache", this.defaultDDXcache);
    }

    public void setDefaultDDXCache(String cachedir) {
        this.defaultDDXcache = cachedir;
    }

    public String getDDSCache(String realpath) {
        return this.getCachedString(realpath, "DDScache", this.defaultDDScache);
    }

    public void setDefaultDDSCache(String cachedir) {
        this.defaultDDScache = cachedir;
    }

    public String getDASCache(String realpath) {
        return this.getCachedString(realpath, "DAScache", this.defaultDAScache);
    }

    public void setDefaultDASCache(String cachedir) {
        this.defaultDAScache = cachedir;
    }

    private String getCachedString(String realpath, String which, String dfalt) {
        String cacheDir = this.getInitParameter(which);
        if (cacheDir == null) {
            cacheDir = dfalt;
        } else {
            if ((cacheDir = HTTPSession.canonicalpath((String)cacheDir)).startsWith("/")) {
                cacheDir = cacheDir.substring(1);
            }
            cacheDir = realpath + "/" + cacheDir;
        }
        if (!cacheDir.endsWith("/")) {
            cacheDir = cacheDir + "/";
        }
        return cacheDir;
    }

    public String getINFOCache(String realpath) {
        return this.getCachedString(realpath, "INFOcache", this.defaultINFOcache);
    }

    public void setDefaultINFOCache(String cachedir) {
        this.defaultINFOcache = cachedir;
    }

    public String getSchemaLocation() {
        String cacheDir = this.getInitParameter("SchemaLocation");
        if (cacheDir == null) {
            cacheDir = this.defaultSchemaLocation;
        }
        return cacheDir;
    }

    public void setDefaultSchemaLocation(String location) {
        this.defaultSchemaLocation = location;
    }

    private String prepCE(String ce) {
        if (ce == null) {
            ce = "";
        } else if (!ce.equals("")) {
            int index = ce.indexOf("%");
            if (index == -1) {
                return ce;
            }
            if (index > ce.length() - 3) {
                return null;
            }
            while (index >= 0) {
                String specChar = ce.substring(index + 1, index + 3);
                char val = (char)Byte.parseByte(specChar, 16);
                if ((index = (ce = ce.substring(0, index) + String.valueOf(val) + ce.substring(index + 3, ce.length())).indexOf("%")) <= ce.length() - 3) continue;
                return null;
            }
        }
        return ce;
    }

    protected void processDodsURL() {
        String path1 = this.myHttpRequest.getContextPath();
        String path2 = this.myHttpRequest.getServletPath();
        String path3 = this.myHttpRequest.getRequestURI();
        String path4 = this.myHttpRequest.getPathInfo();
        AbstractServlet.log.debug("cxt=" + path1);
        AbstractServlet.log.debug("sv=" + path2);
        AbstractServlet.log.debug("url=" + path3);
        AbstractServlet.log.debug("path=" + path4);
        this.dataSetName = HTTPSession.canonicalpath((String)this.myHttpRequest.getPathInfo());
        String cxtpath = HTTPSession.canonicalpath((String)this.myHttpRequest.getContextPath());
        String servletpath = HTTPSession.canonicalpath((String)this.myHttpRequest.getServletPath());
        if (this.dataSetName != null && this.dataSetName.length() == 0) {
            this.dataSetName = null;
        }
        if (cxtpath != null && cxtpath.length() == 0) {
            cxtpath = null;
        }
        if (servletpath != null && servletpath.length() == 0) {
            servletpath = null;
        }
        if (cxtpath == null) {
            cxtpath = this.myServlet.getDefaultContextPath();
        }
        if (this.dataSetName == null && servletpath != null) {
            this.dataSetName = cxtpath != null && servletpath.startsWith(cxtpath) ? servletpath.substring(cxtpath.length()) : servletpath;
        }
        AbstractServlet.log.debug("this.datasetname.1=" + this.dataSetName);
        this.requestSuffix = null;
        if (this.dataSetName != null) {
            String[] pieces;
            String name = this.dataSetName;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((pieces = name.split("/")).length == 0 || pieces[0].length() == 0) {
                this.requestSuffix = "";
                this.dataSetName = name;
            } else {
                String endOPath = pieces[pieces.length - 1];
                int index = endOPath.lastIndexOf(46);
                if (index > 0) {
                    this.requestSuffix = endOPath.substring(index + 1);
                    this.dataSetName = this.dataSetName.substring(1, this.dataSetName.lastIndexOf(46));
                } else {
                    this.requestSuffix = "";
                    this.dataSetName = name;
                }
            }
        }
        AbstractServlet.log.debug("this.datasetname.2=" + this.dataSetName);
    }

    public boolean getAcceptsCompressed() {
        boolean isTiny = false;
        String encoding = this.myHttpRequest.getHeader("Accept-Encoding");
        isTiny = encoding != null ? encoding.contains("deflate") : false;
        return isTiny;
    }

    public Enumeration getInitParameterNames() {
        return this.myServletConfig.getInitParameterNames();
    }

    public String getInitParameter(String name) {
        return this.myServletConfig.getInitParameter(name);
    }

    public String getDodsBlobURL_OLDANDBUSTED() {
        int lastDot = this.requestURL.lastIndexOf(46);
        String blobURL = this.requestURL.substring(0, lastDot) + ".blob";
        if (!this.CE.equals("")) {
            blobURL = blobURL + "?" + this.CE;
        }
        return blobURL;
    }

    public Object getUserObject() {
        return this.obj;
    }

    public void setUserObject(Object userObj) {
        this.obj = userObj;
    }

    public String toString() {
        String ts = "ReqState:\n";
        ts = ts + "  serverClassName:    '" + this.serverClassName + "'\n";
        ts = ts + "  dataSet:            '" + this.dataSetName + "'\n";
        ts = ts + "  requestSuffix:      '" + this.requestSuffix + "'\n";
        ts = ts + "  CE:                 '" + this.CE + "'\n";
        ts = ts + "  compressOK:          " + this.getAcceptsCompressed() + "\n";
        ts = ts + "  InitParameters:\n";
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getInitParameter(name);
            ts = ts + "    " + name + ": '" + value + "'\n";
        }
        return ts;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestURL);
    }
}

