/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DAPNode;
import opendap.dap.DAS;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DataDDS;
import opendap.dap.DefaultFactory;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.parsers.ParseException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;

public class DConnect2 {
    private static boolean allowSessions = false;
    static final Charset UTF8 = Charset.forName("UTF-8");
    private String urlString;
    private String filePath = null;
    private InputStream stream = null;
    private String projString;
    private String selString;
    private boolean acceptCompress;
    private String lastModified = null;
    private String lastExtended = null;
    private String lastModifiedInvalid = null;
    private boolean hasSession = true;
    private ServerVersion ver;
    private boolean debugHeaders = false;
    private boolean debugStream = false;
    static final byte[] tag1 = "\nData:\n".getBytes(UTF8);
    static final byte[] tag2 = "\nData:\r\n".getBytes(UTF8);

    public static synchronized void setAllowSessions(boolean b) {
        allowSessions = b;
    }

    public void setServerVersion(int major, int minor) {
        this.ver = new ServerVersion(major, minor);
    }

    public DConnect2(String urlString) throws FileNotFoundException {
        this(urlString, true);
    }

    public DConnect2(String urlString, boolean acceptCompress) throws FileNotFoundException {
        int ceIndex = urlString.indexOf(63);
        if (ceIndex != -1) {
            this.urlString = urlString.substring(0, ceIndex);
            String expr = urlString.substring(ceIndex);
            int selIndex = expr.indexOf(38);
            if (selIndex != -1) {
                this.projString = expr.substring(0, selIndex);
                this.selString = expr.substring(selIndex);
            } else {
                this.projString = expr;
                this.selString = "";
            }
        } else {
            this.urlString = urlString;
            this.selString = "";
            this.projString = "";
        }
        this.acceptCompress = acceptCompress;
        try {
            URL testURL = new URL(urlString);
            if ("file".equals(testURL.getProtocol())) {
                this.filePath = testURL.getPath();
                File f = new File(this.filePath + ".dds");
                if (!f.canRead()) {
                    throw new FileNotFoundException("file not readable: " + urlString + ".dds");
                }
                f = new File(this.filePath + ".dods");
                if (!f.canRead()) {
                    throw new FileNotFoundException("file not readable: " + urlString + ".dods");
                }
            }
            this.ver = new ServerVersion("3.2", 1);
        }
        catch (DAP2Exception ex) {
            throw new FileNotFoundException("Cannot set server version");
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException("Malformed URL: " + urlString);
        }
    }

    public DConnect2(InputStream stream) throws DAP2Exception {
        this.stream = stream;
        this.ver = new ServerVersion("3.2", 1);
    }

    public boolean isLocal() {
        return this.stream != null || this.filePath != null;
    }

    public final String CE() {
        return this.projString + this.selString;
    }

    public final String URL() {
        return this.urlString;
    }

    private void openConnection(String urlString, Command command) throws IOException, DAP2Exception, ParseException {
        HTTPMethod method = null;
        InputStream is = null;
        HTTPSession _session = null;
        try {
            String encoding;
            int statusCode;
            _session = new HTTPSession(urlString);
            method = HTTPMethod.Get((HTTPSession)_session);
            if (this.acceptCompress) {
                method.setRequestHeader("Accept-Encoding", "deflate,gzip");
            }
            if (allowSessions) {
                method.setRequestHeader("X-Accept-Session", "true");
            }
            if ((statusCode = method.execute()) == HTTPSession.SC_NOT_FOUND) {
                throw new DAP2Exception(1, method.getStatusText() + ": " + urlString);
            }
            if (statusCode == HTTPSession.SC_UNAUTHORIZED) {
                throw new InvalidCredentialsException(method.getStatusText());
            }
            if (statusCode != HTTPSession.SC_OK) {
                throw new DAP2Exception("Method failed:" + method.getStatusText() + " on URL= " + urlString);
            }
            is = method.getResponseAsStream();
            Header header = method.getResponseHeader("Content-Description");
            if (header != null && (header.getValue().equals("dods-error") || header.getValue().equals("dods_error"))) {
                DAP2Exception ds = new DAP2Exception();
                ds.parse(is);
                throw ds;
            }
            this.ver = new ServerVersion(method);
            this.checkHeaders(method);
            Header h = method.getResponseHeader("content-encoding");
            String string = encoding = h == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                is = new BufferedInputStream(new InflaterInputStream(is), 1000);
            } else if (encoding != null && encoding.equals("gzip")) {
                is = new BufferedInputStream(new GZIPInputStream(is), 1000);
            }
            command.process(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DAP2Exception(e);
        }
        finally {
            if (_session != null) {
                _session.close();
            }
        }
    }

    public void closeSession() {
        try {
            if (allowSessions && this.hasSession) {
                this.openConnection(this.urlString + ".close", new Command(){

                    @Override
                    public void process(InputStream is) throws IOException {
                        String buffer = DConnect2.captureStream(is);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String captureStream(InputStream is) throws IOException {
        int b;
        ByteArrayOutputStream text = new ByteArrayOutputStream();
        while ((b = is.read()) >= 0) {
            text.write(b);
        }
        return new String(text.toByteArray(), UTF8);
    }

    public static String captureDataDDS(InputStream is) throws IOException {
        int b;
        byte[] text = new byte[4096];
        int pos = 0;
        int len = text.length;
        boolean eof = true;
        while ((b = is.read()) >= 0) {
            text = DConnect2.need(1, pos, len, text);
            len = text.length;
            text[pos++] = (byte)b;
            if (b != 10) continue;
            if (DConnect2.endswith(tag1, pos, text)) {
                pos -= tag1.length;
                eof = false;
                break;
            }
            if (!DConnect2.endswith(tag2, pos, text)) continue;
            pos -= tag2.length;
            eof = false;
            break;
        }
        if (eof) {
            throw new IOException("DatDDS has no 'Data:' marker");
        }
        return new String(text, 0, pos, UTF8);
    }

    private static boolean endswith(byte[] tag, int pos, byte[] text) {
        int taglen = tag.length;
        if (pos < taglen) {
            return false;
        }
        int j = 0;
        int i = pos - taglen;
        while (i < pos) {
            if (text[i] != tag[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static byte[] need(int n, int pos, int len, byte[] text) {
        int newlen;
        if (len - pos >= n) {
            return text;
        }
        for (newlen = len * 2 + n; newlen < n; ++newlen) {
        }
        byte[] newtext = new byte[newlen];
        System.arraycopy(text, 0, newtext, 0, len);
        return newtext;
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    public String getLastModifiedHeader() {
        return this.lastModified;
    }

    public String getLastModifiedInvalidHeader() {
        return this.lastModifiedInvalid;
    }

    public String getLastExtendedHeader() {
        return this.lastExtended;
    }

    private void checkHeaders(HTTPMethod method) {
        Cookie[] cookies;
        if (this.debugHeaders) {
            DAPNode.log.debug("\nOpenConnection Headers for " + method.getPath());
            DAPNode.log.debug("Status Line: " + method.getStatusLine());
        }
        Header[] responseHeaders = method.getResponseHeaders();
        for (int i1 = 0; i1 < responseHeaders.length; ++i1) {
            Header responseHeader = responseHeaders[i1];
            if (this.debugHeaders) {
                DAPNode.log.debug("  " + responseHeader);
            }
            String key = responseHeader.getName();
            String value = responseHeader.getValue();
            if (key.equals("Last-Modified")) {
                this.lastModified = value;
                if (!this.debugHeaders) continue;
                DAPNode.log.debug(" **found lastModified = " + this.lastModified);
                continue;
            }
            if (key.equals("X-Last-Extended")) {
                this.lastExtended = value;
                if (!this.debugHeaders) continue;
                DAPNode.log.debug(" **found lastExtended = " + this.lastExtended);
                continue;
            }
            if (!key.equals("X-Last-Modified-Invalid")) continue;
            this.lastModifiedInvalid = value;
            if (!this.debugHeaders) continue;
            DAPNode.log.debug(" **found lastModifiedInvalid = " + this.lastModifiedInvalid);
        }
        if (this.debugHeaders) {
            DAPNode.log.debug("OpenConnection Headers for " + method.getPath());
        }
        if ((cookies = HTTPSession.getGlobalCookies()).length > 0) {
            if (this.debugHeaders) {
                DAPNode.log.debug("Cookies= ");
            }
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cooky = cookies[i];
                if (this.debugHeaders) {
                    DAPNode.log.debug("  " + cooky);
                }
                if (!cooky.getName().equalsIgnoreCase("jsessionid")) continue;
                this.hasSession = true;
            }
        }
    }

    public DAS getDAS() throws IOException, ParseException, DAP2Exception {
        DASCommand command = new DASCommand();
        if (this.filePath != null) {
            File daspath = new File(this.filePath + ".das");
            if (daspath.canRead()) {
                command.process(new FileInputStream(daspath));
            }
        } else if (this.stream != null) {
            command.process(this.stream);
        } else {
            try {
                this.openConnection(this.urlString + ".das" + this.projString + this.selString, command);
            }
            catch (DAP2Exception dAP2Exception) {
                // empty catch block
            }
        }
        return command.das;
    }

    public DDS getDDS() throws IOException, ParseException, DAP2Exception {
        return this.getDDS("");
    }

    public DDS getDDS(String CE) throws IOException, ParseException, DAP2Exception {
        DDSCommand command = new DDSCommand();
        command.setURL(CE == null || CE.length() == 0 ? this.urlString : this.urlString + "?" + CE);
        if (this.filePath != null) {
            command.process(new FileInputStream(this.filePath + ".dds"));
        } else if (this.stream != null) {
            command.process(this.stream);
        } else {
            this.openConnection(this.urlString + ".dds" + this.getCompleteCE(CE), command);
        }
        return command.dds;
    }

    private String getCompleteCE(String CE) {
        int selIndex;
        String localProjString = null;
        String localSelString = null;
        if (CE.startsWith("?")) {
            CE = CE.substring(1);
        }
        if ((selIndex = CE.indexOf(38)) == 0) {
            localProjString = "";
        } else if (selIndex > 0) {
            localSelString = CE.substring(selIndex);
        } else {
            localProjString = CE;
            localSelString = "";
        }
        String ce = this.projString;
        if (!localProjString.equals("")) {
            if (!ce.equals("") && localProjString.indexOf(44) != 0) {
                ce = ce + ",";
            }
            ce = ce + localProjString;
        }
        if (!this.selString.equals("")) {
            if (this.selString.indexOf(38) != 0) {
                ce = ce + "&";
            }
            ce = ce + this.selString;
        }
        if (!localSelString.equals("")) {
            if (localSelString.indexOf(38) != 0) {
                ce = ce + "&";
            }
            ce = ce + localSelString;
        }
        if (ce.length() > 0) {
            ce = "?" + ce;
        }
        return ce;
    }

    public DDS getDDX() throws IOException, ParseException, DAP2Exception {
        return this.getDDX("");
    }

    public DDS getDDX(String CE) throws IOException, ParseException, DDSException, DAP2Exception {
        DDXCommand command = new DDXCommand();
        this.openConnection(this.urlString + ".ddx" + this.getCompleteCE(CE), command);
        return command.dds;
    }

    public DataDDS getDataDDX() throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDataDDX("", new DefaultFactory());
    }

    public DataDDS getDataDDX(String CE) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDataDDX(CE, new DefaultFactory());
    }

    public DataDDS getDataDDX(String CE, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        DataDDXCommand command = new DataDDXCommand(btf);
        this.openConnection(this.urlString + ".ddx" + this.getCompleteCE(CE), command);
        return command.dds;
    }

    public DataDDS getData(String CE, StatusUI statusUI, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        DataDDS dds = new DataDDS(this.ver, btf);
        DataDDSCommand command = new DataDDSCommand(dds, statusUI);
        command.setURL(this.urlString + "?" + CE);
        if (this.filePath != null) {
            File dodspath = new File(this.filePath + ".dods");
            if (dodspath.canRead()) {
                command.process(new FileInputStream(dodspath));
            }
        } else if (this.stream != null) {
            command.process(this.stream);
        } else {
            String urls = this.urlString + ".dods" + this.getCompleteCE(CE);
            this.openConnection(urls, command);
        }
        return command.dds;
    }

    public DataDDS getData(String CE) throws IOException, ParseException, DAP2Exception {
        return this.getData(CE, null, new DefaultFactory());
    }

    public DataDDS getData(String CE, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getData(CE, statusUI, new DefaultFactory());
    }

    public final DataDDS getData(StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getData("", statusUI, new DefaultFactory());
    }

    public static void main(String[] args) {
    }

    private class DataDDSCommand
    implements Command {
        DataDDS dds = null;
        StatusUI statusUI;
        String url = null;

        DataDDSCommand(DataDDS dds, StatusUI statusUI) {
            this.dds = dds;
            this.statusUI = statusUI;
        }

        public void setURL(String url) {
            this.url = url;
        }

        @Override
        public void process(InputStream is) throws ParseException, DAP2Exception, IOException {
            if (!this.dds.parse(is)) {
                throw new DAP2Exception("DataDDS DDS parse failed");
            }
            this.dds.readData(is, this.statusUI);
        }
    }

    private class DataDDXCommand
    implements Command {
        DataDDS dds;

        DataDDXCommand(BaseTypeFactory btf) {
            this.dds = new DataDDS(DConnect2.this.ver, btf);
        }

        @Override
        public void process(InputStream is) throws DAP2Exception, ParseException {
            this.dds.parseXML(is, false);
        }
    }

    private class DDXCommand
    implements Command {
        DDS dds = new DDS();

        private DDXCommand() {
        }

        @Override
        public void process(InputStream is) throws DAP2Exception, ParseException {
            this.dds.parseXML(is, false);
        }
    }

    private class DDSCommand
    implements Command {
        DDS dds = new DDS();
        String url = null;

        private DDSCommand() {
        }

        public void setURL(String url) {
            this.url = url;
            if (this.dds != null && url != null) {
                this.dds.setURL(url);
            }
        }

        @Override
        public void process(InputStream is) throws ParseException, DAP2Exception {
            this.dds.parse(is);
        }
    }

    private class DASCommand
    implements Command {
        DAS das = new DAS();

        private DASCommand() {
        }

        @Override
        public void process(InputStream is) throws ParseException, DAP2Exception {
            this.das.parse(is);
        }
    }

    private static interface Command {
        public void process(InputStream var1) throws DAP2Exception, ParseException, IOException;
    }
}

