/*
 * Decompiled with CFR 0.152.
 */
package opendap.dts;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.parsers.ParseException;
import opendap.dts.DTSServlet;
import opendap.dts.test_ServerFactory;
import opendap.servers.ServerDDS;
import opendap.servlet.GuardedDataset;
import opendap.servlet.ReqState;
import opendap.util.Debug;

public class testDataset
implements GuardedDataset {
    private ReqState rs;
    private Exception DDXfailure;
    private Exception DDSfailure;

    public testDataset(ReqState rs) {
        this.rs = rs;
    }

    @Override
    public void release() {
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerDDS getDDS() throws DAP2Exception, ParseException {
        ServerDDS myDDS;
        block10: {
            myDDS = null;
            FilterInputStream dds_source = null;
            try {
                myDDS = this.getMyDDS();
                dds_source = this.openCachedDDX(this.rs);
                if (dds_source != null) {
                    myDDS.parseXML(dds_source, true);
                    break block10;
                }
                dds_source = this.openCachedDDS(this.rs);
                if (dds_source != null) {
                    myDDS.parse(dds_source);
                    myDDS.ingestDAS(this.getDAS());
                    break block10;
                }
                throw new DAP2Exception(5, "Cannot find a DDX or DDS file that matches the Dataset you have requested.\n" + this.getClass().getName() + ".openCachedDDX() said: " + this.DDXfailure.getMessage() + "\n" + this.getClass().getName() + ".openCachedDDS() said: " + this.DDSfailure.getMessage() + "\n");
            }
            finally {
                try {
                    if (dds_source != null) {
                        dds_source.close();
                    }
                }
                catch (IOException ioe) {
                    throw new DAP2Exception(0, ioe.getMessage());
                }
            }
        }
        return myDDS;
    }

    public DataInputStream openCachedDDX(ReqState rs) {
        String cacheDir = rs.getDDXCache(rs.getRootPath());
        if (Debug.isSet("probeRequest")) {
            DTSServlet.log.debug("DDXCache: " + cacheDir);
            DTSServlet.log.debug("Attempting to open: '" + cacheDir + rs.getDataSet() + "'");
        }
        try {
            File fin = new File(cacheDir + rs.getDataSet());
            FileInputStream fp_in = new FileInputStream(fin);
            DataInputStream ddx_source = new DataInputStream(fp_in);
            return ddx_source;
        }
        catch (FileNotFoundException fnfe) {
            this.DDXfailure = fnfe;
            return null;
        }
    }

    public DataInputStream openCachedDDS(ReqState rs) {
        String cacheDir = rs.getDDSCache(rs.getRootPath());
        if (Debug.isSet("probeRequest")) {
            DTSServlet.log.debug("DDSCache: " + cacheDir);
            DTSServlet.log.debug("Attempting to open: '" + cacheDir + rs.getDataSet() + "'");
        }
        try {
            File fin = new File(cacheDir + rs.getDataSet());
            FileInputStream fp_in = new FileInputStream(fin);
            DataInputStream dds_source = new DataInputStream(fp_in);
            return dds_source;
        }
        catch (FileNotFoundException fnfe) {
            this.DDSfailure = fnfe;
            return null;
        }
    }

    private ServerDDS getMyDDS() {
        ServerDDS myDDS = null;
        test_ServerFactory sfactory = new test_ServerFactory();
        myDDS = new ServerDDS(this.rs.getDataSet(), (BaseTypeFactory)sfactory, this.rs.getSchemaLocation());
        return myDDS;
    }

    @Override
    public DAS getDAS() throws DAP2Exception, ParseException {
        Throwable throwable;
        DAS myDAS = null;
        boolean gotDDX = false;
        boolean gotDDS = false;
        boolean gotDAS = false;
        ServerDDS myDDS = this.getMyDDS();
        try {
            throwable = null;
            try (DataInputStream dds_source = this.openCachedDDS(this.rs);){
                if (dds_source != null && (gotDDS = myDDS.parse(dds_source))) {
                    DTSServlet.log.debug("Got DDS.");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ioe) {
            throw new DAP2Exception(ioe);
        }
        DTSServlet.log.debug("-------------");
        myDAS = new DAS();
        try {
            throwable = null;
            try (DataInputStream is = this.openCachedDAS(this.rs);){
                gotDAS = myDAS.parse(is);
                if (gotDAS) {
                    DTSServlet.log.debug("Got DAS");
                }
                if (gotDAS && gotDDS) {
                    myDDS.ingestDAS(myDAS);
                    myDAS = myDDS.getDAS();
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (FileNotFoundException fnfe) {
            if (gotDDS) {
                myDAS = myDDS.getDAS();
            }
            gotDAS = false;
        }
        catch (IOException ioe) {
            throw new DAP2Exception(ioe);
        }
        if (gotDAS) {
            if (gotDDX) {
                DTSServlet.log.debug("Got DAS from DDX for dataset: " + this.rs.getDataSet());
            } else if (gotDDS) {
                DTSServlet.log.debug("Got DAS, popped it into a DDS, and got back a complete DAS for dataset: " + this.rs.getDataSet());
            } else {
                DTSServlet.log.debug("Successfully opened and parsed DAS cache for dataset: " + this.rs.getDataSet());
            }
        } else if (gotDDS) {
            DTSServlet.log.debug("No DAS! Got a DDS, and sent a complete (but empty) DAS for dataset: " + this.rs.getDataSet());
        } else {
            DTSServlet.log.debug("No DAS or DDS present for dataset: " + this.rs.getDataSet());
        }
        return myDAS;
    }

    public DataInputStream openCachedDAS(ReqState rs) throws FileNotFoundException {
        String cacheDir = rs.getDASCache(rs.getRootPath());
        if (Debug.isSet("probeRequest")) {
            DTSServlet.log.debug("DASCache: " + cacheDir);
            DTSServlet.log.debug("Attempting to open: '" + cacheDir + rs.getDataSet() + "'");
        }
        File fin = new File(cacheDir + rs.getDataSet());
        FileInputStream fp_in = new FileInputStream(fin);
        DataInputStream das_source = new DataInputStream(fp_in);
        return das_source;
    }
}

