/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import opendap.dap.DAP2Exception;
import opendap.dap.Util;
import opendap.dap.parsers.ParseException;
import opendap.servlet.ReqState;

public class GetDirHandler {
    private static final boolean _Debug = false;
    private String separator = "/";

    public void sendDIR(ReqState rs) throws DAP2Exception, ParseException {
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)rs.getResponse().getOutputStream(), Util.UTF8));
            String ddsCacheDir = rs.getDDSCache(rs.getRootPath());
            String thisServer = rs.getRequest().getRequestURL().toString();
            pw.println("<html>");
            pw.println("<head>");
            pw.println("<title>OPeNDAP Directory</title>");
            pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
            pw.println("</head>");
            pw.println("<body bgcolor=\"#FFFFFF\">");
            pw.println("<h1>OPeNDAP Directory for:</h1>");
            pw.println("<h2>" + thisServer + "</h2>");
            this.printDIR(pw, ddsCacheDir, "DDS", thisServer);
            pw.println("<hr>");
            pw.println("</html>");
            pw.flush();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("OUCH! FileNotFoundException: " + fnfe.getMessage());
            fnfe.printStackTrace(System.out);
        }
        catch (IOException ioe) {
            System.out.println("OUCH! IOException: " + ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
    }

    private void printDIR(PrintWriter pw, String dirName, String dirType, String thisServer) {
        pw.println("<hr>");
        pw.println("<h3>" + dirType + "</h3>");
        File dir = new File(dirName);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                if (thisServer.lastIndexOf(this.separator) != thisServer.length() - 1) {
                    thisServer = thisServer + this.separator;
                }
                File[] fList = dir.listFiles();
                pw.println("<table border=\"0\">");
                for (int i = 0; i < fList.length; ++i) {
                    if (!fList[i].isFile()) continue;
                    pw.println("<tr>");
                    pw.print("    <td>");
                    pw.print("<div align='right'>");
                    pw.print("<b>" + fList[i].getName() + ":</b> ");
                    pw.print("</div>");
                    pw.println("</td>");
                    pw.print("    <td>");
                    pw.print("<div align='center'>");
                    pw.print("<a href='" + thisServer + fList[i].getName() + ".dds'> DDS </a>");
                    pw.print("</div>");
                    pw.println("</td>");
                    pw.print("    <td>");
                    pw.print("<div align='center'>");
                    pw.print("<a href='" + thisServer + fList[i].getName() + ".das'> DAS </a>");
                    pw.print("</div>");
                    pw.println("</td>");
                    pw.print("    <td>");
                    pw.print("<div align='center'>");
                    pw.print("<a href='" + thisServer + fList[i].getName() + ".info'> Information </a>");
                    pw.print("</div>");
                    pw.println("</td>");
                    pw.print("    <td>");
                    pw.print("<div align='center'>");
                    pw.print("<a href='" + thisServer + fList[i].getName() + ".html'> HTML Data Request Form </a>");
                    pw.print("</div>");
                    pw.println("</td>");
                    pw.println("</tr>");
                }
                pw.println("</table>");
            } else {
                pw.println("<h3>");
                pw.println("Specified " + dirType + " cache:<br>");
                pw.println("<i>" + dirName + "</i><br>");
                pw.println("is not a directory!");
                pw.println("</h3>");
            }
        } else {
            pw.println("<h4>");
            pw.println("Cannot Find " + dirType + " Directory:<br>");
            pw.println("<i>" + dirName + "</i><br>");
            pw.println("</h4>");
        }
    }
}

