/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.concurrent.NotThreadSafe;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DByte;
import opendap.dap.DConnect2;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DGrid;
import opendap.dap.DInt16;
import opendap.dap.DInt32;
import opendap.dap.DSequence;
import opendap.dap.DString;
import opendap.dap.DStructure;
import opendap.dap.DUInt16;
import opendap.dap.DUInt32;
import opendap.dap.DataDDS;
import opendap.dap.parsers.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.ConvertD2N;
import ucar.nc2.dods.DODSAttribute;
import ucar.nc2.dods.DODSGrid;
import ucar.nc2.dods.DODSStructure;
import ucar.nc2.dods.DODSVariable;
import ucar.nc2.dods.DodsV;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.rc.RC;
import ucar.unidata.util.StringUtil2;

@NotThreadSafe
public class DODSNetcdfFile
extends NetcdfFile
implements Closeable {
    static boolean OLDGROUPCODE = false;
    public static boolean debugCE = false;
    public static boolean debugServerCall = false;
    public static boolean debugOpenResult = false;
    public static boolean debugDataResult = false;
    public static boolean debugCharArray = false;
    public static boolean debugConvertData = false;
    public static boolean debugConstruct = false;
    public static boolean debugPreload = false;
    public static boolean debugTime = false;
    public static boolean showNCfile = false;
    public static boolean debugAttributes = false;
    public static boolean debugCached = false;
    public static boolean debugOpenTime = false;
    private static boolean accept_compress = false;
    private static boolean preload = true;
    private static boolean useGroups = false;
    private static int preloadCoordVarSize = 50000;
    private static Logger logger = LoggerFactory.getLogger(DODSNetcdfFile.class);
    private ConvertD2N convertD2N = new ConvertD2N();
    private DConnect2 dodsConnection = null;
    private DDS dds;
    private DAS das;

    public static void setAllowSessions(boolean b) {
        DConnect2.setAllowSessions(b);
    }

    public static void setAllowDeflate(boolean b) {
        accept_compress = b;
    }

    public static void setAllowCompression(boolean b) {
        accept_compress = b;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugCE = debugFlag.isSet("DODS/constraintExpression");
        debugServerCall = debugFlag.isSet("DODS/serverCall");
        debugOpenResult = debugFlag.isSet("DODS/debugOpenResult");
        debugDataResult = debugFlag.isSet("DODS/debugDataResult");
        debugCharArray = debugFlag.isSet("DODS/charArray");
        debugConstruct = debugFlag.isSet("DODS/constructNetcdf");
        debugPreload = debugFlag.isSet("DODS/preload");
        debugTime = debugFlag.isSet("DODS/timeCalls");
        showNCfile = debugFlag.isSet("DODS/showNCfile");
        debugAttributes = debugFlag.isSet("DODS/attributes");
        debugCached = debugFlag.isSet("DODS/cache");
    }

    public static void setPreload(boolean b) {
        preload = b;
    }

    public static void setCoordinateVariablePreloadSize(int size) {
        preloadCoordVarSize = size;
    }

    public static String canonicalURL(String urlName) {
        if (urlName.startsWith("http:")) {
            return "dods:" + urlName.substring(5);
        }
        if (urlName.startsWith("https:")) {
            return "dods:" + urlName.substring(6);
        }
        return urlName;
    }

    public DODSNetcdfFile(String datasetURL) throws IOException {
        this(datasetURL, null);
    }

    public DODSNetcdfFile(String datasetURL, CancelTask cancelTask) throws IOException {
        int pos;
        long start = System.currentTimeMillis();
        String urlName = datasetURL;
        this.location = datasetURL;
        if (datasetURL.startsWith("dods:")) {
            urlName = "http:" + datasetURL.substring(5);
        } else if (datasetURL.startsWith("http:")) {
            this.location = "dods:" + datasetURL.substring(5);
        } else if (datasetURL.startsWith("https:")) {
            this.location = "dods:" + datasetURL.substring(6);
        } else if (datasetURL.startsWith("file:")) {
            this.location = datasetURL;
        } else {
            throw new MalformedURLException(datasetURL + " must start with dods: or http: or file:");
        }
        if (debugServerCall) {
            System.out.println("DConnect to = <" + urlName + ">");
        }
        this.dodsConnection = new DConnect2(urlName, accept_compress);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        try {
            this.dds = this.dodsConnection.getDDS();
            if (debugServerCall) {
                System.out.println("DODSNetcdfFile readDDS");
            }
            if (debugOpenResult) {
                System.out.println("DDS = ");
                this.dds.print(System.out);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return;
            }
            this.das = this.dodsConnection.getDAS();
            if (debugServerCall) {
                System.out.println("DODSNetcdfFile readDAS");
            }
            if (debugOpenResult) {
                System.out.println("DAS = ");
                this.das.print(System.out);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return;
            }
            if (debugOpenResult) {
                System.out.println("dodsVersion = " + this.dodsConnection.getServerVersion());
            }
        }
        catch (DAP2Exception dodsE) {
            if (dodsE.getErrorCode() == 1) {
                throw new FileNotFoundException(dodsE.getMessage());
            }
            dodsE.printStackTrace(System.err);
            throw new IOException("DODSNetcdfFile url=" + datasetURL, dodsE);
        }
        catch (Throwable t) {
            logger.info("DODSNetcdfFile " + datasetURL, t);
            throw new IOException("DODSNetcdfFile url=" + datasetURL, t);
        }
        DodsV rootDodsV = DodsV.parseDDS(this.dds);
        rootDodsV.parseDAS(this.das);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.constructTopVariables(rootDodsV, cancelTask);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.constructConstructors(rootDodsV, cancelTask);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.finish();
        this.parseGlobalAttributes(this.das, rootDodsV, this);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        if (RC.getUseGroups()) {
            try {
                this.reGroup();
            }
            catch (DAP2Exception dodsE) {
                dodsE.printStackTrace(System.err);
                throw new IOException(dodsE);
            }
        }
        if (0 <= (pos = urlName.indexOf(63))) {
            String datasetName = urlName.substring(0, pos);
            if (debugServerCall) {
                System.out.println(" reconnect to = <" + datasetName + ">");
            }
            this.dodsConnection = new DConnect2(datasetName, accept_compress);
            String CE = urlName.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(CE, " ,");
            while (stoke.hasMoreTokens()) {
                DODSVariable dodsVar;
                String proj = stoke.nextToken();
                int subsetPos = proj.indexOf(91);
                if (debugCE) {
                    System.out.println(" CE = " + proj + " " + subsetPos);
                }
                if (subsetPos <= 0) continue;
                String vname = proj.substring(0, subsetPos);
                String vCE = proj.substring(subsetPos);
                if (debugCE) {
                    System.out.println(" vCE = <" + vname + "><" + vCE + ">");
                }
                if ((dodsVar = (DODSVariable)this.findVariable(vname)) == null) {
                    throw new IOException("Variable not found: " + vname);
                }
                dodsVar.setCE(vCE);
                dodsVar.setCaching(true);
            }
        }
        if (preload) {
            ArrayList<Variable> preloadList = new ArrayList<Variable>();
            for (Variable dodsVar : this.variables) {
                long size = dodsVar.getSize() * (long)dodsVar.getElementSize();
                if ((!dodsVar.isCoordinateVariable() || size >= (long)preloadCoordVarSize) && !dodsVar.isCaching() && dodsVar.getDataType() != DataType.STRING) continue;
                dodsVar.setCaching(true);
                preloadList.add(dodsVar);
                if (!debugPreload) continue;
                System.out.printf("  preload (%6d) %s%n", size, dodsVar.getFullName());
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return;
            }
            this.readArrays(preloadList);
        }
        this.finish();
        if (showNCfile) {
            System.out.println("DODS nc file = " + this);
        }
        long took = System.currentTimeMillis() - start;
        if (debugOpenTime) {
            System.out.printf(" took %d msecs %n", took);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.cache != null && this.cache.release((FileCacheable)this)) {
            return;
        }
        if (null != this.dodsConnection) {
            this.dodsConnection.close();
            this.dodsConnection = null;
        }
    }

    private void parseGlobalAttributes(DAS das, DodsV root, DODSNetcdfFile dodsfile) {
        List<DODSAttribute> atts = root.attributes;
        for (Attribute attribute : atts) {
            this.rootGroup.addAttribute(attribute);
        }
        Enumeration tableNames = das.getNames();
        while (tableNames.hasMoreElements()) {
            DODSAttribute ncatt;
            opendap.dap.Attribute att;
            String attName;
            Enumeration attNames;
            String string = (String)tableNames.nextElement();
            AttributeTable attTable = das.getAttributeTableN(string);
            if (attTable == null) continue;
            if (string.equals("DODS_EXTRA")) {
                attNames = attTable.getNames();
                while (attNames.hasMoreElements()) {
                    attName = (String)attNames.nextElement();
                    if (attName.equals("Unlimited_Dimension")) {
                        att = attTable.getAttribute(attName);
                        ncatt = new DODSAttribute(attName, att);
                        this.setUnlimited(ncatt.getStringValue());
                        continue;
                    }
                    logger.warn(" Unknown DODS_EXTRA attribute = " + attName + " " + this.location);
                }
                continue;
            }
            if (!string.equals("EXTRA_DIMENSION")) continue;
            attNames = attTable.getNames();
            while (attNames.hasMoreElements()) {
                attName = (String)attNames.nextElement();
                att = attTable.getAttribute(attName);
                ncatt = new DODSAttribute(attName, att);
                int length = ncatt.getNumericValue().intValue();
                Dimension extraDim = new Dimension(attName, length);
                this.addDimension(null, extraDim);
            }
        }
    }

    protected void reGroup() throws DAP2Exception {
        Object[] varlist;
        Object[] gattlist;
        assert (RC.getUseGroups());
        Group rootgroup = this.getRootGroup();
        for (Object att : gattlist = rootgroup.getAttributes().toArray()) {
            Attribute ncatt = (Attribute)att;
            String dodsname = ncatt.getDODSName();
            NamePieces pieces = this.parseName(dodsname);
            if (pieces.var != null) {
                Variable v;
                String searchname = pieces.var;
                if (pieces.prefix != null) {
                    searchname = pieces.prefix + '/' + searchname;
                }
                if ((v = this.findVariable(searchname)) == null) continue;
                rootgroup.remove(ncatt);
                v.addAttribute(ncatt);
                String newname = pieces.name;
                ncatt.setName(newname);
                continue;
            }
            if (pieces.prefix == null) continue;
            Group g = rootgroup.makeRelativeGroup((NetcdfFile)this, dodsname, true);
            rootgroup.remove(ncatt);
            g.addAttribute(ncatt);
            if (!OLDGROUPCODE) continue;
            ncatt.setName(pieces.name);
        }
        for (Object var : varlist = rootgroup.getVariables().toArray()) {
            this.reGroupVariableAttributes(rootgroup, (Variable)var);
        }
    }

    @Deprecated
    protected void reGroupVariable(Group rootgroup, DODSVariable dodsv) throws DAP2Exception {
        String dodsname = dodsv.getDODSName();
        NamePieces pieces = this.parseName(dodsname);
        if (pieces.prefix != null) {
            Group gnew = rootgroup.makeRelativeGroup((NetcdfFile)this, dodsname, true);
            Group gold = null;
            gold = dodsv.getParentGroup();
            if (gnew != gold) {
                gold.remove((Variable)dodsv);
                dodsv.setParentGroup(gnew);
                gnew.addVariable((Variable)dodsv);
                if (OLDGROUPCODE) {
                    dodsv.setName(pieces.name);
                }
            }
        }
    }

    protected void reGroupVariableAttributes(Group rootgroup, Variable v) throws DAP2Exception {
        Object[] attlist;
        String vname = v.getShortName();
        Group vgroup = v.getParentGroup();
        for (Object att : attlist = v.getAttributes().toArray()) {
            Variable newvar;
            Attribute ncatt = (Attribute)att;
            String adodsname = ncatt.getDODSName();
            NamePieces pieces = this.parseName(adodsname);
            Group agroup = null;
            agroup = pieces.prefix != null ? rootgroup.makeRelativeGroup((NetcdfFile)this, adodsname, true) : vgroup;
            if (agroup != vgroup) {
                agroup = vgroup;
            }
            if (pieces.var != null && !pieces.var.equals(vname) && (newvar = agroup.findVariable(pieces.var)) != null) {
                newvar.addAttribute(ncatt);
                v.remove(ncatt);
                ncatt.setShortName(pieces.name);
            }
            if (!OLDGROUPCODE || pieces.prefix == null) continue;
            ncatt.setName(pieces.name);
        }
    }

    NamePieces parseName(String name) {
        NamePieces pieces = new NamePieces();
        int dotpos = name.lastIndexOf(46);
        int slashpos = name.lastIndexOf(47);
        if (slashpos < 0 && dotpos < 0) {
            pieces.name = name;
        } else if (slashpos >= 0 && dotpos < 0) {
            pieces.prefix = name.substring(0, slashpos);
            pieces.name = name.substring(slashpos + 1, name.length());
        } else if (slashpos < 0 && dotpos >= 0) {
            pieces.var = name.substring(0, dotpos);
            pieces.name = name.substring(dotpos + 1, name.length());
        } else if (slashpos > dotpos) {
            pieces.prefix = name.substring(0, slashpos);
            pieces.name = name.substring(slashpos + 1, name.length());
        } else {
            pieces.prefix = name.substring(0, slashpos);
            pieces.var = name.substring(slashpos + 1, dotpos);
            pieces.name = name.substring(dotpos + 1, name.length());
        }
        if (pieces.prefix != null && pieces.prefix.length() == 0) {
            pieces.prefix = null;
        }
        if (pieces.var != null && pieces.var.length() == 0) {
            pieces.var = null;
        }
        if (pieces.name.length() == 0) {
            pieces.name = null;
        }
        return pieces;
    }

    private void constructTopVariables(DodsV rootDodsV, CancelTask cancelTask) throws IOException {
        List<DodsV> topVariables = rootDodsV.children;
        for (DodsV dodsV : topVariables) {
            if (dodsV.bt instanceof DConstructor) continue;
            this.addVariable(this.rootGroup, null, dodsV);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    private void constructConstructors(DodsV rootDodsV, CancelTask cancelTask) throws IOException {
        List<DodsV> topVariables = rootDodsV.children;
        for (DodsV dodsV : topVariables) {
            if (dodsV.isDone || dodsV.bt instanceof DGrid) continue;
            this.addVariable(this.rootGroup, null, dodsV);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        for (DodsV dodsV : topVariables) {
            DodsV array;
            if (dodsV.isDone) continue;
            if (RC.getUseGroups() && dodsV.bt instanceof DGrid && (array = dodsV.findByIndex(0)) != null) {
                String apath;
                String arrayname = array.getClearName();
                String gridname = dodsV.getClearName();
                int ai = arrayname.lastIndexOf(47);
                int gi = gridname.lastIndexOf(47);
                if (gi >= 0 && ai < 0) {
                    String gpath = gridname.substring(0, gi);
                    arrayname = gpath + "/" + arrayname;
                    array.getBaseType().setClearName(arrayname);
                } else if (gi < 0 && ai >= 0) {
                    apath = arrayname.substring(0, ai);
                    gridname = apath + "/" + gridname;
                    dodsV.getBaseType().setClearName(gridname);
                } else if (gi >= 0 && ai >= 0) {
                    apath = arrayname.substring(0, ai);
                    String gpath = gridname.substring(0, gi);
                    if (!gpath.equals(apath)) {
                        String arraysuffix = arrayname.substring(gi + 1, arrayname.length());
                        arrayname = gpath + "/" + arraysuffix;
                        array.getBaseType().setClearName(arrayname);
                    }
                }
            }
            this.addVariable(this.rootGroup, null, dodsV);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    Variable addVariable(Group parentGroup, Structure parentStructure, DodsV dodsV) throws IOException {
        Variable v = this.makeVariable(parentGroup, parentStructure, dodsV);
        if (v != null) {
            this.addAttributes(v, dodsV);
            if (parentStructure != null) {
                parentStructure.addMemberVariable(v);
            } else {
                parentGroup = this.computeGroup(v.getDODSName(), v, parentGroup);
                parentGroup.addVariable(v);
            }
            dodsV.isDone = true;
        }
        return v;
    }

    Group computeGroup(String path, Variable v, Group parentGroup) {
        String dodsname;
        int sindex;
        if (parentGroup == null) {
            parentGroup = this.getRootGroup();
        }
        if (RC.getUseGroups() && v.getParentStructure() == null && (sindex = (dodsname = v.getDODSName()).indexOf(47)) >= 0) {
            Group g;
            assert (parentGroup != null);
            parentGroup = g = parentGroup.makeRelativeGroup((NetcdfFile)this, dodsname, true);
            if (OLDGROUPCODE) {
                dodsname = dodsname.substring(dodsname.lastIndexOf(47) + 1);
                v.setName(dodsname);
            }
        }
        return parentGroup;
    }

    private Variable makeVariable(Group parentGroup, Structure parentStructure, DodsV dodsV) throws IOException {
        BaseType dodsBT = dodsV.bt;
        String dodsShortName = dodsBT.getClearName();
        if (debugConstruct) {
            System.out.print("DODSNetcdf makeVariable try to init <" + dodsShortName + "> :");
        }
        if (dodsBT instanceof DString) {
            if (dodsV.darray == null) {
                if (debugConstruct) {
                    System.out.println("  assigned to DString: name = " + dodsShortName);
                }
                return new DODSVariable(this, parentGroup, parentStructure, dodsShortName, dodsBT, dodsV);
            }
            if (debugConstruct) {
                System.out.println("  assigned to Array of Strings: name = " + dodsShortName);
            }
            return new DODSVariable(this, parentGroup, parentStructure, dodsShortName, dodsV.darray, dodsBT, dodsV);
        }
        if (dodsBT instanceof DByte || dodsBT instanceof DFloat32 || dodsBT instanceof DFloat64 || dodsBT instanceof DInt16 || dodsBT instanceof DInt32 || dodsBT instanceof DUInt16 || dodsBT instanceof DUInt32) {
            if (dodsV.darray == null) {
                if (debugConstruct) {
                    System.out.println("  assigned to scalar " + dodsBT.getTypeName() + ": name = " + dodsShortName);
                }
                return new DODSVariable(this, parentGroup, parentStructure, dodsShortName, dodsBT, dodsV);
            }
            if (debugConstruct) {
                System.out.println("  assigned to array of type " + dodsBT.getClass().getName() + ": name = " + dodsShortName);
            }
            return new DODSVariable(this, parentGroup, parentStructure, dodsShortName, dodsV.darray, dodsBT, dodsV);
        }
        if (dodsBT instanceof DGrid) {
            if (dodsV.darray == null) {
                if (debugConstruct) {
                    System.out.println(" assigned to DGrid <" + dodsShortName + ">");
                }
                for (int i = 1; i < dodsV.children.size(); ++i) {
                    DodsV map = dodsV.children.get(i);
                    String shortName = DODSNetcdfFile.makeShortName(map.bt.getEncodedName());
                    Variable mapV = parentGroup.findVariable(shortName);
                    if (mapV != null) continue;
                    mapV = this.addVariable(parentGroup, parentStructure, map);
                    this.makeCoordinateVariable(parentGroup, mapV, map.data);
                }
                return new DODSGrid(this, parentGroup, parentStructure, dodsShortName, dodsV);
            }
            if (debugConstruct) {
                System.out.println(" ERROR! array of DGrid <" + dodsShortName + ">");
            }
            return null;
        }
        if (dodsBT instanceof DSequence) {
            if (dodsV.darray == null) {
                if (debugConstruct) {
                    System.out.println(" assigned to DSequence <" + dodsShortName + ">");
                }
                return new DODSStructure(this, parentGroup, parentStructure, dodsShortName, dodsV);
            }
            if (debugConstruct) {
                System.out.println(" ERROR! array of DSequence <" + dodsShortName + ">");
            }
            return null;
        }
        if (dodsBT instanceof DStructure) {
            DStructure dstruct = (DStructure)dodsBT;
            if (dodsV.darray == null) {
                if (useGroups && parentStructure == null && this.isGroup(dstruct)) {
                    if (debugConstruct) {
                        System.out.println(" assigned to Group <" + dodsShortName + ">");
                    }
                    Group g = new Group((NetcdfFile)this, parentGroup, DODSNetcdfFile.makeShortName(dodsShortName));
                    this.addAttributes(g, dodsV);
                    parentGroup.addGroup(g);
                    for (DodsV nested : dodsV.children) {
                        this.addVariable(g, null, nested);
                    }
                    return null;
                }
                if (debugConstruct) {
                    System.out.println(" assigned to DStructure <" + dodsShortName + ">");
                }
                return new DODSStructure(this, parentGroup, parentStructure, dodsShortName, dodsV);
            }
            if (debugConstruct) {
                System.out.println(" assigned to Array of DStructure <" + dodsShortName + "> ");
            }
            return new DODSStructure(this, parentGroup, parentStructure, dodsShortName, dodsV.darray, dodsV);
        }
        logger.warn("DODSNetcdf " + this.location + " didnt process basetype <" + dodsBT.getTypeName() + "> variable = " + dodsShortName);
        return null;
    }

    private void makeCoordinateVariable(Group parentGroup, Variable v, Array data) {
        String name = v.getShortName();
        Dimension oldDimension = v.getDimension(0);
        Dimension newDimension = new Dimension(name, oldDimension.getLength());
        v.setDimension(0, newDimension);
        Dimension old = parentGroup.findDimension(name);
        parentGroup.remove(old);
        parentGroup.addDimension(newDimension);
        if (data != null) {
            v.setCachedData(data);
            if (debugCached) {
                System.out.println(" cache for <" + name + "> length =" + data.getSize());
            }
        }
    }

    private boolean isGroup(DStructure dstruct) {
        BaseType parent = (BaseType)dstruct.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof DStructure) {
            return this.isGroup((DStructure)parent);
        }
        return true;
    }

    private void addAttributes(Variable v, DodsV dodsV) {
        List<DODSAttribute> atts = dodsV.attributes;
        for (Attribute attribute : atts) {
            v.addAttribute(attribute);
        }
        Attribute axes = v.findAttribute("coordinates");
        Attribute attribute = v.findAttribute("_CoordinateAxes");
        if (null != axes && null != attribute) {
            v.addAttribute(DODSNetcdfFile.combineAxesAttrs(axes, attribute));
        }
    }

    protected static Attribute combineAxesAttrs(Attribute axis1, Attribute axis2) {
        String[] axisValues;
        ArrayList<String> axesCombinedValues = new ArrayList<String>();
        String axisValuesStr = axis1.getStringValue() + " " + axis2.getStringValue();
        for (String ax : axisValues = axisValuesStr.split("\\s")) {
            if (axesCombinedValues.contains(ax) || ax.equals("")) continue;
            axesCombinedValues.add(ax);
        }
        return new Attribute("_CoordinateAxes", String.join((CharSequence)" ", axesCombinedValues));
    }

    private void addAttributes(Group g, DodsV dodsV) {
        List<DODSAttribute> atts = dodsV.attributes;
        for (Attribute attribute : atts) {
            g.addAttribute(attribute);
        }
    }

    Dimension getNetcdfStrlenDim(DODSVariable v) {
        int dimLength;
        String dimName;
        AttributeTable table = this.das.getAttributeTableN(v.getFullName());
        if (table == null) {
            return null;
        }
        opendap.dap.Attribute dodsAtt = table.getAttribute("DODS");
        if (dodsAtt == null) {
            return null;
        }
        AttributeTable dodsTable = dodsAtt.getContainerN();
        if (dodsTable == null) {
            return null;
        }
        opendap.dap.Attribute att = dodsTable.getAttribute("strlen");
        if (att == null) {
            return null;
        }
        String strlen = att.getValueAtN(0);
        opendap.dap.Attribute att2 = dodsTable.getAttribute("dimName");
        String string = dimName = att2 == null ? null : att2.getValueAtN(0);
        if (debugCharArray) {
            System.out.println(v.getFullName() + " has strlen= " + strlen + " dimName= " + dimName);
        }
        try {
            dimLength = Integer.parseInt(strlen);
        }
        catch (NumberFormatException e) {
            logger.warn("DODSNetcdfFile " + this.location + " var = " + v.getFullName() + " error on strlen attribute = " + strlen);
            return null;
        }
        if (dimLength <= 0) {
            return null;
        }
        return new Dimension(dimName, dimLength, dimName != null);
    }

    Dimension getSharedDimension(Group group, Dimension d) {
        if (d.getShortName() == null) {
            return d;
        }
        if (group == null) {
            group = this.rootGroup;
        }
        for (Dimension sd : group.getDimensions()) {
            if (!sd.getShortName().equals(d.getShortName()) || sd.getLength() != d.getLength()) continue;
            return sd;
        }
        d.setShared(true);
        group.addDimension(d);
        return d;
    }

    List<Dimension> constructDimensions(Group group, DArray dodsArray) {
        if (group == null) {
            group = this.rootGroup;
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Enumeration enumerate = dodsArray.getDimensions();
        while (enumerate.hasMoreElements()) {
            Dimension myd;
            DArrayDimension dad = (DArrayDimension)enumerate.nextElement();
            String name = dad.getEncodedName();
            if (name != null) {
                name = StringUtil2.unescape((String)name);
            }
            if (name == null) {
                myd = new Dimension(null, dad.getSize(), false);
            } else {
                if (RC.getUseGroups() && name.indexOf(47) >= 0) {
                    group = group.makeRelativeGroup((NetcdfFile)this, name, true);
                    name = name.substring(name.lastIndexOf(47) + 1);
                }
                if ((myd = group.findDimension(name)) == null) {
                    myd = new Dimension(name, dad.getSize());
                    group.addDimension(myd);
                } else if (myd.getLength() != dad.getSize()) {
                    myd = new Dimension(name, dad.getSize(), false);
                }
            }
            dims.add(myd);
        }
        return dims;
    }

    private void setUnlimited(String dimName) {
        Dimension dim = this.rootGroup.findDimension(dimName);
        if (dim != null) {
            dim.setUnlimited(true);
        } else {
            logger.error(" DODS Unlimited_Dimension = " + dimName + " not found on " + this.location);
        }
    }

    protected int[] makeShape(DArray dodsArray) {
        int count = 0;
        Enumeration enumerate = dodsArray.getDimensions();
        while (enumerate.hasMoreElements()) {
            ++count;
            enumerate.nextElement();
        }
        int[] shape = new int[count];
        enumerate = dodsArray.getDimensions();
        count = 0;
        while (enumerate.hasMoreElements()) {
            DArrayDimension dad = (DArrayDimension)enumerate.nextElement();
            shape[count++] = dad.getSize();
        }
        return shape;
    }

    public static String getDODSConstraintName(Variable var) {
        String vname = var.getDODSName();
        return EscapeStrings.backslashToDAP((String)vname);
    }

    private String makeDODSname(DodsV dodsV) {
        DodsV parent = dodsV.parent;
        if (parent.bt != null) {
            return this.makeDODSname(parent) + "." + dodsV.bt.getEncodedName();
        }
        return dodsV.bt.getEncodedName();
    }

    static String makeShortName(String name) {
        String unescaped = EscapeStrings.unescapeDAPIdentifier((String)name);
        int index = unescaped.lastIndexOf(47);
        if (index < 0) {
            index = -1;
        }
        return unescaped.substring(index + 1, unescaped.length());
    }

    static String makeDODSName(String name) {
        return EscapeStrings.unescapeDAPIdentifier((String)name);
    }

    public static int convertToDODSType(DataType dataType) {
        if (dataType == DataType.STRING) {
            return 10;
        }
        if (dataType == DataType.BYTE) {
            return 3;
        }
        if (dataType == DataType.FLOAT) {
            return 8;
        }
        if (dataType == DataType.DOUBLE) {
            return 9;
        }
        if (dataType == DataType.SHORT) {
            return 4;
        }
        if (dataType == DataType.USHORT) {
            return 5;
        }
        if (dataType == DataType.INT) {
            return 6;
        }
        if (dataType == DataType.UINT) {
            return 7;
        }
        if (dataType == DataType.BOOLEAN) {
            return 3;
        }
        if (dataType == DataType.LONG) {
            return 6;
        }
        return 10;
    }

    public static DataType convertToNCType(int dodsDataType, boolean isUnsigned) {
        switch (dodsDataType) {
            case 3: {
                return isUnsigned ? DataType.UBYTE : DataType.BYTE;
            }
            case 8: {
                return DataType.FLOAT;
            }
            case 9: {
                return DataType.DOUBLE;
            }
            case 4: {
                return DataType.SHORT;
            }
            case 5: {
                return DataType.USHORT;
            }
            case 6: {
                return DataType.INT;
            }
            case 7: {
                return DataType.UINT;
            }
        }
        return DataType.STRING;
    }

    public static DataType convertToNCType(BaseType dtype, boolean isUnsigned) {
        if (dtype instanceof DString) {
            return DataType.STRING;
        }
        if (dtype instanceof DStructure || dtype instanceof DSequence || dtype instanceof DGrid) {
            return DataType.STRUCTURE;
        }
        if (dtype instanceof DFloat32) {
            return DataType.FLOAT;
        }
        if (dtype instanceof DFloat64) {
            return DataType.DOUBLE;
        }
        if (dtype instanceof DUInt32) {
            return DataType.UINT;
        }
        if (dtype instanceof DUInt16) {
            return DataType.USHORT;
        }
        if (dtype instanceof DInt32) {
            return DataType.INT;
        }
        if (dtype instanceof DInt16) {
            return DataType.SHORT;
        }
        if (dtype instanceof DByte) {
            return isUnsigned ? DataType.UBYTE : DataType.BYTE;
        }
        throw new IllegalArgumentException("DODSVariable illegal type = " + dtype.getTypeName());
    }

    public static boolean isUnsigned(BaseType dtype) {
        return dtype instanceof DByte || dtype instanceof DUInt16 || dtype instanceof DUInt32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataDDS readDataDDSfromServer(String CE) throws IOException, DAP2Exception {
        DataDDS data;
        if (debugServerCall) {
            System.out.println("DODSNetcdfFile.readDataDDSfromServer = <" + CE + ">");
        }
        long start = 0L;
        if (debugTime) {
            start = System.currentTimeMillis();
        }
        if (!CE.startsWith("?")) {
            CE = "?" + CE;
        }
        DODSNetcdfFile dODSNetcdfFile = this;
        synchronized (dODSNetcdfFile) {
            data = this.dodsConnection.getData(CE, null);
        }
        if (debugTime) {
            System.out.println("DODSNetcdfFile.readDataDDSfromServer took = " + (double)(System.currentTimeMillis() - start) / 1000.0);
        }
        if (debugDataResult) {
            System.out.println(" dataDDS return:");
            data.print(System.out);
        }
        return data;
    }

    public List<Array> readArrays(List<Variable> preloadVariables) throws IOException {
        if (preloadVariables.size() == 0) {
            return new ArrayList<Array>();
        }
        ArrayList<DodsV> reqDodsVlist = new ArrayList<DodsV>();
        for (Variable var : preloadVariables) {
            if (var.hasCachedData()) continue;
            reqDodsVlist.add((DodsV)var.getSPobject());
        }
        Collections.sort(reqDodsVlist);
        HashMap<DodsV, DodsV> map = new HashMap<DodsV, DodsV>(2 * reqDodsVlist.size() + 1);
        if (reqDodsVlist.size() > 0) {
            DodsV root;
            StringBuilder requestString = new StringBuilder();
            for (int i = 0; i < reqDodsVlist.size(); ++i) {
                DodsV dodsV = (DodsV)reqDodsVlist.get(i);
                requestString.append(i == 0 ? "?" : ",");
                requestString.append(dodsV.getEncodedName());
            }
            String s = requestString.toString();
            try {
                DataDDS dataDDS = this.readDataDDSfromServer(requestString.toString());
                root = DodsV.parseDataDDS(dataDDS);
            }
            catch (Exception exc) {
                logger.error("ERROR readDataDDSfromServer on " + requestString, (Throwable)exc);
                throw new IOException(exc.getMessage());
            }
            for (DodsV ddsV : reqDodsVlist) {
                DodsV dataV = root.findDataV(ddsV);
                if (dataV != null) {
                    if (debugConvertData) {
                        System.out.println("readArray found dataV= " + this.makeDODSname(ddsV));
                    }
                    dataV.isDone = true;
                    map.put(ddsV, dataV);
                    continue;
                }
                logger.error("ERROR findDataV cant find " + this.makeDODSname(ddsV) + " on " + this.location);
            }
        }
        ArrayList<Array> result = new ArrayList<Array>();
        for (Variable var : preloadVariables) {
            if (var.hasCachedData()) {
                result.add(var.read());
                continue;
            }
            Array data = null;
            DodsV ddsV = (DodsV)var.getSPobject();
            DodsV dataV = (DodsV)map.get(ddsV);
            if (dataV == null) {
                logger.error("DODSNetcdfFile.readArrays cant find " + this.makeDODSname(ddsV) + " in dataDDS; " + this.location);
            } else {
                if (debugConvertData) {
                    System.out.println("readArray converting " + this.makeDODSname(ddsV));
                }
                dataV.isDone = true;
                try {
                    if (var.isMemberOfStructure()) {
                        while (dataV.parent != null && dataV.parent.bt != null) {
                            dataV = dataV.parent;
                        }
                        data = this.convertD2N.convertNestedVariable(var, null, dataV, true);
                    } else {
                        data = this.convertD2N.convertTopVariable(var, null, dataV);
                    }
                }
                catch (DAP2Exception de) {
                    logger.error("ERROR convertVariable on " + var.getFullName(), (Throwable)de);
                    throw new IOException(de.getMessage());
                }
                if (var.isCaching()) {
                    var.setCachedData(data);
                    if (debugCached) {
                        System.out.println(" cache for <" + var.getFullName() + "> length =" + data.getSize());
                    }
                }
            }
            result.add(data);
        }
        return result;
    }

    public Array readSection(String variableSection) throws IOException, InvalidRangeException {
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)this, (String)variableSection);
        return this.readData(cer.v, cer.section);
    }

    protected Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        Array dataArray;
        StringBuilder buff = new StringBuilder(100);
        buff.setLength(0);
        buff.append(DODSNetcdfFile.getDODSConstraintName(v));
        if (!v.isVariableLength()) {
            int n;
            List dodsSection = section.getRanges();
            if (v.getDataType() == DataType.CHAR && (n = section.getRank()) == v.getRank()) {
                dodsSection = dodsSection.subList(0, n - 1);
            }
            this.makeSelector(buff, dodsSection);
        }
        try {
            DataDDS dataDDS = this.readDataDDSfromServer(buff.toString());
            DodsV root = DodsV.parseDataDDS(dataDDS);
            DodsV want = root.children.get(0);
            dataArray = this.convertD2N.convertTopVariable(v, section.getRanges(), want);
        }
        catch (DAP2Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage() + "; " + v.getShortName() + " -- " + section);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        return dataArray;
    }

    public long readToByteChannel(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array result = this.readData(v, section);
        return IospHelper.transferData((Array)result, (WritableByteChannel)channel);
    }

    public Array readWithCE(Variable v, String CE) throws IOException {
        Array dataArray;
        try {
            DataDDS dataDDS = this.readDataDDSfromServer(CE);
            DodsV root = DodsV.parseDataDDS(dataDDS);
            DodsV want = root.children.get(0);
            dataArray = v.isMemberOfStructure() ? this.convertD2N.convertNestedVariable(v, null, want, true) : this.convertD2N.convertTopVariable(v, null, want);
        }
        catch (DAP2Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        return dataArray;
    }

    private int addParents(StringBuilder buff, Variable s, List<Range> section, int start) {
        Structure parent = s.getParentStructure();
        if (parent != null) {
            start = this.addParents(buff, (Variable)parent, section, start);
            buff.append(".");
        }
        List<Range> subSection = section.subList(start, start + s.getRank());
        buff.append(DODSNetcdfFile.getDODSConstraintName(s));
        if (!s.isVariableLength()) {
            this.makeSelector(buff, subSection);
        }
        return start + s.getRank();
    }

    private void makeSelector(StringBuilder buff, List<Range> section) {
        for (Range r : section) {
            buff.append("[");
            buff.append(r.first());
            buff.append(':');
            buff.append(r.stride());
            buff.append(':');
            buff.append(r.last());
            buff.append("]");
        }
    }

    public void getDetailInfo(Formatter f) {
        super.getDetailInfo(f);
        f.format("DDS = %n", new Object[0]);
        ByteArrayOutputStream buffOS = new ByteArrayOutputStream(8000);
        this.dds.print(buffOS);
        f.format("%s%n", new String(buffOS.toByteArray(), StandardCharsets.UTF_8));
        f.format("%nDAS = %n", new Object[0]);
        buffOS = new ByteArrayOutputStream(8000);
        this.das.print(buffOS);
        f.format("%s%n", new String(buffOS.toByteArray(), StandardCharsets.UTF_8));
    }

    public String getFileTypeId() {
        return "OPeNDAP";
    }

    public String getFileTypeDescription() {
        return "Open-source Project for a Network Data Access Protocol";
    }

    private static class NamePieces {
        String prefix = null;
        String var = null;
        String name = null;

        private NamePieces() {
        }
    }
}

