/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import opendap.dap.AttributeBadValueException;
import opendap.dap.AttributeTable;
import opendap.dap.DAPNode;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.parsers.DDSXMLParser;
import ucar.nc2.dods.EscapeStringsDap;

public class Attribute
extends DAPNode {
    private static final boolean _Debug = false;
    private static final boolean DebugValueChecking = false;
    public static final int UNKNOWN = 0;
    public static final int ALIAS = 1;
    public static final int CONTAINER = 2;
    public static final int BYTE = 3;
    public static final int INT16 = 4;
    public static final int UINT16 = 5;
    public static final int INT32 = 6;
    public static final int UINT32 = 7;
    public static final int FLOAT32 = 8;
    public static final int FLOAT64 = 9;
    public static final int STRING = 10;
    public static final int URL = 11;
    private int type;
    private AttributeTable attrTable;
    private List<String> attr;

    public Attribute(AttributeTable container) {
        this.type = 2;
        this.attrTable = container;
    }

    public Attribute(int type, String clearname, String value, boolean check) throws AttributeBadValueException {
        super(clearname);
        if (check) {
            value = Attribute.forceValue(type, value);
        }
        this.type = type;
        this.attr = new ArrayList<String>();
        this.attr.add(value);
    }

    public Attribute(String clearname, AttributeTable container) {
        super(clearname);
        this.type = 2;
        this.attrTable = container;
    }

    public Attribute(String clearname, int type) throws IllegalArgumentException {
        super(clearname);
        this.type = type;
        if (type == 2) {
            throw new IllegalArgumentException("Can't construct an Attribute(CONTAINER)");
        }
        this.attr = new ArrayList<String>();
    }

    public final String getTypeString() {
        switch (this.type) {
            case 2: {
                return "Container";
            }
            case 1: {
                return "Alias";
            }
            case 3: {
                return "Byte";
            }
            case 4: {
                return "Int16";
            }
            case 5: {
                return "UInt16";
            }
            case 6: {
                return "Int32";
            }
            case 7: {
                return "UInt32";
            }
            case 8: {
                return "Float32";
            }
            case 9: {
                return "Float64";
            }
            case 10: {
                return "String";
            }
            case 11: {
                return "Url";
            }
        }
        return "";
    }

    public static final int getTypeVal(String s) {
        if (s.equalsIgnoreCase("Container")) {
            return 2;
        }
        if (s.equalsIgnoreCase("Byte")) {
            return 3;
        }
        if (s.equalsIgnoreCase("Int16")) {
            return 4;
        }
        if (s.equalsIgnoreCase("UInt16")) {
            return 5;
        }
        if (s.equalsIgnoreCase("Int32")) {
            return 6;
        }
        if (s.equalsIgnoreCase("UInt32")) {
            return 7;
        }
        if (s.equalsIgnoreCase("Float32")) {
            return 8;
        }
        if (s.equalsIgnoreCase("Float64")) {
            return 9;
        }
        if (s.equalsIgnoreCase("String")) {
            return 10;
        }
        if (s.equalsIgnoreCase("URL")) {
            return 11;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public boolean isContainer() {
        return this.type == 2;
    }

    public boolean isAlias() {
        return false;
    }

    public AttributeTable getContainer() throws NoSuchAttributeException {
        this.checkContainerUsage();
        return (AttributeTable)((Object)this.attr);
    }

    @Nullable
    public AttributeTable getContainerN() {
        return this.attrTable;
    }

    public List<String> getValues() throws NoSuchAttributeException {
        this.checkVectorUsage();
        return this.attr;
    }

    public Iterator<String> getValuesIterator() {
        return this.attr != null ? this.attr.iterator() : null;
    }

    public int getNumVal() throws NoSuchAttributeException {
        this.checkVectorUsage();
        return this.attr.size();
    }

    public String getValueAt(int index) throws NoSuchAttributeException {
        this.checkVectorUsage();
        return this.attr.get(index);
    }

    @Nullable
    public String getValueAtN(int index) {
        return this.attr == null ? null : this.attr.get(index);
    }

    public void appendValue(String value) throws NoSuchAttributeException, AttributeBadValueException {
        this.checkVectorUsage();
        this.appendValue(value, true);
    }

    public void appendValue(String value, boolean check) throws NoSuchAttributeException, AttributeBadValueException {
        this.checkVectorUsage();
        if (check) {
            value = Attribute.forceValue(this.type, value);
        }
        this.attr.add(value);
    }

    public void deleteValueAt(int index) throws AttributeBadValueException, NoSuchAttributeException {
        this.checkVectorUsage();
        this.attr.remove(index);
    }

    private static void dispatchCheckValue(int type, String value) throws AttributeBadValueException {
        switch (type) {
            case 3: {
                if (Attribute.checkByte(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Byte value.");
            }
            case 4: {
                if (Attribute.checkShort(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an Int16 value.");
            }
            case 5: {
                if (Attribute.checkUShort(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an UInt16 value.");
            }
            case 6: {
                if (Attribute.checkInt(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an Int32 value.");
            }
            case 7: {
                if (Attribute.checkUInt(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not an UInt32 value.");
            }
            case 8: {
                if (Attribute.checkFloat(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Float32 value.");
            }
            case 9: {
                if (Attribute.checkDouble(value)) break;
                throw new AttributeBadValueException("`" + value + "' is not a Float64 value.");
            }
        }
    }

    private static String forceValue(int type, String value) throws AttributeBadValueException {
        block3: {
            try {
                Attribute.dispatchCheckValue(type, value);
            }
            catch (AttributeBadValueException abe) {
                if (type != 3) break block3;
                short val = Short.parseShort(value);
                if (val > 255 && val < -128) {
                    throw new AttributeBadValueException("Cannot convert to byte: " + value);
                }
                value = Integer.toString(val & 0xFF);
            }
        }
        return value;
    }

    private static final boolean checkByte(String s) throws AttributeBadValueException {
        try {
            short val = Short.parseShort(s);
            return val <= 255 && val >= 0;
        }
        catch (NumberFormatException e) {
            throw new AttributeBadValueException("`" + s + "' is not a Byte value.");
        }
    }

    private static final boolean checkShort(String s) {
        try {
            short val = Short.parseShort(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final boolean checkUShort(String s) {
        try {
            long val = Long.parseLong(s);
            return val <= 65535L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final boolean checkInt(String s) {
        try {
            int val = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final boolean checkUInt(String s) {
        try {
            long val = Long.parseLong(s);
            return val <= 0xFFFFFFFFL;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static final boolean checkFloat(String s) {
        try {
            float val = Float.parseFloat(s);
            return true;
        }
        catch (NumberFormatException e) {
            return s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("inf");
        }
    }

    private static final boolean checkDouble(String s) {
        try {
            double val = Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("inf");
        }
    }

    private void checkVectorUsage() throws NoSuchAttributeException {
        if (this.attr == null) {
            throw new NoSuchAttributeException("The Attribute '" + this.getEncodedName() + "' is a container. It's contents are Attribues, not values.");
        }
    }

    private void checkContainerUsage() throws NoSuchAttributeException {
        if (this.attrTable == null) {
            throw new NoSuchAttributeException("The Attribute '" + this.getEncodedName() + "' is not a container (AttributeTable).It's content is made up of values, not other Attributes.");
        }
    }

    public void print(PrintWriter os, String pad) {
        if (this.attrTable != null) {
            this.attrTable.print(os, pad);
        } else {
            os.print(pad + this.getTypeString() + " " + this.getEncodedName() + " ");
            int count = 0;
            for (String val : this.attr) {
                if (count > 0) {
                    os.print(", ");
                }
                if (this.type == 10) {
                    String quoted = "\"" + EscapeStringsDap.backslashEscapeDapString(val) + "\"";
                    for (int i = 0; i < quoted.length(); ++i) {
                        os.print(quoted.charAt(i));
                    }
                } else {
                    os.print(val);
                }
                ++count;
            }
            os.println(";");
        }
        os.flush();
    }

    public final void print(OutputStream os, String pad) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8))), pad);
    }

    public final void print(PrintWriter os) {
        this.print(os, "");
    }

    public final void print(OutputStream os) {
        this.print(os, "");
    }

    public void printXML(OutputStream os) {
        this.printXML(os, "");
    }

    public void printXML(OutputStream os, String pad) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printXML(pw, pad);
        pw.flush();
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, "");
    }

    public void printXML(PrintWriter pw, String pad) {
        this.printXML(pw, pad, false);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        if (this.attrTable != null) {
            this.attrTable.printXML(pw, pad, constrained);
        } else {
            pw.println(pad + "<Attribute name=\"" + DDSXMLParser.normalizeToXML(this.getEncodedName()) + "\" type=\"" + this.getTypeString() + "\">");
            for (String val : this.attr) {
                pw.println(pad + "\t<value>" + DDSXMLParser.normalizeToXML(val) + "</value>");
            }
            pw.println(pad + "</Attribute>");
        }
        pw.flush();
    }

    @Override
    public Attribute cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        Attribute a = (Attribute)super.cloneDAG(map);
        if (this.type == 2) {
            a.attrTable = (AttributeTable)Attribute.cloneDAG(map, this.attrTable);
        } else {
            a.attr = new ArrayList<String>(this.attr);
        }
        return a;
    }
}

