/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dods.EscapeStringsDap;

public class DAPNode
implements Cloneable,
Serializable {
    public static Logger log = LoggerFactory.getLogger(DAPNode.class);
    static final long serialVersionUID = 1L;
    static DAPNode NULLNODE = new DAPNode("null");
    protected String _nameClear;
    protected String _nameEncoded;
    private DAPNode _myParent = null;
    private boolean projected = false;

    public DAPNode() {
        this(null);
    }

    public DAPNode(String n) {
        this.setClearName(n);
    }

    public void setProjected(boolean tf) {
        this.projected = tf;
    }

    public boolean isProject() {
        return this.projected;
    }

    public void setProject(boolean state, boolean all) {
        this.setProjected(state);
    }

    public void setProject(boolean state) {
        this.setProject(state, true);
    }

    public void setParent(DAPNode bt) {
        this._myParent = bt;
    }

    public DAPNode getParent() {
        return this._myParent;
    }

    public final String getClearName() {
        return this._nameClear;
    }

    public final String getEncodedName() {
        return this._nameEncoded;
    }

    public final void setEncodedName(String n) {
        this._nameEncoded = n;
        this._nameClear = EscapeStringsDap.unescapeDAPIdentifier(n);
    }

    public void setClearName(String n) {
        this._nameClear = n;
        this._nameEncoded = EscapeStringsDap.escapeDAPIdentifier(n);
    }

    @Deprecated
    public Object clone() {
        try {
            CloneMap map = new CloneMap();
            map.nodes.put(NULLNODE, NULLNODE);
            return this.cloneDAG(map);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Deprecated
    public static DAPNode cloneDAG(CloneMap map, DAPNode src) throws CloneNotSupportedException {
        DAPNode bt = map.nodes.get(src);
        if (bt == null) {
            bt = src.cloneDAG(map);
        }
        return bt;
    }

    @Deprecated
    public DAPNode cloneDAG(CloneMap map) throws CloneNotSupportedException {
        DAPNode node = (DAPNode)super.clone();
        map.nodes.put(this, node);
        DAPNode tmp = map.nodes.get(this._myParent);
        if (tmp != node) {
            this._myParent = tmp;
        }
        return node;
    }

    public static class CloneMap {
        Map<DAPNode, DAPNode> nodes = new HashMap<DAPNode, DAPNode>();
    }
}

