/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.ArrayList;
import opendap.dap.Attribute;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DAPNode;
import opendap.dap.DArrayDimension;
import opendap.dap.DDS;
import opendap.dap.DVector;
import opendap.dap.InvalidDimensionException;
import opendap.dap.PrimitiveVector;
import opendap.dap.parsers.DDSXMLParser;

public class DArray
extends DVector {
    protected ArrayList<DArrayDimension> dimVector = new ArrayList();

    public DArray() {
        this(null);
    }

    public DArray(String n) {
        super(n);
    }

    @Override
    public String getTypeName() {
        return "Array";
    }

    @Override
    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        if (this.dimVector.isEmpty()) {
            throw new BadSemanticsException("An array variable must have dimensions");
        }
    }

    @Override
    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        this.getPrimitiveVector().printDecl(os, space, false, constrained);
        for (DArrayDimension d : this.dimVector) {
            os.print("[");
            String name = d.getEncodedName();
            if (name != null && name.length() > 0) {
                os.print(d.getEncodedName() + " = ");
            }
            os.print(d.getSize() + "]");
        }
        if (print_semi) {
            os.println(";");
        }
    }

    @Override
    public void printVal(PrintWriter pw, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(pw, space, false);
            pw.print(" = ");
        }
        int dims = this.numDimensions();
        int[] shape = new int[dims];
        int i = 0;
        for (DArrayDimension d : this.dimVector) {
            shape[i++] = d.getSize();
        }
        this.printArray(pw, 0, dims, shape, 0);
        if (print_decl_p) {
            pw.println(";");
        }
        pw.flush();
    }

    private int printArray(PrintWriter os, int index, int dims, int[] shape, int offset) {
        if (dims == 1) {
            os.print("{");
            for (int i = 0; i < shape[offset] - 1; ++i) {
                this.getPrimitiveVector().printSingleVal(os, index++);
                os.print(", ");
            }
            this.getPrimitiveVector().printSingleVal(os, index++);
            os.print("}");
            return index;
        }
        os.print("{");
        for (int i = 0; i < shape[offset] - 1; ++i) {
            index = this.printArray(os, index, dims - 1, shape, offset + 1);
            os.print(",");
        }
        index = this.printArray(os, index, dims - 1, shape, offset + 1);
        os.print("}");
        return index;
    }

    public void appendDim(int size, String name) {
        DArrayDimension newDim = new DArrayDimension(size, name);
        this.dimVector.add(newDim);
        newDim.setContainer(this);
    }

    public void appendDim(int size) {
        this.appendDim(size, null);
    }

    public final ImmutableList<DArrayDimension> getDimensions() {
        return ImmutableList.copyOf(this.dimVector);
    }

    public final int numDimensions() {
        return this.dimVector.size();
    }

    public void squeeze() {
        if (this.dimVector.size() == 1) {
            return;
        }
        ArrayList<DArrayDimension> squeezeCandidates = new ArrayList<DArrayDimension>();
        for (DArrayDimension dim : this.dimVector) {
            if (dim.getSize() != 1) continue;
            squeezeCandidates.add(dim);
        }
        if (squeezeCandidates.size() == this.dimVector.size()) {
            squeezeCandidates.remove(squeezeCandidates.size() - 1);
        }
        this.dimVector.removeAll(squeezeCandidates);
    }

    public DArrayDimension getDimension(int dimension) throws InvalidDimensionException {
        if (dimension < this.dimVector.size()) {
            return this.dimVector.get(dimension);
        }
        throw new InvalidDimensionException("DArray.getDimension(): Bad dimension request: dimension > # of dimensions");
    }

    public DArrayDimension getFirstDimension() {
        return this.dimVector.get(0);
    }

    @Override
    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<Array");
        if (this.getEncodedName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        pw.println(">");
        this.printXMLcore(pw, pad, constrained);
        pw.println(pad + "</Array>");
    }

    public void printAsMapXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<Map");
        if (this.getEncodedName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        pw.println(">");
        this.printXMLcore(pw, pad, constrained);
        pw.println(pad + "</Map>");
    }

    private void printXMLcore(PrintWriter pw, String pad, boolean constrained) {
        for (String attName : this.getAttributeNames()) {
            Attribute a = this.getAttribute(attName);
            if (a == null) continue;
            a.printXML(pw, pad + "\t", constrained);
        }
        BaseType bt = null;
        PrimitiveVector pv = this.getPrimitiveVector();
        bt = pv instanceof BaseTypePrimitiveVector ? pv.getTemplate() : pv.getTemplate();
        String nameCache = bt.getEncodedName();
        bt.setEncodedName(null);
        bt.printXML(pw, pad + "\t", constrained);
        bt.setEncodedName(nameCache);
        for (DArrayDimension dad : this.dimVector) {
            int size = dad.getSize();
            String name = dad.getEncodedName();
            if (name == null) {
                pw.println(pad + "\t<dimension size=\"" + size + "\"/>");
                continue;
            }
            pw.println(pad + "\t<dimension name=\"" + DDSXMLParser.normalizeToXML(name) + "\" size=\"" + size + "\"/>");
        }
    }

    @Override
    public void printConstraint(PrintWriter os) {
        if (this.getParent() != null && !(this.getParent() instanceof DDS)) {
            ((BaseType)this.getParent()).printConstraint(os);
            os.print(".");
        }
        os.print(this.getEncodedName());
        for (DArrayDimension dim : this.dimVector) {
            dim.printConstraint(os);
        }
    }

    @Override
    public DArray cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DArray a = (DArray)super.cloneDAG(map);
        a.dimVector = new ArrayList();
        for (DArrayDimension dim : this.dimVector) {
            DArrayDimension dclone = (DArrayDimension)DArray.cloneDAG(map, dim);
            dclone.setContainer(a);
            a.dimVector.add(dclone);
        }
        return a;
    }
}

