/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.ClientIO;
import opendap.dap.DAPNode;
import opendap.dap.DConstructor;
import opendap.dap.DataReadException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.Util;

public class DStructure
extends DConstructor
implements ClientIO {
    protected ArrayList<BaseType> variables = new ArrayList();

    public DStructure() {
        this("");
    }

    public DStructure(String n) {
        super(n);
    }

    @Override
    public String getTypeName() {
        return "Structure";
    }

    @Override
    public int elementCount(boolean leaves) {
        if (!leaves) {
            return this.variables.size();
        }
        int count = 0;
        for (BaseType bt : this.variables) {
            count += bt.elementCount(leaves);
        }
        return count;
    }

    @Override
    public void addVariable(BaseType v, int part) {
        v.setParent(this);
        this.variables.add(v);
    }

    @Override
    public BaseType getVariable(String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            for (BaseType v : this.variables) {
                if (!v.getEncodedName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DStructure: getVariable()");
    }

    @Override
    public BaseType getVar(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.variables.size() ? 1 : 0) != 0);
        return this.variables.get(index);
    }

    @Override
    public int getVarCount() {
        return this.variables.size();
    }

    @Override
    public ImmutableList<BaseType> getVariables() {
        return ImmutableList.copyOf(this.variables);
    }

    @Override
    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        Util.uniqueNames(this.variables, this.getEncodedName(), this.getTypeName());
        if (all) {
            for (BaseType bt : this.variables) {
                bt.checkSemantics(true);
            }
        }
    }

    @Override
    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.println(space + this.getTypeName() + " {");
        for (BaseType bt : this.variables) {
            bt.printDecl(os, space + "    ", true, constrained);
        }
        os.print(space + "} " + this.getEncodedName());
        if (print_semi) {
            os.println(";");
        }
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        int count = 0;
        os.print("{ ");
        for (BaseType bt : this.variables) {
            if (count > 0) {
                os.print(", ");
            }
            bt.printVal(os, "", false);
            ++count;
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        for (BaseType bt : this.variables) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO client = (ClientIO)((Object)bt);
            client.deserialize(source, sv, statusUI);
        }
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        for (BaseType bt : this.variables) {
            ClientIO client = (ClientIO)((Object)bt);
            client.externalize(sink);
        }
    }

    @Override
    public DStructure cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DStructure s = (DStructure)super.cloneDAG(map);
        s.variables = new ArrayList();
        for (BaseType bt : this.variables) {
            BaseType btclone = (BaseType)DStructure.cloneDAG(map, bt);
            s.variables.add(btclone);
        }
        return s;
    }
}

