/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.DeflaterOutputStream;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.ClientIO;
import opendap.dap.DAP2Exception;
import opendap.dap.DConnect2;
import opendap.dap.DDS;
import opendap.dap.DataReadException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.parsers.ParseException;

public class DataDDS
extends DDS {
    private ServerVersion ver;

    public DataDDS(ServerVersion ver) {
        this.ver = ver;
    }

    public DataDDS(ServerVersion ver, BaseTypeFactory btf) {
        super(btf);
        this.ver = ver;
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    @Override
    public boolean parse(InputStream stream) throws ParseException, DAP2Exception {
        try {
            String text = DConnect2.captureDataDDS(stream);
            return this.parse(text);
        }
        catch (IOException ioe) {
            throw new ParseException("Cannot read DataDDS", ioe);
        }
    }

    public void readData(InputStream is, StatusUI statusUI) throws IOException, EOFException, DAP2Exception {
        BufferedInputStream bufferedIS = new BufferedInputStream(is);
        DataInputStream dataIS = new DataInputStream(bufferedIS);
        for (BaseType bt : this.variables) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO client = (ClientIO)((Object)bt);
            client.deserialize(dataIS, this.ver, statusUI);
        }
        if (statusUI != null) {
            statusUI.finished();
        }
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        long totalBytesRead = 0L;
        byte[] buffer = new byte[8000];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            totalBytesRead += (long)bytesRead;
        }
        return totalBytesRead;
    }

    public void printVal(PrintWriter pw) {
        for (BaseType bt : this.variables) {
            bt.printVal(pw, "", true);
            pw.flush();
        }
        pw.println();
    }

    public final void printVal(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printVal(pw);
        pw.flush();
    }

    public final void externalize(OutputStream os, boolean compress, boolean headers) throws IOException {
        if (headers) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
            pw.println("HTTP/1.0 200 OK");
            pw.println("XDAP: 3.2");
            pw.println("XDODS-Server: DODS/3.2");
            pw.println("Content-type: application/octet-stream");
            pw.println("Content-Description: dods-data");
            if (compress) {
                pw.println("Content-Encoding: deflate");
            }
            pw.println();
            pw.flush();
        }
        BufferedOutputStream bufferedOS = compress ? new BufferedOutputStream(new DeflaterOutputStream(os)) : new BufferedOutputStream(os);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOS, StandardCharsets.UTF_8));
        this.print(pw);
        pw.flush();
        ((OutputStream)bufferedOS).write("\nData:\n".getBytes(StandardCharsets.UTF_8));
        ((OutputStream)bufferedOS).flush();
        DataOutputStream dataOS = new DataOutputStream(bufferedOS);
        for (BaseType bt : this.variables) {
            ClientIO client = (ClientIO)((Object)bt);
            client.externalize(dataOS);
        }
        dataOS.close();
    }

    private static class Counter
    implements StatusUI {
        int counter = 0;

        private Counter() {
        }

        @Override
        public void incrementByteCount(int bytes) {
            this.counter += bytes;
        }

        @Override
        public boolean userCancelled() {
            return false;
        }

        @Override
        public void finished() {
        }

        public String toString() {
            return " " + this.counter;
        }
    }
}

