/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.util.Iterator;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.dods.DodsNetcdfFiles;

class DODSAttribute {
    DODSAttribute() {
    }

    static Attribute create(String rawName, opendap.dap.Attribute att) {
        Array data;
        DataType ncType = DodsNetcdfFiles.convertToNCType(att.getType(), false);
        int nvals = 0;
        Iterator<String> iter = att.getValuesIterator();
        while (iter.hasNext()) {
            iter.next();
            ++nvals;
        }
        String[] vals = new String[nvals];
        iter = att.getValuesIterator();
        int count = 0;
        while (iter.hasNext()) {
            vals[count++] = iter.next();
        }
        if (ncType == DataType.STRING) {
            data = Array.factory((DataType)ncType, (int[])new int[]{nvals}, (Object)vals);
        } else {
            try {
                data = Array.factory((DataType)ncType, (int[])new int[]{nvals});
                Index ima = data.getIndex();
                for (int i = 0; i < nvals; ++i) {
                    double dval = Double.parseDouble(vals[i]);
                    data.setDouble(ima.set(i), dval);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal Numeric Value for Attribute Value for " + rawName);
            }
        }
        String name = DodsNetcdfFiles.makeShortName(rawName);
        String dodsName = DodsNetcdfFiles.makeDODSName(rawName);
        return Attribute.builder((String)name).setValues(data).build();
    }
}

