/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DByte;
import opendap.dap.DConnect2;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DGrid;
import opendap.dap.DInt16;
import opendap.dap.DInt32;
import opendap.dap.DSequence;
import opendap.dap.DString;
import opendap.dap.DStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSAttribute;
import ucar.nc2.dods.DodsGrid;
import ucar.nc2.dods.DodsNetcdfFile;
import ucar.nc2.dods.DodsNetcdfFiles;
import ucar.nc2.dods.DodsStructure;
import ucar.nc2.dods.DodsV;
import ucar.nc2.dods.DodsVariable;
import ucar.nc2.dods.DodsVariableBuilder;
import ucar.nc2.dods.RC;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.StringUtil2;

@NotThreadSafe
abstract class DodsBuilder<T extends DodsBuilder<T>>
extends NetcdfFile.Builder<T> {
    private static Logger logger = LoggerFactory.getLogger(DodsBuilder.class);
    HashSet<Dimension> sharedDimensions = new HashSet();
    DConnect2 dodsConnection;
    DDS dds;
    DAS das;
    private boolean built;

    DodsBuilder() {
    }

    void connect(String datasetUrl, CancelTask cancelTask) throws IOException {
        long start = System.currentTimeMillis();
        String urlName = datasetUrl;
        this.location = datasetUrl;
        if (datasetUrl.startsWith("dods:")) {
            urlName = "http:" + datasetUrl.substring(5);
        } else if (datasetUrl.startsWith("http:")) {
            this.location = "dods:" + datasetUrl.substring(5);
        } else if (datasetUrl.startsWith("https:")) {
            this.location = "dods:" + datasetUrl.substring(6);
        } else if (datasetUrl.startsWith("file:")) {
            this.location = datasetUrl;
        } else {
            throw new MalformedURLException(datasetUrl + " must start with dods: or http: or file:");
        }
        if (DodsNetcdfFiles.debugServerCall) {
            System.out.println("DConnect to = <" + urlName + ">");
        }
        this.dodsConnection = new DConnect2(urlName, DodsNetcdfFile.accept_compress);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        try {
            this.dds = this.dodsConnection.getDDS();
            if (DodsNetcdfFiles.debugServerCall) {
                System.out.println("DodsBuilder readDDS");
            }
            if (DodsNetcdfFiles.debugOpenResult) {
                System.out.println("DDS = ");
                this.dds.print(System.out);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return;
            }
            this.das = this.dodsConnection.getDAS();
            if (DodsNetcdfFiles.debugServerCall) {
                System.out.println("DodsBuilder readDAS");
            }
            if (DodsNetcdfFiles.debugOpenResult) {
                System.out.println("DAS = ");
                this.das.print(System.out);
            }
            if (cancelTask != null && cancelTask.isCancel()) {
                return;
            }
            if (DodsNetcdfFiles.debugOpenResult) {
                System.out.println("dodsVersion = " + this.dodsConnection.getServerVersion());
            }
        }
        catch (DAP2Exception dodsE) {
            if (dodsE.getErrorCode() == 1) {
                throw new FileNotFoundException(dodsE.getMessage());
            }
            dodsE.printStackTrace(System.err);
            throw new IOException("DodsBuilder url=" + this.location, dodsE);
        }
        catch (Throwable t) {
            logger.info("DodsBuilder " + this.location, t);
            throw new IOException("DodsBuilder url=" + this.location, t);
        }
        DodsV rootDodsV = DodsV.parseDDS(this.dds);
        rootDodsV.parseDAS(this.das);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.constructTopVariables(rootDodsV, cancelTask);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.constructConstructors(rootDodsV, cancelTask);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        this.parseGlobalAttributes(this.das, rootDodsV);
        if (cancelTask != null && cancelTask.isCancel()) {
            return;
        }
        int pos = urlName.indexOf(63);
        if (0 <= pos) {
            String datasetName = urlName.substring(0, pos);
            if (DodsNetcdfFiles.debugServerCall) {
                System.out.println(" reconnect to = <" + datasetName + ">");
            }
            this.dodsConnection = new DConnect2(datasetName, DodsNetcdfFile.accept_compress);
            String CE = urlName.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(CE, " ,");
            while (stoke.hasMoreTokens()) {
                String proj = stoke.nextToken();
                int subsetPos = proj.indexOf(91);
                if (DodsNetcdfFiles.debugCE) {
                    System.out.println(" CE = " + proj + " " + subsetPos);
                }
                if (subsetPos <= 0) continue;
                String vname = proj.substring(0, subsetPos);
                String vCE = proj.substring(subsetPos);
                if (DodsNetcdfFiles.debugCE) {
                    System.out.println(" vCE = <" + vname + "><" + vCE + ">");
                }
                Variable.Builder var = (Variable.Builder)this.rootGroup.findVariable(vname).orElseThrow(() -> new IOException("Variable not found: " + vname));
                DodsVariableBuilder dodsVar = (DodsVariableBuilder)var;
                dodsVar.setCE(vCE);
                dodsVar.setIsCaching(true);
            }
        }
        if (DodsNetcdfFiles.showNCfile) {
            System.out.println("DODS nc file = " + (Object)((Object)this));
        }
        long took = System.currentTimeMillis() - start;
        if (DodsNetcdfFiles.debugOpenTime) {
            System.out.printf(" took %d msecs %n", took);
        }
    }

    private void parseGlobalAttributes(DAS das, DodsV root) {
        for (Attribute ncatt : root.attributes) {
            this.rootGroup.addAttribute(ncatt);
        }
        for (String tableName : das) {
            Attribute ncatt;
            opendap.dap.Attribute att;
            AttributeTable attTable = das.getAttributeTableN(tableName);
            if (attTable == null) continue;
            if (tableName.equals("DODS_EXTRA")) {
                for (String attName : attTable) {
                    if (attName.equals("Unlimited_Dimension")) {
                        att = attTable.getAttribute(attName);
                        ncatt = DODSAttribute.create(attName, att);
                        this.setUnlimited(ncatt.getStringValue());
                        continue;
                    }
                    logger.warn(" Unknown DODS_EXTRA attribute = " + attName + " " + this.location);
                }
                continue;
            }
            if (!tableName.equals("EXTRA_DIMENSION")) continue;
            for (String attName : attTable) {
                att = attTable.getAttribute(attName);
                ncatt = DODSAttribute.create(attName, att);
                int length = ncatt.getNumericValue().intValue();
                this.rootGroup.addDimension(new Dimension(attName, length));
            }
        }
    }

    private void constructTopVariables(DodsV rootDodsV, CancelTask cancelTask) throws IOException {
        List<DodsV> topVariables = rootDodsV.children;
        for (DodsV dodsV : topVariables) {
            if (dodsV.bt instanceof DConstructor) continue;
            this.addVariable(this.rootGroup, null, dodsV);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    private void addAttributes(Group.Builder g, DodsV dodsV) {
        for (Attribute ncatt : dodsV.attributes) {
            g.addAttribute(ncatt);
        }
    }

    private void addAttributes(Variable.Builder<?> v, DodsV dodsV) {
        for (Attribute ncatt : dodsV.attributes) {
            v.addAttribute(ncatt);
        }
        Attribute axes = v.getAttributeContainer().findAttribute("coordinates");
        Attribute _axes = v.getAttributeContainer().findAttribute("_CoordinateAxes");
        if (null != axes && null != _axes) {
            v.addAttribute(DodsBuilder.combineAxesAttrs(axes, _axes));
        }
    }

    Variable.Builder<?> addVariable(Group.Builder parentGroup, @Nullable Structure.Builder<?> parentStructure, DodsV dodsV) throws IOException {
        Variable.Builder<?> v = this.makeVariable(parentGroup, parentStructure, dodsV);
        if (v != null) {
            this.addAttributes(v, dodsV);
            if (parentStructure != null) {
                parentStructure.addMemberVariable(v);
            } else {
                parentGroup = this.computeGroup(v, parentGroup);
                parentGroup.addVariable(v);
            }
            dodsV.isDone = true;
        }
        return v;
    }

    @Nullable
    private Variable.Builder<?> makeVariable(Group.Builder parentGroup, Structure.Builder<?> parentStructure, DodsV dodsV) throws IOException {
        BaseType dodsBT = dodsV.bt;
        String dodsShortName = dodsBT.getClearName();
        if (DodsNetcdfFiles.debugConstruct) {
            System.out.print("DODSNetcdf makeVariable try to init <" + dodsShortName + "> :");
        }
        if (dodsBT instanceof DString) {
            if (dodsV.darray == null) {
                if (DodsNetcdfFiles.debugConstruct) {
                    System.out.println("  assigned to DString: name = " + dodsShortName);
                }
                return DodsVariable.builder(this, parentGroup, dodsShortName, dodsV);
            }
            if (DodsNetcdfFiles.debugConstruct) {
                System.out.println("  assigned to Array of Strings: name = " + dodsShortName);
            }
            return DodsVariable.builder(this, parentGroup, dodsShortName, dodsV.darray, dodsV);
        }
        if (dodsBT instanceof DByte || dodsBT instanceof DFloat32 || dodsBT instanceof DFloat64 || dodsBT instanceof DInt16 || dodsBT instanceof DInt32) {
            if (dodsV.darray == null) {
                if (DodsNetcdfFiles.debugConstruct) {
                    System.out.printf("  assigned to scalar %s: name=%s%n", dodsBT.getTypeName(), dodsShortName);
                }
                return DodsVariable.builder(this, parentGroup, dodsShortName, dodsV);
            }
            if (DodsNetcdfFiles.debugConstruct) {
                System.out.printf("  assigned to array of type %s: name = %s%n", dodsBT.getClass().getName(), dodsShortName);
            }
            return DodsVariable.builder(this, parentGroup, dodsShortName, dodsV.darray, dodsV);
        }
        if (dodsBT instanceof DGrid) {
            if (dodsV.darray == null) {
                if (DodsNetcdfFiles.debugConstruct) {
                    System.out.println(" assigned to DGrid <" + dodsShortName + ">");
                }
                for (int i = 1; i < dodsV.children.size(); ++i) {
                    DodsV map = dodsV.children.get(i);
                    String shortName = DodsNetcdfFiles.makeShortName(map.bt.getEncodedName());
                    Variable.Builder<?> mapV = parentGroup.findVariableLocal(shortName).orElse(null);
                    if (mapV != null) continue;
                    mapV = this.addVariable(parentGroup, parentStructure, map);
                    this.makeCoordinateVariable(parentGroup, mapV, map.data);
                }
                return DodsGrid.builder(parentGroup, dodsShortName, dodsV);
            }
            if (DodsNetcdfFiles.debugConstruct) {
                System.out.println(" ERROR! array of DGrid <" + dodsShortName + ">");
            }
            return null;
        }
        if (dodsBT instanceof DSequence) {
            if (dodsV.darray == null) {
                if (DodsNetcdfFiles.debugConstruct) {
                    System.out.println(" assigned to DSequence <" + dodsShortName + ">");
                }
                return DodsStructure.builder(this, parentGroup, dodsShortName, dodsV);
            }
            if (DodsNetcdfFiles.debugConstruct) {
                System.out.println(" ERROR! array of DSequence <" + dodsShortName + ">");
            }
            return null;
        }
        if (dodsBT instanceof DStructure) {
            DStructure dstruct = (DStructure)dodsBT;
            if (dodsV.darray == null) {
                if (RC.getUseGroups() && parentStructure == null && this.isGroup(dstruct)) {
                    Group.Builder gnested = Group.builder().setName(DodsNetcdfFiles.makeShortName(dodsShortName));
                    this.addAttributes(gnested, dodsV);
                    parentGroup.addGroup(gnested);
                    for (DodsV nested : dodsV.children) {
                        this.addVariable(gnested, null, nested);
                    }
                    return null;
                }
                return DodsStructure.builder(this, parentGroup, dodsShortName, dodsV);
            }
            return DodsStructure.builder(this, parentGroup, dodsShortName, dodsV.darray, dodsV);
        }
        logger.warn("DODSNetcdf " + this.location + " didnt process basetype <" + dodsBT.getTypeName() + "> variable = " + dodsShortName);
        return null;
    }

    private void makeCoordinateVariable(Group.Builder parentGroup, Variable.Builder<?> v, Array data) {
        String name = v.shortName;
        ArrayList<Dimension> dims = new ArrayList<Dimension>((Collection<Dimension>)v.getDimensions());
        Dimension oldDimension = (Dimension)dims.get(0);
        Dimension newDimension = new Dimension(name, oldDimension.getLength());
        dims.set(0, newDimension);
        v.setDimensions(dims);
        parentGroup.replaceDimension(newDimension);
        if (data != null) {
            v.setSourceData(data);
        }
    }

    private void constructConstructors(DodsV rootDodsV, CancelTask cancelTask) throws IOException {
        List<DodsV> topVariables = rootDodsV.children;
        for (DodsV dodsV : topVariables) {
            if (dodsV.isDone || dodsV.bt instanceof DGrid) continue;
            this.addVariable(this.rootGroup, null, dodsV);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        for (DodsV dodsV : topVariables) {
            DodsV array;
            if (dodsV.isDone) continue;
            if (RC.getUseGroups() && dodsV.bt instanceof DGrid && (array = dodsV.findByIndex(0)) != null) {
                String apath;
                String arrayname = array.getClearName();
                String gridname = dodsV.getClearName();
                int ai = arrayname.lastIndexOf(47);
                int gi = gridname.lastIndexOf(47);
                if (gi >= 0 && ai < 0) {
                    String gpath = gridname.substring(0, gi);
                    arrayname = gpath + "/" + arrayname;
                    array.getBaseType().setClearName(arrayname);
                } else if (gi < 0 && ai >= 0) {
                    apath = arrayname.substring(0, ai);
                    gridname = apath + "/" + gridname;
                    dodsV.getBaseType().setClearName(gridname);
                } else if (gi >= 0) {
                    apath = arrayname.substring(0, ai);
                    String gpath = gridname.substring(0, gi);
                    if (!gpath.equals(apath)) {
                        String arraysuffix = arrayname.substring(gi + 1);
                        arrayname = gpath + "/" + arraysuffix;
                        array.getBaseType().setClearName(arrayname);
                    }
                }
            }
            this.addVariable(this.rootGroup, null, dodsV);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    private Group.Builder computeGroup(Variable.Builder<?> v, Group.Builder parentGroup) {
        return parentGroup;
    }

    Group.Builder makeRelativeGroup(Group.Builder parent, String path, boolean ignorelast) {
        boolean isabsolute;
        path = path.trim();
        boolean bl = isabsolute = (path = path.replace("//", "/")).charAt(0) == '/';
        if (isabsolute) {
            path = path.substring(1);
        }
        String[] pieces = path.split("/");
        if (ignorelast) {
            pieces[pieces.length - 1] = null;
        }
        Group.Builder current = isabsolute ? this.rootGroup : parent;
        for (String name : pieces) {
            if (name == null) continue;
            String clearname = NetcdfFiles.makeNameUnescaped((String)name);
            Group.Builder next = current.findGroupLocal(clearname).orElse(null);
            if (next == null) {
                next = Group.builder().setName(clearname);
                current.addGroup(next);
            }
            current = next;
        }
        return current;
    }

    private boolean isGroup(DStructure dstruct) {
        BaseType parent = (BaseType)dstruct.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof DStructure) {
            return this.isGroup((DStructure)parent);
        }
        return true;
    }

    static Attribute combineAxesAttrs(Attribute axis1, Attribute axis2) {
        String[] axisValues;
        ArrayList<String> axesCombinedValues = new ArrayList<String>();
        String axisValuesStr = axis1.getStringValue() + " " + axis2.getStringValue();
        for (String ax : axisValues = axisValuesStr.split("\\s")) {
            if (axesCombinedValues.contains(ax) || ax.equals("")) continue;
            axesCombinedValues.add(ax);
        }
        return new Attribute("_CoordinateAxes", String.join((CharSequence)" ", axesCombinedValues));
    }

    Dimension getNetcdfStrlenDim(DodsVariable.Builder<?> v) {
        int dimLength;
        String dimName;
        AttributeTable table = this.das.getAttributeTableN(v.getFullName());
        if (table == null) {
            return null;
        }
        opendap.dap.Attribute dodsAtt = table.getAttribute("DODS");
        if (dodsAtt == null) {
            return null;
        }
        AttributeTable dodsTable = dodsAtt.getContainerN();
        if (dodsTable == null) {
            return null;
        }
        opendap.dap.Attribute att = dodsTable.getAttribute("strlen");
        if (att == null) {
            return null;
        }
        String strlen = att.getValueAtN(0);
        opendap.dap.Attribute att2 = dodsTable.getAttribute("dimName");
        String string = dimName = att2 == null ? null : att2.getValueAtN(0);
        if (DodsNetcdfFiles.debugCharArray) {
            System.out.println(v.getFullName() + " has strlen= " + strlen + " dimName= " + dimName);
        }
        try {
            dimLength = Integer.parseInt(strlen);
        }
        catch (NumberFormatException e) {
            logger.warn("DodsBuilder " + this.location + " var = " + v.getFullName() + " error on strlen attribute = " + strlen);
            return null;
        }
        if (dimLength <= 0) {
            return null;
        }
        return Dimension.builder((String)dimName, (int)dimLength).setIsShared(dimName != null).build();
    }

    Dimension getSharedDimension(Group.Builder group, Dimension d) {
        if (d.getShortName() == null) {
            return d;
        }
        boolean has = this.sharedDimensions.contains(d);
        if (group == null) {
            group = this.rootGroup;
        }
        for (Dimension sd : group.getDimensions()) {
            if (!sd.getShortName().equals(d.getShortName()) || sd.getLength() != d.getLength()) continue;
            return sd;
        }
        group.addDimension(d);
        return d;
    }

    List<Dimension> constructDimensions(Group.Builder group, DArray dodsArray) {
        if (group == null) {
            group = this.rootGroup;
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (DArrayDimension dad : dodsArray.getDimensions()) {
            Dimension myd;
            String name = dad.getEncodedName();
            if (name != null) {
                name = StringUtil2.unescape((String)name);
            }
            if (name == null) {
                myd = Dimension.builder(null, (int)dad.getSize()).setIsShared(false).build();
            } else {
                if (RC.getUseGroups() && name.indexOf(47) >= 0) {
                    group = this.makeRelativeGroup(group, name, true);
                    name = name.substring(name.lastIndexOf(47) + 1);
                }
                if ((myd = (Dimension)group.findDimensionLocal(name).orElse(null)) == null) {
                    myd = new Dimension(name, dad.getSize());
                    group.addDimension(myd);
                } else if (myd.getLength() != dad.getSize()) {
                    myd = Dimension.builder((String)name, (int)dad.getSize()).setIsShared(false).build();
                }
            }
            dims.add(myd);
        }
        return dims;
    }

    private void setUnlimited(String dimName) {
        Dimension dim = this.rootGroup.findDimension(dimName).orElse(null);
        if (dim == null) {
            logger.error(" DODS Unlimited_Dimension = " + dimName + " not found on " + this.location);
        }
    }

    protected abstract T self();

    DodsNetcdfFile build(String datasetUrl, CancelTask cancelTask) throws IOException {
        if (this.built) {
            throw new IllegalStateException("already built");
        }
        this.built = true;
        this.connect(datasetUrl, cancelTask);
        return new DodsNetcdfFile(this);
    }
}

