/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import java.util.List;
import opendap.dap.DArray;
import opendap.dap.DConstructor;
import opendap.dap.DSequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.dods.DodsBuilder;
import ucar.nc2.dods.DodsNetcdfFile;
import ucar.nc2.dods.DodsNetcdfFiles;
import ucar.nc2.dods.DodsNode;
import ucar.nc2.dods.DodsV;
import ucar.nc2.dods.DodsVariableBuilder;

class DodsStructure
extends Structure
implements DodsNode {
    private final DConstructor constructor;
    private final DodsNetcdfFile dodsfile;
    private final String dodsName;

    static Builder<?> builder(DodsBuilder<?> dodsBuilder, Group.Builder parentGroup, String dodsShortName, DodsV dodsV) throws IOException {
        Builder builder = (Builder)((Builder)((Builder)DodsStructure.builder().setName(DodsNetcdfFiles.makeShortName(dodsShortName))).setDataType(dodsV.getDataType())).setSPobject(dodsV);
        builder.setConstructor((DConstructor)dodsV.bt);
        if (builder.constructor instanceof DSequence) {
            builder.addDimension(Dimension.VLEN);
        }
        for (DodsV nested : dodsV.children) {
            dodsBuilder.addVariable(parentGroup, builder, nested);
        }
        builder.setSPobject(dodsV);
        return builder;
    }

    static Builder<?> builder(DodsBuilder<?> dodsBuilder, Group.Builder parentGroup, String dodsShortName, DArray dodsArray, DodsV dodsV) throws IOException {
        Builder builder = (Builder)((Builder)((Builder)DodsStructure.builder().setName(DodsNetcdfFiles.makeShortName(dodsShortName))).setDataType(dodsV.getDataType())).setSPobject(dodsV);
        builder.setConstructor((DConstructor)dodsV.bt);
        for (DodsV nested : dodsV.children) {
            dodsBuilder.addVariable(parentGroup, builder, nested);
        }
        builder.setSPobject(dodsV);
        List<Dimension> dims = dodsBuilder.constructDimensions(parentGroup, dodsArray);
        builder.setDimensions(dims);
        return builder;
    }

    DConstructor getDConstructor() {
        return this.constructor;
    }

    @Override
    public String getDodsName() {
        return this.dodsName;
    }

    public StructureDataIterator getStructureIterator(String CE) throws IOException {
        return new SequenceIterator(CE);
    }

    protected DodsStructure(Builder<?> builder, Group parentGroup) {
        super(builder, parentGroup);
        this.constructor = ((Builder)builder).constructor;
        this.isVariableLength = ((Builder)builder).constructor instanceof DSequence;
        this.dodsName = ((Builder)builder).dodsName != null ? ((Builder)builder).dodsName : builder.shortName;
        this.dodsfile = (DodsNetcdfFile)parentGroup.getNetcdfFile();
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(DodsStructure.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        this.members.forEach(m -> {
            Builder cfr_ignored_0 = (Builder)b.addMemberVariable(m.toBuilder());
        });
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Structure.Builder<T>
    implements DodsVariableBuilder<T> {
        private boolean built;
        private String dodsName;
        private DConstructor constructor;
        private String CE;

        public void setDodsName(String name) {
            this.dodsName = name;
        }

        public void setConstructor(DConstructor constructor) {
            this.constructor = constructor;
        }

        @Override
        public T setCE(String CE) {
            this.CE = CE;
            return (T)((Builder)this.self());
        }

        public DodsStructure build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.setDataType(DataType.STRUCTURE);
            return new DodsStructure(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        protected Builder2 self() {
            return this;
        }
    }

    private class SequenceIterator
    implements StructureDataIterator {
        private int nrows;
        private int row = 0;
        private ArrayStructure structArray;

        SequenceIterator(String CE) throws IOException {
            this.structArray = (ArrayStructure)DodsStructure.this.read();
            this.nrows = (int)this.structArray.getSize();
        }

        public boolean hasNext() {
            return this.row < this.nrows;
        }

        public StructureData next() {
            return this.structArray.getStructureData(this.row++);
        }

        public StructureDataIterator reset() {
            this.row = 0;
            return this;
        }

        public int getCurrentRecno() {
            return this.row - 1;
        }
    }
}

