/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.util.ArrayList;
import java.util.List;
import opendap.dap.DArray;
import ucar.array.ArrayType;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.dods.DodsBuilder;
import ucar.nc2.dods.DodsNetcdfFile;
import ucar.nc2.dods.DodsNetcdfFiles;
import ucar.nc2.dods.DodsNode;
import ucar.nc2.dods.DodsV;
import ucar.nc2.dods.DodsVariableBuilder;

class DodsVariable
extends Variable
implements DodsNode {
    private final String CE;
    private final String dodsName;
    private final DodsNetcdfFile dodsfile;

    static Builder<?> builder(DodsBuilder<?> dodsBuilder, Group.Builder parentGroup, String dodsShortName, DodsV dodsV) {
        Dimension strlenDim;
        Builder builder = (Builder)((Builder)((Builder)DodsVariable.builder().setName(DodsNetcdfFiles.makeShortName(dodsShortName))).setDataType(dodsV.getDataType())).setSPobject(dodsV);
        if (builder.dataType == ArrayType.STRING && null != (strlenDim = dodsBuilder.getNetcdfStrlenDim(builder))) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            if (strlenDim.getLength() != 0) {
                dims.add(dodsBuilder.getSharedDimension(parentGroup, strlenDim));
            }
            builder.setDimensions(dims);
            builder.setArrayType(ArrayType.CHAR);
        }
        return builder;
    }

    static Builder<?> builder(DodsBuilder<?> dodsBuilder, Group.Builder parentGroup, String dodsShortName, DArray dodsArray, DodsV dodsV) {
        Dimension strlenDim;
        Builder builder = (Builder)((Builder)((Builder)DodsVariable.builder().setName(DodsNetcdfFiles.makeShortName(dodsShortName))).setDataType(dodsV.getDataType())).setSPobject(dodsV);
        List<Dimension> dims = dodsBuilder.constructDimensions(parentGroup, dodsArray);
        if (builder.dataType == ArrayType.STRING && null != (strlenDim = dodsBuilder.getNetcdfStrlenDim(builder))) {
            if (strlenDim.getLength() != 0) {
                dims.add(dodsBuilder.getSharedDimension(parentGroup, strlenDim));
            }
            builder.setArrayType(ArrayType.CHAR);
        }
        builder.setDimensions(dims);
        return builder;
    }

    @Override
    public String getDodsName() {
        return this.dodsName;
    }

    protected boolean hasCE() {
        return this.CE != null;
    }

    protected String nameWithCE() {
        return this.hasCE() ? this.getShortName() + this.CE : this.getShortName();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof DodsVariable)) {
            return false;
        }
        DodsVariable o = (DodsVariable)oo;
        if (this.CE == null ^ o.CE == null) {
            return false;
        }
        return super.equals(oo);
    }

    public int hashCode() {
        int supercode = super.hashCode();
        if (this.CE != null) {
            supercode += 37 * this.CE.hashCode();
        }
        return supercode;
    }

    protected DodsVariable(Builder<?> builder, Group parentGroup) {
        super(builder, parentGroup);
        this.CE = ((Builder)builder).CE;
        this.dodsName = ((Builder)builder).dodsName != null ? ((Builder)builder).dodsName : builder.shortName;
        this.dodsfile = (DodsNetcdfFile)parentGroup.getNetcdfFile();
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(DodsVariable.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Variable.Builder<T>
    implements DodsVariableBuilder<T> {
        private boolean built;
        private String CE;
        private String dodsName;

        @Override
        public T setCE(String CE) {
            this.CE = CE;
            return (T)((Builder)this.self());
        }

        public void setDodsName(String name) {
            this.dodsName = name;
        }

        public DodsVariable build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new DodsVariable(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        protected Builder2 self() {
            return this;
        }
    }
}

