/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DConnect2;
import opendap.dap.DataDDS;
import opendap.dap.parsers.ParseException;
import opendap.servlet.ReqState;
import opendap.servlet.ascii.asciiFactory;
import opendap.servlet.ascii.toASCII;
import opendap.util.Debug;

public class GetAsciiHandler {
    private static final boolean _Debug = false;

    public void sendASCII(ReqState rs, String dataSet) throws DAP2Exception, ParseException {
        if (Debug.isSet((String)"showResponse")) {
            System.out.println("Sending OPeNDAP ASCII Data For: " + dataSet + "    CE: '" + rs.getConstraintExpression() + "'");
        }
        String ce = rs.getConstraintExpression() == null ? "" : "?" + rs.getConstraintExpression();
        int suffixIndex = rs.getRequestURL().toString().lastIndexOf(".");
        String requestURL = rs.getRequestURL().substring(0, suffixIndex);
        if (Debug.isSet((String)"showResponse")) {
            System.out.println("New Request URL Resource: '" + requestURL + "'");
            System.out.println("New Request Constraint Expression: '" + ce + "'");
        }
        try (DConnect2 url = new DConnect2(requestURL, true);){
            DataDDS dds = url.getData(ce, null, (BaseTypeFactory)new asciiFactory());
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)rs.getResponse().getOutputStream(), StandardCharsets.UTF_8));
            PrintWriter pwDebug = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
            if (dds != null) {
                dds.print(pw);
                pw.println("---------------------------------------------");
                String s = "";
                Enumeration e = dds.getVariables();
                while (e.hasMoreElements()) {
                    BaseType bt = (BaseType)e.nextElement();
                    ((toASCII)bt).toASCII(pw, true, null, true);
                }
            } else {
                String betterURL = rs.getRequestURL().substring(0, rs.getRequestURL().lastIndexOf(".")) + ".dods?" + rs.getConstraintExpression();
                pw.println("-- ASCII RESPONSE HANDLER PROBLEM --");
                pw.println("");
                pw.println("The ASCII response handler was unable to obtain requested data set.");
                pw.println("");
                pw.println("Because this handler calls it's own OPeNDAP server to get the requested");
                pw.println("data the source error is obscured.");
                pw.println("");
                pw.println("To get a better idea of what is going wrong, try requesting the URL:");
                pw.println("");
                pw.println("    " + betterURL);
                pw.println("");
                pw.println("And then look carefully at the returned document. Note that if you");
                pw.println("are using a browser to access the URL the returned document will");
                pw.println("more than likely be treated as a download and written to your");
                pw.println("local disk. It should be a file with the extension \".dods\"");
                pw.println("");
                pw.println("Locate it, open it with a text editor, and find your");
                pw.println("way to happiness and inner peace.");
                pw.println("");
            }
            pw.flush();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("OUCH! FileNotFoundException: " + fnfe.getMessage());
            fnfe.printStackTrace(System.out);
        }
        catch (MalformedURLException mue) {
            System.out.println("OUCH! MalformedURLException: " + mue.getMessage());
            mue.printStackTrace(System.out);
        }
        catch (IOException ioe) {
            System.out.println("OUCH! IOException: " + ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
        catch (Throwable t) {
            System.out.println("OUCH! Throwable: " + t.getMessage());
            t.printStackTrace(System.out);
        }
    }
}

