/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil2;

public class LoggerFactorySpecial
implements ucar.nc2.util.log.LoggerFactory {
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private String dir = "./";
    private Level level = Level.INFO;
    private static Map<String, Logger> map = new HashMap<String, Logger>();

    public LoggerFactorySpecial(Level lev) {
        String p = System.getProperty("tds.log.dir");
        if (p != null) {
            this.dir = p;
        }
        this.level = lev;
    }

    public Logger getLogger(String name) {
        Logger result = map.get(name = StringUtil2.replace((String)name.trim(), (char)' ', (String)"_"));
        if (result != null) {
            return result;
        }
        try {
            String fileName = this.dir + "/" + name + ".log";
            PatternLayout layout = new PatternLayout("%d{yyyy-MM-dd'T'HH:mm:ss.SSS Z} %-5p - %m%n");
            RollingFileAppender app = new RollingFileAppender((Layout)layout, fileName);
            app.setMaxBackupIndex(5);
            app.setMaximumFileSize(1000000L);
            app.setFile(fileName);
            app.activateOptions();
            org.apache.log4j.Logger log4j = LogManager.getLogger((String)name);
            log4j.addAppender((Appender)app);
            log4j.setLevel(this.level);
            log4j.setAdditivity(false);
            startupLog.info("LoggerFactorySpecial add logger= {} file= {}", (Object)name, (Object)fileName);
            result = LoggerFactory.getLogger((String)name);
            map.put(name, result);
            return result;
        }
        catch (IOException ioe) {
            startupLog.error("LoggerFactorySpecial failed on " + name, (Throwable)ioe);
            return LoggerFactory.getLogger((String)name);
        }
    }
}

