/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil2;

public class LoggerFactorySpecial
implements ucar.nc2.util.log.LoggerFactory {
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private String dir = "./";
    private long maxSize;
    private int maxBackups;
    private Level level = Level.INFO;
    private static Map<String, Logger> map = new HashMap<String, Logger>();

    public LoggerFactorySpecial(long maxSize, int maxBackups, String levels) {
        String p = System.getProperty("tds.log.dir");
        if (p != null) {
            this.dir = p;
        }
        this.maxSize = maxSize;
        this.maxBackups = maxBackups;
        try {
            Level tlevel = Level.toLevel((String)levels);
            if (tlevel != null) {
                this.level = tlevel;
            }
        }
        catch (Exception e) {
            startupLog.error("Illegal Logger level=" + levels);
        }
    }

    public Logger getLogger(String name) {
        Logger result = map.get(name = StringUtil2.replace((String)name.trim(), (char)' ', (String)"_"));
        if (result != null) {
            return result;
        }
        try {
            String fileName = this.dir + "/" + name + ".log";
            String fileNamePattern = this.dir + "/" + name + "%i.log";
            NullConfiguration config = new NullConfiguration();
            PatternLayout layout = PatternLayout.createLayout((String)"%d{yyyy-MM-dd'T'HH:mm:ss.SSS Z} %-5p - %m%n", (Configuration)config, null, null, (String)"no");
            RollingFileAppender app = RollingFileAppender.createAppender((String)fileName, (String)fileNamePattern, (String)"true", (String)name, (String)"true", (String)"true", (TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)Long.toString(this.maxSize)), (RolloverStrategy)DefaultRolloverStrategy.createStrategy((String)Integer.toString(this.maxBackups), (String)"1", (String)"max", null, (Configuration)config), (Layout)layout, null, (String)"true", (String)"false", null, (Configuration)config);
            app.start();
            org.apache.logging.log4j.core.Logger log4j = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)name);
            log4j.addAppender((Appender)app);
            log4j.setLevel(this.level);
            log4j.setAdditive(false);
            startupLog.info("LoggerFactorySpecial add logger= {} file= {}", (Object)name, (Object)fileName);
            result = LoggerFactory.getLogger((String)name);
            map.put(name, result);
            return result;
        }
        catch (Throwable ioe) {
            startupLog.error("LoggerFactorySpecial failed on " + name, ioe);
            return LoggerFactory.getLogger((String)name);
        }
    }
}

