/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;
import thredds.util.PathAliasReplacement;

public class PathAliasReplacementImpl
implements PathAliasReplacement {
    private static boolean debug = false;
    private final String alias;
    private final String replacementPath;

    public static List<PathAliasReplacement> makePathAliasReplacements(Map<String, String> aliases) {
        ArrayList<PathAliasReplacement> result = new ArrayList<PathAliasReplacement>();
        for (String key : aliases.keySet()) {
            String value = aliases.get(key);
            if (value == null || value.isEmpty()) continue;
            PathAliasReplacementImpl alias = new PathAliasReplacementImpl("${" + key + "}", value);
            result.add(alias);
            if (!debug) continue;
            System.out.printf("DataRootHandler alias= %s%n", alias);
        }
        return result;
    }

    public PathAliasReplacementImpl(String alias, String replacementPath) {
        if (alias == null) {
            throw new IllegalArgumentException("Alias must not be null.");
        }
        if (replacementPath == null) {
            throw new IllegalArgumentException("Replacment path must not be null.");
        }
        alias = StringUtils.cleanPath((String)alias);
        replacementPath = StringUtils.cleanPath((String)replacementPath);
        this.alias = alias.endsWith("/") ? alias.substring(0, alias.length() - 1) : alias;
        this.replacementPath = replacementPath.endsWith("/") ? replacementPath.substring(0, replacementPath.length() - 1) : replacementPath;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getReplacementPath() {
        return this.replacementPath;
    }

    public boolean containsPathAlias(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        path = StringUtils.cleanPath((String)path);
        return path.startsWith(this.alias + "/");
    }

    public String replacePathAlias(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        if (!(path = StringUtils.cleanPath((String)path)).startsWith(this.alias + "/")) {
            throw new IllegalArgumentException("Path [" + path + "] does not contain alias [startWith( \"" + this.alias + "/\" )].");
        }
        return this.replacementPath + path.substring(this.alias.length());
    }

    public String replaceIfMatch(String path) {
        if (!path.startsWith(this.alias)) {
            return null;
        }
        return this.replacementPath + path.substring(this.alias.length());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StartsWithPathAliasReplacement{");
        sb.append("alias='").append(this.alias).append('\'');
        sb.append(", replacementPath='").append(this.replacementPath).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

