/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Service;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;
import thredds.inventory.filter.CompositeMFileFilter;
import thredds.inventory.filter.FilterNegate;
import thredds.inventory.filter.LastModifiedLimit;
import thredds.inventory.filter.RegExpMatchOnName;
import thredds.inventory.filter.WildcardMatchOnName;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.DatasetScanConfig;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.CloseableIterator;

@Immutable
public class DatasetScan
extends CatalogRef {
    private static Logger log = LoggerFactory.getLogger(DatasetScan.class);
    private final DatasetScanConfig config;
    private final AddTimeCoverageEnhancer addTimeCoverage;
    private final List<RegExpNamer> namers;
    private final CompositeMFileFilter fileFilters;
    private final CompositeMFileFilter dirFilters;

    public DatasetScan(DatasetNode parent, String name, String xlink, Map<String, Object> flds, List<AccessBuilder> accessBuilders, List<DatasetBuilder> datasetBuilders, DatasetScanConfig config) {
        super(parent, name, xlink, flds, accessBuilders, datasetBuilders);
        this.config = config;
        AddTimeCoverageEnhancer addTimeCoverageEnhancer = this.addTimeCoverage = config.addTimeCoverage != null ? new AddTimeCoverageEnhancer(config.addTimeCoverage) : null;
        if (config.namers != null && config.namers.size() > 0) {
            this.namers = new ArrayList<RegExpNamer>();
            for (DatasetScanConfig.Namer cname : config.namers) {
                this.namers.add(new RegExpNamer(cname));
            }
        } else {
            this.namers = null;
        }
        if (config.filters != null && config.filters.size() > 0) {
            this.fileFilters = new CompositeMFileFilter();
            this.dirFilters = new CompositeMFileFilter();
            for (DatasetScanConfig.Filter cfilter : config.filters) {
                this.makeFilter(cfilter);
            }
        } else {
            this.fileFilters = null;
            this.dirFilters = null;
        }
    }

    private void makeFilter(DatasetScanConfig.Filter cfilter) {
        WildcardMatchOnName filter;
        if (cfilter.wildcardAttVal != null) {
            filter = new WildcardMatchOnName(cfilter.wildcardAttVal);
        } else if (cfilter.regExpAttVal != null) {
            filter = new RegExpMatchOnName(cfilter.regExpAttVal);
        } else if (cfilter.lastModLimitAttVal > 0L) {
            filter = new LastModifiedLimit(cfilter.lastModLimitAttVal);
        } else {
            return;
        }
        if (!cfilter.includer) {
            filter = new FilterNegate((MFileFilter)filter);
        }
        if (cfilter.collection) {
            this.dirFilters.addFilter((MFileFilter)filter);
        }
        if (cfilter.atomic) {
            this.fileFilters.addFilter((MFileFilter)filter);
        }
    }

    public String getPath() {
        return this.config.path;
    }

    public String getScanLocation() {
        return this.config.scanDir;
    }

    DatasetScanConfig getConfig() {
        return this.config;
    }

    public Catalog makeCatalogForDirectory(String orgPath, URI catURI) throws IOException {
        String dataDirReletive = this.translatePathToLocation(orgPath);
        if (dataDirReletive == null) {
            String tmpMsg = "makeCatalogForDirectory(): Requesting path <" + orgPath + "> must start with \"" + this.config.path + "\".";
            log.error(tmpMsg);
            return null;
        }
        String parentPath = dataDirReletive.length() > 1 ? this.config.path + "/" + dataDirReletive : this.config.path + "/";
        String parentId = dataDirReletive.length() > 1 ? this.getId() + "/" + dataDirReletive : this.getId() + "/";
        String scanDir = ConfigCatalog.translateAlias(this.config.scanDir);
        String dataDirComplete = dataDirReletive.length() > 1 ? scanDir + "/" + dataDirReletive : scanDir;
        CatalogBuilder catBuilder = new CatalogBuilder();
        catBuilder.setBaseURI(catURI);
        assert (this.getParentCatalog() != null);
        for (Service s : this.getParentCatalog().getServices()) {
            catBuilder.addService(s);
        }
        DatasetBuilder top = new DatasetBuilder(null);
        String name = dataDirReletive.length() > 1 ? dataDirReletive : this.getName();
        top.transferMetadata((Dataset)this, true);
        top.setName(name);
        top.put("Id", (Object)parentId);
        catBuilder.addDataset(top);
        Path p = Paths.get(dataDirComplete, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            throw new FileNotFoundException("Directory does not exist =" + dataDirComplete);
        }
        if (!Files.isDirectory(p, new LinkOption[0])) {
            throw new FileNotFoundException("Not a directory =" + dataDirComplete);
        }
        List<MFile> mfiles = this.getSortedFiles(p, this.config.isSortIncreasing);
        if (this.config.addLatest != null && this.config.addLatest.latestOnTop) {
            top.addDataset(this.makeLatestProxy(top, parentId));
        }
        for (MFile mfile : mfiles) {
            DatasetBuilder ds;
            if (mfile.isDirectory()) {
                CatalogRefBuilder catref = new CatalogRefBuilder(top);
                catref.setTitle(this.makeName(mfile));
                catref.setHref(mfile.getName() + "/catalog.xml");
                top.addDataset((DatasetBuilder)catref);
                ds = catref;
            } else {
                ds = new DatasetBuilder(top);
                ds.setName(this.makeName(mfile));
                String urlPath = parentPath + mfile.getName();
                ds.put("UrlPath", (Object)urlPath);
                ds.put("DataSize", (Object)mfile.getLength());
                CalendarDate date = CalendarDate.of((long)mfile.getLastModified());
                ds.put("Dates", (Object)new DateType(date).setType("modified"));
                if (this.addTimeCoverage != null) {
                    this.addTimeCoverage.addMetadata(ds, mfile);
                }
                top.addDataset(ds);
            }
            ds.put("Id", (Object)(parentId + mfile.getName()));
        }
        if (this.config.addLatest != null && !this.config.addLatest.latestOnTop) {
            top.addDataset(this.makeLatestProxy(top, parentId));
        }
        return catBuilder.makeCatalog();
    }

    private String translatePathToLocation(String dsPath) {
        if (dsPath == null) {
            return null;
        }
        if (dsPath.length() == 0) {
            return null;
        }
        if (dsPath.startsWith("/")) {
            dsPath = dsPath.substring(1);
        }
        if (!dsPath.startsWith(this.config.path)) {
            return null;
        }
        String dataDir = dsPath.substring(this.config.path.length());
        if (dataDir.startsWith("/")) {
            dataDir = dataDir.substring(1);
        }
        if (!dataDir.endsWith("/")) {
            dataDir = dataDir + "/";
        }
        return dataDir;
    }

    private List<MFile> getSortedFiles(Path p, final boolean isSortIncreasing) throws IOException {
        ArrayList<MFile> mfiles = new ArrayList<MFile>();
        try (MFileIterator iter = new MFileIterator(p);){
            while (iter.hasNext()) {
                mfiles.add(iter.next());
            }
        }
        Collections.sort(mfiles, new Comparator<MFile>(){

            @Override
            public int compare(MFile o1, MFile o2) {
                if (o1.isDirectory() != o2.isDirectory()) {
                    return o1.isDirectory() ? 1 : -1;
                }
                if (isSortIncreasing) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
        });
        return mfiles;
    }

    private String makeName(MFile mfile) {
        if (this.namers == null) {
            return mfile.getName();
        }
        for (RegExpNamer namer : this.namers) {
            String result = namer.rename(mfile);
            if (result == null) continue;
            return result;
        }
        return mfile.getName();
    }

    private DatasetBuilder makeLatestProxy(DatasetBuilder parent, String parentId) {
        DatasetBuilder proxy = new DatasetBuilder(parent);
        proxy.setName(this.config.addLatest.latestName);
        proxy.put("UrlPath", (Object)this.config.addLatest.latestName);
        proxy.put("Id", (Object)(parentId + this.config.addLatest.latestName));
        proxy.put("ServiceName", (Object)this.config.addLatest.latestServiceName);
        return proxy;
    }

    public Catalog makeLatestResolvedCatalog(String orgPath, URI baseURI) throws IOException {
        String dataDirReletive = this.translatePathToLocation(orgPath);
        if (dataDirReletive == null) {
            String tmpMsg = "makeCatalogForDirectory(): Requesting path <" + orgPath + "> must start with \"" + this.config.path + "\".";
            log.error(tmpMsg);
            return null;
        }
        String parentPath = dataDirReletive.length() > 1 ? this.config.path + "/" + dataDirReletive : this.config.path + "/";
        String parentId = dataDirReletive.length() > 1 ? this.getId() + "/" + dataDirReletive : this.getId() + "/";
        String scanDir = ConfigCatalog.translateAlias(this.config.scanDir);
        String dataDirComplete = dataDirReletive.length() > 1 ? scanDir + "/" + dataDirReletive : scanDir;
        CatalogBuilder catBuilder = new CatalogBuilder();
        catBuilder.setBaseURI(baseURI);
        for (Service s : this.getParentCatalog().getServices()) {
            catBuilder.addService(s);
        }
        Path p = Paths.get(dataDirComplete, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            throw new FileNotFoundException("Directory does not exist =" + dataDirComplete);
        }
        if (!Files.isDirectory(p, new LinkOption[0])) {
            throw new FileNotFoundException("Not a directory =" + dataDirComplete);
        }
        List<MFile> mfiles = this.getSortedFiles(p, false);
        long now = System.currentTimeMillis();
        for (MFile mfile : mfiles) {
            if (mfile.isDirectory() || this.config.addLatest.lastModLimit > 0L && now - mfile.getLastModified() < this.config.addLatest.lastModLimit) continue;
            DatasetBuilder ds = new DatasetBuilder(null);
            ds.transferMetadata((Dataset)this, true);
            ds.setName(this.makeName(mfile));
            String urlPath = parentPath + mfile.getName();
            ds.put("UrlPath", (Object)urlPath);
            ds.put("DataSize", (Object)mfile.getLength());
            CalendarDate date = CalendarDate.of((long)mfile.getLastModified());
            ds.put("Dates", (Object)new DateType(date).setType("modified"));
            ds.put("Id", (Object)(parentId + mfile.getName()));
            if (this.addTimeCoverage != null) {
                this.addTimeCoverage.addMetadata(ds, mfile);
            }
            catBuilder.addDataset(ds);
            break;
        }
        return catBuilder.makeCatalog();
    }

    private static class AddTimeCoverageEnhancer {
        private DatasetScanConfig.AddTimeCoverage atc;
        private boolean matchOnName;
        private String matchPattern;
        private Pattern pattern;

        AddTimeCoverageEnhancer(DatasetScanConfig.AddTimeCoverage atc) {
            this.atc = atc;
            this.matchOnName = atc.matchName != null;
            this.matchPattern = atc.matchName != null ? atc.matchName : atc.matchPath;
            try {
                this.pattern = Pattern.compile(this.matchPattern);
            }
            catch (PatternSyntaxException e) {
                log.error("ctor(): bad match pattern <" + this.matchPattern + ">, failed to compile: " + e.getMessage());
                this.pattern = null;
            }
        }

        boolean addMetadata(DatasetBuilder dataset, MFile crDataset) {
            if (this.pattern == null) {
                return false;
            }
            String matchTargetString = this.matchOnName ? crDataset.getName() : crDataset.getPath();
            Matcher matcher = this.pattern.matcher(matchTargetString);
            if (!matcher.find()) {
                return false;
            }
            StringBuffer startTime = new StringBuffer();
            try {
                matcher.appendReplacement(startTime, this.atc.subst);
            }
            catch (IndexOutOfBoundsException e) {
                log.error("addMetadata(): capture group mismatch between match pattern <" + this.matchPattern + "> and substitution pattern <" + this.atc.subst + ">: " + e.getMessage());
                return false;
            }
            startTime.delete(0, matcher.start());
            try {
                DateRange dateRange = new DateRange(new DateType(startTime.toString(), null, null), null, new TimeDuration(this.atc.duration), null);
                dataset.put("TimeCoverage", (Object)dateRange);
            }
            catch (Exception e) {
                log.warn("addMetadata(): Start time <" + startTime.toString() + "> or duration <" + this.atc.duration + "> not parsable" + " (crDataset.getName() <" + crDataset.getName() + ">, this.matchPattern() <" + this.matchPattern + ">, this.substitutionPattern() <" + this.atc.subst + ">): " + e.getMessage());
                return false;
            }
            return true;
        }
    }

    private static class RegExpNamer {
        private Pattern pattern;
        DatasetScanConfig.Namer namer;

        RegExpNamer(DatasetScanConfig.Namer namer) {
            this.pattern = Pattern.compile(namer.regExp);
            this.namer = namer;
        }

        public String rename(MFile mfile) {
            String name = this.namer.onName ? mfile.getName() : mfile.getPath();
            Matcher matcher = this.pattern.matcher(name);
            if (!matcher.find()) {
                return null;
            }
            StringBuffer startTime = new StringBuffer();
            matcher.appendReplacement(startTime, this.namer.replaceString);
            startTime.delete(0, matcher.start());
            if (startTime.length() == 0) {
                return null;
            }
            return startTime.toString();
        }
    }

    private class MFileIterator
    implements CloseableIterator<MFile> {
        DirectoryStream<Path> dirStream;
        Iterator<Path> dirStreamIterator;
        MFile nextMFile;
        long now;

        MFileIterator(Path p) throws IOException {
            this.dirStream = Files.newDirectoryStream(p);
            this.dirStreamIterator = this.dirStream.iterator();
            this.now = System.currentTimeMillis();
        }

        /*
         * Exception decompiling
         */
        public boolean hasNext() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean accept(MFile mfile) {
            if (mfile.isDirectory()) {
                return DatasetScan.this.dirFilters == null || DatasetScan.this.dirFilters.accept(mfile);
            }
            return DatasetScan.this.fileFilters == null || DatasetScan.this.fileFilters.accept(mfile);
        }

        public MFile next() {
            if (this.nextMFile == null) {
                throw new NoSuchElementException();
            }
            return this.nextMFile;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() throws IOException {
            this.dirStream.close();
        }
    }
}

