/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.builder;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import thredds.client.catalog.Catalog;
import thredds.server.catalog.DatasetScanConfig;

public class DatasetScanConfigBuilder {
    Formatter errlog;
    boolean fatalError;

    DatasetScanConfigBuilder(Formatter errlog) {
        this.errlog = errlog;
    }

    protected DatasetScanConfig readDatasetScanConfig(Element dsElem) {
        Element addTimeCovElem;
        DatasetScanConfig result = new DatasetScanConfig();
        result.name = dsElem.getAttributeValue("name");
        result.path = dsElem.getAttributeValue("path");
        result.scanDir = dsElem.getAttributeValue("location");
        result.restrictAccess = dsElem.getAttributeValue("restrictAccess");
        Element ncmlElem = dsElem.getChild("netcdf", Catalog.defNS);
        if (ncmlElem != null) {
            ncmlElem.detach();
            result.ncmlElement = ncmlElem;
        }
        Element filterElem = dsElem.getChild("filter", Catalog.defNS);
        result.filters = this.readDatasetScanFilter(filterElem);
        Element namerElem = dsElem.getChild("namer", Catalog.defNS);
        result.namers = this.readDatasetScanNamer(namerElem);
        Element sorterElem = dsElem.getChild("sort", Catalog.defNS);
        result.isSortIncreasing = this.readDatasetScanSorter(sorterElem);
        String addLatestAttribute = dsElem.getAttributeValue("addLatest");
        Element addLatestElem = dsElem.getChild("addLatest", Catalog.defNS);
        Element addProxiesElem = dsElem.getChild("addProxies", Catalog.defNS);
        result.addLatest = this.readDatasetScanAddProxies(addProxiesElem, addLatestElem, addLatestAttribute);
        Element addDsSizeElem = dsElem.getChild("addDatasetSize", Catalog.defNS);
        if (addDsSizeElem != null && addDsSizeElem.getTextNormalize().equalsIgnoreCase("false")) {
            result.addDatasetSize = false;
        }
        if ((addTimeCovElem = dsElem.getChild("addTimeCoverage", Catalog.defNS)) != null) {
            result.addTimeCoverage = this.readDatasetScanAddTimeCoverage(addTimeCovElem);
        }
        return result;
    }

    private List<DatasetScanConfig.Filter> readDatasetScanFilter(Element filterElem) {
        ArrayList<DatasetScanConfig.Filter> filters = new ArrayList<DatasetScanConfig.Filter>();
        if (filterElem == null) {
            return null;
        }
        for (Element curElem : filterElem.getChildren()) {
            String regExpAttVal = curElem.getAttributeValue("regExp");
            String wildcardAttVal = curElem.getAttributeValue("wildcard");
            String lastModLimitAttValS = curElem.getAttributeValue("lastModLimitInMillis");
            if (regExpAttVal == null && wildcardAttVal == null && lastModLimitAttValS == null) {
                this.errlog.format("WARN: readDatasetScanFilter(): no regExp, wildcard, or lastModLimitInMillis attribute in filter child <%s>%n", curElem.getName());
                continue;
            }
            String atomicAttVal = curElem.getAttributeValue("atomic");
            boolean atomic = atomicAttVal == null || !atomicAttVal.equalsIgnoreCase("false");
            String collectionAttVal = curElem.getAttributeValue("collection");
            boolean notCollection = collectionAttVal == null || !collectionAttVal.equalsIgnoreCase("true");
            boolean includer = true;
            if (curElem.getName().equals("exclude")) {
                includer = false;
            } else if (!curElem.getName().equals("include")) {
                this.errlog.format("WARN: readDatasetScanFilter(): unhandled filter child <" + curElem.getName() + ">.", new Object[0]);
                continue;
            }
            long lastModLimitAttVal = -1L;
            if (lastModLimitAttValS != null) {
                try {
                    lastModLimitAttVal = Long.parseLong(lastModLimitAttValS);
                }
                catch (NumberFormatException e) {
                    this.errlog.format("WARN: readDatasetScanFilter(): lastModLimitInMillis not valid <" + curElem + ">.", new Object[0]);
                }
            }
            filters.add(new DatasetScanConfig.Filter(regExpAttVal, wildcardAttVal, lastModLimitAttVal, atomic, !notCollection, includer));
        }
        return filters;
    }

    protected List<DatasetScanConfig.Namer> readDatasetScanNamer(Element namerElem) {
        ArrayList<DatasetScanConfig.Namer> result = new ArrayList<DatasetScanConfig.Namer>();
        if (namerElem == null) {
            return result;
        }
        for (Element curElem : namerElem.getChildren()) {
            String regExp = curElem.getAttributeValue("regExp");
            String replaceString = curElem.getAttributeValue("replaceString");
            boolean onName = curElem.getName().equals("regExpOnName");
            boolean onPath = curElem.getName().equals("regExpOnPath");
            if (!onName && !onPath) {
                this.errlog.format("WARN: readDatasetScanNamer(): namer child '%s'%n", curElem.getName());
                continue;
            }
            result.add(new DatasetScanConfig.Namer(onName, regExp, replaceString));
        }
        return result;
    }

    protected boolean readDatasetScanSorter(Element sorterElem) {
        if (sorterElem == null) {
            return true;
        }
        Element lexSortElem = sorterElem.getChild("lexigraphicByName", Catalog.defNS);
        if (lexSortElem != null) {
            String increasingString = lexSortElem.getAttributeValue("increasing");
            boolean increasing = increasingString.equalsIgnoreCase("true");
            return increasing;
        }
        return true;
    }

    protected DatasetScanConfig.AddLatest readDatasetScanAddProxies(Element addProxiesElem, Element addLatestElem, String addLatestAttribute) {
        if (addLatestAttribute != null && addLatestAttribute.equalsIgnoreCase("true")) {
            return new DatasetScanConfig.AddLatest();
        }
        if (addLatestElem != null) {
            Element simpleLatestElem = addLatestElem.getChild("simpleLatest", Catalog.defNS);
            if (simpleLatestElem == null) {
                return new DatasetScanConfig.AddLatest();
            }
            return this.readDatasetScanAddLatest(simpleLatestElem);
        }
        if (addProxiesElem != null) {
            for (Element curChildElem : addProxiesElem.getChildren()) {
                String serviceName;
                if (curChildElem.getName().equals("simpleLatest")) {
                    return this.readDatasetScanAddLatest(curChildElem);
                }
                if (!curChildElem.getName().equals("latestComplete")) continue;
                String latestName = curChildElem.getAttributeValue("name");
                if (latestName == null) {
                    this.errlog.format("WARN: readDatasetScanAddProxies(): unnamed latestComplete, skipping.", new Object[0]);
                    continue;
                }
                Attribute topAtt = curChildElem.getAttribute("top");
                boolean latestOnTop = true;
                if (topAtt != null) {
                    try {
                        latestOnTop = topAtt.getBooleanValue();
                    }
                    catch (DataConversionException e) {
                        latestOnTop = true;
                    }
                }
                if ((serviceName = curChildElem.getAttributeValue("serviceName")) == null) {
                    this.errlog.format("WARN: readDatasetScanAddProxies(): no service name given in latestComplete.", new Object[0]);
                    continue;
                }
                String lastModLimitVal = curChildElem.getAttributeValue("lastModifiedLimit");
                long lastModLimit = lastModLimitVal == null ? 60L : Long.parseLong(lastModLimitVal);
                String isResolverString = curChildElem.getAttributeValue("isResolver");
                boolean isResolver = true;
                if (isResolverString != null && isResolverString.equalsIgnoreCase("false")) {
                    isResolver = false;
                }
                return new DatasetScanConfig.AddLatest(latestName, serviceName, latestOnTop, isResolver, lastModLimit);
            }
        }
        return null;
    }

    private DatasetScanConfig.AddLatest readDatasetScanAddLatest(Element simpleLatestElem) {
        String latestName = "latest.xml";
        boolean latestOnTop = true;
        String latestServiceName = "latest";
        boolean isResolver = true;
        if (simpleLatestElem != null) {
            String isResolverString;
            String tmpLatestServiceName;
            Attribute topAtt;
            String tmpLatestName = simpleLatestElem.getAttributeValue("name");
            if (tmpLatestName != null) {
                latestName = tmpLatestName;
            }
            if ((topAtt = simpleLatestElem.getAttribute("top")) != null) {
                try {
                    latestOnTop = topAtt.getBooleanValue();
                }
                catch (DataConversionException e) {
                    latestOnTop = true;
                }
            }
            if ((tmpLatestServiceName = simpleLatestElem.getAttributeValue("serviceName")) != null) {
                latestServiceName = tmpLatestServiceName;
            }
            if ((isResolverString = simpleLatestElem.getAttributeValue("isResolver")) != null && isResolverString.equalsIgnoreCase("false")) {
                isResolver = false;
            }
        }
        return new DatasetScanConfig.AddLatest(latestName, latestServiceName, latestOnTop, isResolver, -1L);
    }

    protected DatasetScanConfig.AddTimeCoverage readDatasetScanAddTimeCoverage(Element addTimeCovElem) {
        String matchName = addTimeCovElem.getAttributeValue("datasetNameMatchPattern");
        String matchPath = addTimeCovElem.getAttributeValue("datasetPathMatchPattern");
        String subst = addTimeCovElem.getAttributeValue("startTimeSubstitutionPattern");
        String duration = addTimeCovElem.getAttributeValue("duration");
        boolean err = false;
        if (subst == null) {
            this.errlog.format("WARN: readDatasetScanAddTimeCoverage(): must have startTimeSubstitutionPattern elem=<%s>%n", addTimeCovElem);
            err = true;
        } else if (duration == null) {
            this.errlog.format("WARN: readDatasetScanAddTimeCoverage(): must have duration elem=<%s>%n", addTimeCovElem);
            err = true;
        } else if (matchName == null && matchPath == null) {
            this.errlog.format("WARN: readDatasetScanAddTimeCoverage(): must have either datasetNameMatchPattern or datasetPathMatchPattern elem=<%s>%n", addTimeCovElem);
            err = true;
        }
        return err ? null : new DatasetScanConfig.AddTimeCoverage(matchName, matchPath, subst, duration);
    }
}

