/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.inventory.MFile;

public class DatasetScanFilter {
    private final List<Selector> selectorGroup;
    private final boolean containsAtomicIncluders;
    private final boolean containsAtomicExcluders;
    private final boolean containsCollectionIncluders;
    private final boolean containsCollectionExcluders;

    public DatasetScanFilter() {
        this.selectorGroup = Collections.emptyList();
        this.containsAtomicIncluders = false;
        this.containsAtomicExcluders = false;
        this.containsCollectionIncluders = false;
        this.containsCollectionExcluders = false;
    }

    public DatasetScanFilter(List<Selector> selectorGroup) {
        if (selectorGroup == null || selectorGroup.isEmpty()) {
            this.selectorGroup = Collections.emptyList();
            this.containsAtomicIncluders = false;
            this.containsAtomicExcluders = false;
            this.containsCollectionIncluders = false;
            this.containsCollectionExcluders = false;
        } else {
            boolean anyAtomicIncluders = false;
            boolean anyAtomicExcluders = false;
            boolean anyCollectionIncluders = false;
            boolean anyCollectionExcluders = false;
            ArrayList<Selector> tmpSelectorGroup = new ArrayList<Selector>();
            for (Selector curSelector : selectorGroup) {
                if (curSelector.isIncluder()) {
                    if (curSelector.isApplyToAtomicDataset()) {
                        anyAtomicIncluders = true;
                    }
                    if (curSelector.isApplyToCollectionDataset()) {
                        anyCollectionIncluders = true;
                    }
                } else {
                    if (curSelector.isApplyToAtomicDataset()) {
                        anyAtomicExcluders = true;
                    }
                    if (curSelector.isApplyToCollectionDataset()) {
                        anyCollectionExcluders = true;
                    }
                }
                tmpSelectorGroup.add(curSelector);
            }
            this.selectorGroup = tmpSelectorGroup;
            this.containsAtomicIncluders = anyAtomicIncluders;
            this.containsAtomicExcluders = anyAtomicExcluders;
            this.containsCollectionIncluders = anyCollectionIncluders;
            this.containsCollectionExcluders = anyCollectionExcluders;
        }
    }

    public DatasetScanFilter(Selector selector) {
        if (selector == null) {
            this.selectorGroup = Collections.emptyList();
            this.containsAtomicIncluders = false;
            this.containsAtomicExcluders = false;
            this.containsCollectionIncluders = false;
            this.containsCollectionExcluders = false;
        } else {
            boolean anyAtomicIncluders = false;
            boolean anyAtomicExcluders = false;
            boolean anyCollectionIncluders = false;
            boolean anyCollectionExcluders = false;
            if (selector.isIncluder()) {
                if (selector.isApplyToAtomicDataset()) {
                    anyAtomicIncluders = true;
                }
                if (selector.isApplyToCollectionDataset()) {
                    anyCollectionIncluders = true;
                }
            } else {
                if (selector.isApplyToAtomicDataset()) {
                    anyAtomicExcluders = true;
                }
                if (selector.isApplyToCollectionDataset()) {
                    anyCollectionExcluders = true;
                }
            }
            this.selectorGroup = Collections.singletonList(selector);
            this.containsAtomicIncluders = anyAtomicIncluders;
            this.containsAtomicExcluders = anyAtomicExcluders;
            this.containsCollectionIncluders = anyCollectionIncluders;
            this.containsCollectionExcluders = anyCollectionExcluders;
        }
    }

    public Object getConfigObject() {
        return this.selectorGroup;
    }

    public boolean accept(MFile dataset) {
        if (dataset == null) {
            return false;
        }
        if (this.selectorGroup.isEmpty()) {
            return true;
        }
        if (dataset.isDirectory() ? !this.containsCollectionIncluders && !this.containsCollectionExcluders : !this.containsAtomicIncluders && !this.containsAtomicExcluders) {
            return true;
        }
        boolean include = false;
        boolean exclude = false;
        for (Selector curSelector : this.selectorGroup) {
            if (!curSelector.isApplicable(dataset) || !curSelector.match(dataset)) continue;
            if (curSelector.isIncluder()) {
                include = true;
                continue;
            }
            exclude = true;
        }
        if (!dataset.isDirectory()) {
            if (this.containsAtomicIncluders && !this.containsAtomicExcluders) {
                return include;
            }
            if (this.containsAtomicExcluders && !this.containsAtomicIncluders) {
                return !exclude;
            }
            if (this.containsAtomicIncluders && this.containsAtomicExcluders && include) {
                return !exclude;
            }
        } else {
            if (this.containsCollectionIncluders && !this.containsCollectionExcluders) {
                return include;
            }
            if (this.containsCollectionExcluders && !this.containsCollectionIncluders) {
                return !exclude;
            }
            if (this.containsCollectionIncluders && this.containsCollectionExcluders && include) {
                return !exclude;
            }
        }
        return false;
    }

    public static class Selector {
        private final boolean includer;
        private final boolean applyToAtomicDataset;
        private final boolean applyToCollectionDataset;
        private final DatasetScanFilter filter;

        public Selector(DatasetScanFilter filter, boolean includer, boolean applyToAtomicDataset, boolean applyToCollectionDataset) {
            this.filter = filter;
            this.includer = includer;
            this.applyToAtomicDataset = applyToAtomicDataset;
            this.applyToCollectionDataset = applyToCollectionDataset;
        }

        public DatasetScanFilter getFilter() {
            return this.filter;
        }

        public boolean isApplyToAtomicDataset() {
            return this.applyToAtomicDataset;
        }

        public boolean isApplyToCollectionDataset() {
            return this.applyToCollectionDataset;
        }

        public boolean match(MFile dataset) {
            return this.filter.accept(dataset);
        }

        public boolean isApplicable(MFile dataset) {
            if (this.applyToAtomicDataset && !dataset.isDirectory()) {
                return true;
            }
            return this.applyToCollectionDataset && dataset.isDirectory();
        }

        public boolean isIncluder() {
            return this.includer;
        }

        public boolean isExcluder() {
            return !this.includer;
        }

        public class LastModifiedLimitFilter {
            private long lastModifiedLimitInMillis;

            public LastModifiedLimitFilter(long lastModifiedLimitInMillis) {
                this.lastModifiedLimitInMillis = lastModifiedLimitInMillis;
            }

            public boolean accept(MFile dataset) {
                long now;
                long lastModDate = dataset.getLastModified();
                return lastModDate > 0L && (now = System.currentTimeMillis()) - lastModDate > this.lastModifiedLimitInMillis;
            }
        }

        public class WildcardMatchOnNameFilter {
            protected String wildcardString;
            protected Pattern pattern;

            public WildcardMatchOnNameFilter(String wildcardString) {
                this.wildcardString = wildcardString;
                String regExp = this.mapWildcardToRegExp(wildcardString);
                this.pattern = Pattern.compile(regExp);
            }

            private String mapWildcardToRegExp(String wildcardString) {
                wildcardString = wildcardString.replaceAll("\\.", "\\\\.");
                wildcardString = wildcardString.replaceAll("\\*", ".*");
                wildcardString = wildcardString.replaceAll("\\?", ".?");
                return wildcardString;
            }

            public boolean accept(MFile dataset) {
                Matcher matcher = this.pattern.matcher(dataset.getName());
                return matcher.matches();
            }
        }

        public class RegExpMatchOnNameFilter {
            private String regExpString;
            protected Pattern pattern;

            public RegExpMatchOnNameFilter(String regExpString) {
                this.regExpString = regExpString;
                this.pattern = Pattern.compile(regExpString);
            }

            public boolean accept(MFile mfile) {
                Matcher matcher = this.pattern.matcher(mfile.getName());
                return matcher.matches();
            }
        }
    }
}

