/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.xml.RuntimeConfigParser;

public class ThreddsConfigReader {
    private Logger log;
    private Element rootElem;

    public ThreddsConfigReader(String filename, Logger log) {
        Document doc;
        this.log = log;
        File file = new File(filename);
        if (!file.exists()) {
            return;
        }
        log.info("ThreddsConfigReader reading xml file = " + filename);
        try {
            FileInputStream is = new FileInputStream(filename);
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            doc = builder.build((InputStream)is);
        }
        catch (IOException | JDOMException e) {
            log.error("ThreddsConfigReader: incorrectly formed xml file [" + filename + "]: " + e.getMessage());
            return;
        }
        this.rootElem = doc.getRootElement();
        Element elem = this.rootElem.getChild("nj22Config");
        if (elem != null) {
            StringBuilder errlog = new StringBuilder();
            RuntimeConfigParser.read((Element)elem, (StringBuilder)errlog);
            if (errlog.length() > 0) {
                log.warn("ThreddsConfigReader nj22Config: {}", (Object)errlog.toString());
            }
        }
    }

    public List<String> getRootList(String elementName) {
        ArrayList<String> result = new ArrayList<String>();
        List rootList = this.rootElem.getChildren(elementName);
        for (Element elem : rootList) {
            String location = StringUtils.cleanPath((String)elem.getTextNormalize());
            if (location.length() <= 0) continue;
            result.add(location);
        }
        return result;
    }

    public List<String> getElementList(String elementName, String subElementName) {
        ArrayList<String> result = new ArrayList<String>();
        Element elem = this.rootElem.getChild(elementName);
        if (elem == null) {
            return result;
        }
        List rootList = elem.getChildren(subElementName);
        for (Element elem2 : rootList) {
            String location = StringUtils.cleanPath((String)elem2.getTextNormalize());
            if (location.length() <= 0) continue;
            result.add(location);
        }
        return result;
    }

    public String get(String paramName, String defValue) {
        String s = this.getParam(paramName);
        return s == null ? defValue : s;
    }

    public boolean hasElement(String paramName) {
        Element elem = this.rootElem;
        if (elem == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(paramName, ".");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (null != (elem = elem.getChild(toke))) continue;
            return false;
        }
        return true;
    }

    public boolean getBoolean(String paramName, boolean defValue) {
        String s = this.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            this.log.error("ThreddsConfig: param " + paramName + " not a boolean: " + e.getMessage());
            return defValue;
        }
    }

    public long getBytes(String paramName, long defValue) {
        String s = this.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        String num = s;
        try {
            long factor = 1L;
            int pos = s.indexOf(32);
            if (pos > 0) {
                num = s.substring(0, pos);
                String units = s.substring(pos + 1).trim();
                char c = Character.toUpperCase(units.charAt(0));
                if (c == 'K') {
                    factor = 1000L;
                } else if (c == 'M') {
                    factor = 1000000L;
                } else if (c == 'G') {
                    factor = 1000000000L;
                } else if (c == 'T') {
                    factor = 1000000000000L;
                } else if (c == 'P') {
                    factor = 1000000000000000L;
                }
            }
            return factor * Long.parseLong(num);
        }
        catch (Exception e) {
            this.log.error("ThreddsConfig: param " + paramName + " not a byte count: " + s + " " + e.getMessage());
            return defValue;
        }
    }

    public int getInt(String paramName, int defValue) {
        String s = this.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            this.log.error("ThreddsConfig: param " + paramName + " not an integer " + e.getMessage());
            return defValue;
        }
    }

    public long getLong(String paramName, long defValue) {
        String s = this.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            this.log.error("ThreddsConfig: param " + paramName + " not a long " + e.getMessage());
            return defValue;
        }
    }

    public int getSeconds(String paramName, int defValue) {
        String s = this.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            TimeDuration tu = new TimeDuration(s);
            return (int)tu.getValueInSeconds();
        }
        catch (Exception e) {
            this.log.error("ThreddsConfig: param " + paramName + " not udunit time " + e.getMessage());
            return defValue;
        }
    }

    private String getParam(String name) {
        Element elem = this.rootElem;
        if (elem == null) {
            return null;
        }
        StringTokenizer stoke = new StringTokenizer(name, ".");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (null != (elem = elem.getChild(toke))) continue;
            return null;
        }
        String text = elem.getText();
        return text == null ? null : text.trim();
    }
}

