/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionConfigBuilder;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.DatasetRootConfig;
import thredds.server.catalog.DatasetScanConfig;
import thredds.server.catalog.builder.CatalogScanBuilder;
import thredds.server.catalog.builder.DatasetScanBuilder;
import thredds.server.catalog.builder.DatasetScanConfigBuilder;
import thredds.server.catalog.builder.FeatureCollectionRefBuilder;

public class ConfigCatalogBuilder
extends CatalogBuilder {
    protected List<DatasetRootConfig> roots;

    protected DatasetBuilder buildOtherDataset(DatasetBuilder parent, Element elem) {
        if (elem.getName().equals("datasetRoot")) {
            DatasetRootConfig root = this.readDatasetRoot(elem);
            if (this.roots == null) {
                this.roots = new ArrayList<DatasetRootConfig>();
            }
            this.roots.add(root);
            return null;
        }
        if (elem.getName().equals("catalogScan")) {
            return this.readCatalogScan(parent, elem);
        }
        if (elem.getName().equals("datasetScan")) {
            return this.readDatasetScan(parent, elem);
        }
        if (elem.getName().equals("featureCollection")) {
            return this.readFeatureCollection(parent, elem);
        }
        if (elem.getName().equals("netcdf") && elem.getNamespace().equals((Object)Catalog.ncmlNS)) {
            if (parent != null) {
                parent.put("Ncml", (Object)elem.detach());
            }
            return null;
        }
        return null;
    }

    private DatasetRootConfig readDatasetRoot(Element s) {
        String name = s.getAttributeValue("path");
        String value = s.getAttributeValue("location");
        return new DatasetRootConfig(name, value);
    }

    private CatalogScanBuilder readCatalogScan(DatasetBuilder parent, Element s) {
        String name = s.getAttributeValue("name");
        String path = s.getAttributeValue("path");
        String location = s.getAttributeValue("location");
        String watch = s.getAttributeValue("watch");
        return new CatalogScanBuilder(parent, name, path, location, watch);
    }

    protected DatasetBuilder readCatalogRef(DatasetBuilder parent, Element catRefElem) {
        DatasetBuilder catref = super.readCatalogRef(parent, catRefElem);
        String useRemoteCatalogService = catRefElem.getAttributeValue("useRemoteCatalogService");
        if (useRemoteCatalogService != null) {
            if (useRemoteCatalogService.equalsIgnoreCase("true")) {
                catref.put("UseRemoteCatalogService", (Object)Boolean.TRUE);
            } else if (useRemoteCatalogService.equalsIgnoreCase("false")) {
                catref.put("UseRemoteCatalogService", (Object)Boolean.FALSE);
            }
        }
        return catref;
    }

    private DatasetBuilder readDatasetScan(DatasetBuilder parent, Element dsElem) {
        DatasetScanConfigBuilder configBuilder = new DatasetScanConfigBuilder(this.errlog);
        DatasetScanConfig config = configBuilder.readDatasetScanConfig(dsElem);
        if (configBuilder.fatalError) {
            return null;
        }
        DatasetScanBuilder dataset = new DatasetScanBuilder(parent, config);
        this.readDatasetInfo(dataset, dsElem);
        for (Element elem : dsElem.getChildren("netcdf", Catalog.ncmlNS)) {
            dataset.put("Ncml", elem.detach());
        }
        return dataset;
    }

    private DatasetBuilder readFeatureCollection(DatasetBuilder parent, Element fcElem) {
        FeatureCollectionConfigBuilder configBuilder = new FeatureCollectionConfigBuilder(this.errlog);
        FeatureCollectionConfig config = configBuilder.readConfig(fcElem);
        if (configBuilder.fatalError) {
            return null;
        }
        FeatureCollectionRefBuilder dataset = new FeatureCollectionRefBuilder(parent, config);
        this.readDatasetInfo(dataset, fcElem);
        for (Element elem : fcElem.getChildren("netcdf", Catalog.ncmlNS)) {
            dataset.put("Ncml", elem.detach());
        }
        return dataset;
    }

    public ConfigCatalog makeCatalog() {
        Map flds = this.setFields();
        if (this.roots != null) {
            flds.put("DatasetRoots", this.roots);
        }
        return new ConfigCatalog(this.baseURI, this.name, flds, this.datasetBuilders);
    }
}

