/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import thredds.server.catalog.tracker.ConfigCatalogExtProto;

public class CatalogExt {
    public static int total_count = 0;
    public static long total_nbytes = 0L;
    private boolean isRoot;
    private long catId;
    private String catRelLocation;
    private long lastRead;

    public CatalogExt() {
    }

    public CatalogExt(long catId, String catRelLocation, boolean isRoot, long lastRead) {
        this.isRoot = isRoot;
        this.catId = catId;
        this.catRelLocation = catRelLocation;
        this.lastRead = lastRead;
    }

    public String getCatRelLocation() {
        return this.catRelLocation;
    }

    public long getCatId() {
        return this.catId;
    }

    public boolean setCatId(long catId) {
        if (this.catId == 0L) {
            this.catId = catId;
        }
        return this.catId == catId;
    }

    public long getLastRead() {
        return this.lastRead;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void writeExternal(DataOutputStream out) throws IOException {
        ConfigCatalogExtProto.Catalog.Builder builder = ConfigCatalogExtProto.Catalog.newBuilder();
        builder.setCatId(this.catId);
        builder.setCatLocation(this.catRelLocation);
        builder.setIsRoot(this.isRoot);
        builder.setLastRead(this.lastRead);
        ConfigCatalogExtProto.Catalog index = builder.build();
        byte[] b = index.toByteArray();
        out.writeInt(b.length);
        out.write(b);
        ++total_count;
        total_nbytes += (long)(b.length + 4);
    }

    public void readExternal(DataInputStream in) throws IOException {
        int avail = in.available();
        int len = in.readInt();
        byte[] b = new byte[len];
        int n = in.read(b);
        if (n != len) {
            throw new RuntimeException("barf with read size=" + len + " in.available=" + avail);
        }
        ConfigCatalogExtProto.Catalog catp = ConfigCatalogExtProto.Catalog.parseFrom(b);
        this.catId = catp.getCatId();
        this.catRelLocation = catp.getCatLocation();
        this.isRoot = catp.getIsRoot();
        this.lastRead = catp.getLastRead();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogExt that = (CatalogExt)o;
        return this.catRelLocation.equals(that.catRelLocation);
    }

    public int hashCode() {
        return this.catRelLocation.hashCode();
    }
}

