/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.ConfigCatalogCache;
import thredds.server.catalog.DataRoot;
import thredds.server.catalog.DatasetRootConfig;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.tracker.DataRootExt;
import thredds.server.catalog.tracker.DataRootTracker;
import ucar.nc2.util.AliasTranslator;
import ucar.unidata.util.StringUtil2;

public class DataRootPathMatcher {
    private static final Logger logger = LoggerFactory.getLogger(DataRootPathMatcher.class);
    private static Logger logCatalogInit = LoggerFactory.getLogger((String)"catalogInit");
    private static final boolean debug = false;
    private static final String ERROR = "*** ERROR: ";
    private static boolean skipTestDataDir = true;
    private ConfigCatalogCache ccc;
    private DataRootTracker tracker;
    private final TreeSet<String> treeSet = new TreeSet<String>(new PathComparator());
    private final Map<String, DataRootExt> map = new HashMap<String, DataRootExt>();

    public DataRootPathMatcher(ConfigCatalogCache ccc, DataRootTracker tracker) {
        this.ccc = ccc;
        this.tracker = tracker;
        for (DataRootExt dataRootExt : tracker.getDataRoots()) {
            this.put(dataRootExt);
        }
    }

    private boolean put(DataRootExt dateRootExt) {
        this.map.put(dateRootExt.getPath(), dateRootExt);
        return this.treeSet.add(dateRootExt.getPath());
    }

    public boolean contains(String path) {
        return this.treeSet.contains(path);
    }

    public DataRootExt get(String path) {
        return this.map.get(path);
    }

    public Set<Map.Entry<String, DataRootExt>> getValues() {
        return this.map.entrySet();
    }

    public String findLongestPathMatch(String reqPath) {
        SortedSet<String> tail = this.treeSet.tailSet(reqPath);
        if (tail.isEmpty()) {
            return null;
        }
        String after = tail.first();
        if (reqPath.startsWith(after)) {
            return tail.first();
        }
        for (String key : tail) {
            if (reqPath.startsWith(key)) {
                return key;
            }
            if (StringUtil2.match((String)reqPath, (String)key) != 0) continue;
            break;
        }
        return null;
    }

    public DataRoot findDataRoot(String reqPath) {
        String path = this.findLongestPathMatch(reqPath);
        if (path == null) {
            return null;
        }
        DataRootExt dataRootExt = this.map.get(path);
        if (dataRootExt == null) {
            logger.error("DataRootPathMatcher found path {} but not in map", (Object)path);
            return null;
        }
        return this.convert2DataRoot(dataRootExt);
    }

    @Nonnull
    public DataRoot convert2DataRoot(DataRootExt dataRootExt) {
        DataRoot dataRoot = dataRootExt.getDataRoot();
        if (dataRoot != null) {
            return dataRoot;
        }
        dataRoot = this.readDataRootFromCatalog(dataRootExt);
        dataRootExt.setDataRoot(dataRoot);
        return dataRoot;
    }

    @Nonnull
    private DataRoot readDataRootFromCatalog(DataRootExt dataRootExt) {
        try {
            ConfigCatalog cat = this.ccc.get(dataRootExt.getCatLocation());
            this.extractDataRoots(dataRootExt.getCatLocation(), cat.getDatasetsLocal(), false, null);
            DataRootExt dataRootExtNew = this.map.get(dataRootExt.getPath());
            if (null == dataRootExtNew) {
                logger.error("Reading catalog " + dataRootExt.getCatLocation() + " failed to find dataRoot path=" + dataRootExt.getPath());
                throw new IllegalStateException("Reading catalog " + dataRootExt.getCatLocation() + " failed to find dataRoot path=" + dataRootExt.getPath());
            }
            return dataRootExtNew.getDataRoot();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error Reading catalog " + dataRootExt.getCatLocation(), e);
        }
    }

    public void extractDataRoots(String catalogRelPath, List<Dataset> dsList, boolean checkDups, Map<String, String> idMap) {
        for (Dataset dataset : dsList) {
            if (dataset instanceof DatasetScan) {
                DatasetScan ds = (DatasetScan)dataset;
                this.addRoot(ds, catalogRelPath, checkDups);
            } else if (dataset instanceof FeatureCollectionRef) {
                FeatureCollectionRef fc = (FeatureCollectionRef)dataset;
                this.addRoot(fc, catalogRelPath, checkDups);
                if (idMap != null) {
                    String catWithSameFc = idMap.get(fc.getCollectionName());
                    if (catWithSameFc != null) {
                        logCatalogInit.warn("*** ERROR: Duplicate featureCollection name {} in catalogs '{}' and '{}'", new Object[]{fc.getCollectionName(), catalogRelPath, catWithSameFc});
                    } else {
                        idMap.put(fc.getCollectionName(), catalogRelPath);
                    }
                }
            } else if (dataset instanceof CatalogScan) {
                CatalogScan catScan = (CatalogScan)dataset;
                this.addRoot(catScan, catalogRelPath, checkDups);
            }
            if (dataset instanceof CatalogRef) continue;
            this.extractDataRoots(catalogRelPath, dataset.getDatasetsLocal(), checkDups, idMap);
        }
    }

    private boolean addRoot(DatasetScan dscan, String catalogRelPath, boolean checkDups) {
        DataRootExt dre;
        String path = dscan.getPath();
        if (path == null) {
            logCatalogInit.error("*** ERROR: DatasetScan '" + dscan.getName() + "' missing the path attribute.");
            return false;
        }
        if (checkDups && (dre = this.get(path)) != null) {
            logCatalogInit.error("*** ERROR: DatasetScan trying to add duplicate dataRoot =<" + path + ">  already mapped to directory= <" + dre.getDirLocation() + "> wanted to map to =<" + dscan.getScanLocation() + "> in catalog " + catalogRelPath);
            return false;
        }
        File file = new File(dscan.getScanLocation());
        if (!skipTestDataDir && !file.exists()) {
            logCatalogInit.error("*** ERROR: DatasetScan path ='" + path + "' directory= <" + dscan.getScanLocation() + "> does not exist");
            return false;
        }
        this.putRoot(new DataRoot(dscan), catalogRelPath);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for directory= <" + dscan.getScanLocation() + ">");
        return true;
    }

    private boolean addRoot(FeatureCollectionRef fc, String catalogRelPath, boolean checkDups) {
        DataRootExt dre;
        String path = fc.getPath();
        if (path == null) {
            logCatalogInit.error("*** ERROR: DatasetScan '" + fc.getName() + "' missing the path attribute.");
            return false;
        }
        if (checkDups && (dre = this.get(path)) != null) {
            logCatalogInit.error("*** ERROR: FeatureCollection trying to add duplicate dataRoot =<" + path + ">  already mapped to directory= <" + dre.getDirLocation() + "> wanted to map to =<" + fc.getTopDirectoryLocation() + "> in catalog " + catalogRelPath);
            return false;
        }
        File file = new File(fc.getTopDirectoryLocation());
        if (!skipTestDataDir && !file.exists()) {
            logCatalogInit.error("*** ERROR: FeatureCollection path ='" + path + "' directory= <" + fc.getTopDirectoryLocation() + "> does not exist");
            return false;
        }
        this.putRoot(new DataRoot(fc), catalogRelPath);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for feature collection= <" + fc.getName() + ">");
        return true;
    }

    public boolean addRoot(DatasetRootConfig config, String catalogRelPath, boolean checkDups) {
        DataRootExt dre;
        String path = config.getPath();
        if (path == null) {
            logCatalogInit.error("*** ERROR: DatasetRoot '" + config + "' missing the path attribute.");
            return false;
        }
        if (checkDups && (dre = this.get(path)) != null) {
            logCatalogInit.error("*** ERROR: DatasetRoot trying to add duplicate dataRoot =<" + path + ">  already mapped to directory= <" + dre.getDirLocation() + "> wanted to map to =<" + config.getLocation() + "> in catalog " + catalogRelPath);
            return false;
        }
        String location = AliasTranslator.translateAlias((String)config.getLocation());
        File file = new File(location);
        if (!skipTestDataDir && !file.exists()) {
            logCatalogInit.error("*** ERROR: DatasetRootConfig path ='" + path + "' directory= <" + location + "> does not exist");
            return false;
        }
        this.putRoot(new DataRoot(config.getPath(), location, null), catalogRelPath);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for DatasetRootConfig location= <" + location + ">");
        return true;
    }

    private boolean addRoot(CatalogScan catScan, String catalogRelPath, boolean checkDups) {
        DataRootExt dre;
        String path = catScan.getPath();
        if (path == null) {
            logCatalogInit.error("*** ERROR: CatalogScan '" + (Object)((Object)catScan) + "' missing the path attribute.");
            return false;
        }
        if (checkDups && (dre = this.get(path)) != null) {
            logCatalogInit.error("*** ERROR: CatalogScan trying to add duplicate dataRoot =<" + path + ">  already mapped to directory= <" + dre.getDirLocation() + "> wanted to map to =<" + catScan.getLocation() + "> in catalog " + catalogRelPath);
            return false;
        }
        String location = AliasTranslator.translateAlias((String)catScan.getLocation());
        File file = new File(location);
        if (!skipTestDataDir && !file.exists()) {
            logCatalogInit.error("*** ERROR: CatalogScan path ='" + path + "' directory= <" + location + "> does not exist");
            return false;
        }
        this.putRoot(new DataRoot(catScan), catalogRelPath);
        logCatalogInit.debug(" added rootPath=<" + path + ">  for CatalogScan location= <" + location + ">");
        return true;
    }

    private void putRoot(DataRoot droot, String catalogRelPath) {
        DataRootExt drootExt = new DataRootExt(droot, catalogRelPath);
        this.put(drootExt);
        this.tracker.trackDataRoot(drootExt);
    }

    private static class PathComparator
    implements Comparator<String> {
        private PathComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int compare = s2.compareTo(s1);
            return compare;
        }
    }
}

