/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.util.List;
import java.util.Optional;
import org.jdom2.Element;

public class DatasetScanConfig {
    public String name;
    public String path;
    public String scanDir;
    public String restrictAccess;
    public Optional<Boolean> isSortIncreasing = Optional.empty();
    public Element ncmlElement;
    public List<Filter> filters;
    public List<Namer> namers;
    public AddLatest addLatest;
    public AddTimeCoverage addTimeCoverage;

    public String toString() {
        return "DatasetScanConfig{name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", scanDir='" + this.scanDir + '\'' + ", restrictAccess='" + this.restrictAccess + '\'' + ", isSortIncreasing=" + this.getSortFilesAscending() + ", ncmlElement=" + this.ncmlElement + ", filters=" + this.filters + ", namers=" + this.namers + ", proxies=" + this.addLatest + ", addTimeCoverage=" + this.addTimeCoverage + '}';
    }

    public boolean getSortFilesAscending() {
        if (this.isSortIncreasing.isPresent()) {
            return this.isSortIncreasing.get();
        }
        return true;
    }

    public static class AddTimeCoverage {
        String matchName;
        String matchPath;
        String subst;
        String duration;

        public AddTimeCoverage(String matchName, String matchPath, String subst, String duration) {
            this.matchName = matchName;
            this.matchPath = matchPath;
            this.subst = subst;
            this.duration = duration;
        }
    }

    public static class AddLatest {
        String latestName;
        String serviceName;
        boolean latestOnTop;
        long lastModLimit;

        public AddLatest() {
            this.latestName = "latest.xml";
            this.serviceName = "Resolver";
            this.latestOnTop = true;
            this.lastModLimit = -1L;
        }

        public AddLatest(String latestName, String serviceName, boolean latestOnTop, long lastModLimit) {
            this.latestName = latestName;
            this.serviceName = serviceName;
            this.latestOnTop = latestOnTop;
            this.lastModLimit = lastModLimit;
        }
    }

    public static class Namer {
        boolean onName;
        String regExp;
        String replaceString;

        public Namer(boolean onName, String regExp, String replaceString) {
            this.onName = onName;
            this.regExp = regExp;
            this.replaceString = replaceString;
        }
    }

    public static class Filter {
        String regExpAttVal;
        String wildcardAttVal;
        long lastModLimitAttVal;
        boolean atomic;
        boolean collection;
        boolean includer;

        public Filter(String regExpAttVal, String wildcardAttVal, long lastModLimitAttVal, boolean atomic, boolean collection, boolean includer) {
            this.regExpAttVal = regExpAttVal;
            this.wildcardAttVal = wildcardAttVal;
            this.lastModLimitAttVal = lastModLimitAttVal;
            this.atomic = atomic;
            this.collection = collection;
            this.includer = includer;
        }
    }
}

