/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import javax.annotation.concurrent.Immutable;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;

@Immutable
public class DataRoot {
    private static final boolean show = false;
    private final String path;
    private final String dirLocation;
    private final String name;
    private final DatasetScan datasetScan;
    private final FeatureCollectionRef featCollection;
    private final CatalogScan catScan;
    private final Type type;
    private final String restrict;

    public DataRoot(FeatureCollectionRef featCollection) {
        this.path = featCollection.getPath();
        this.dirLocation = featCollection.getTopDirectoryLocation();
        this.datasetScan = null;
        this.catScan = null;
        this.featCollection = featCollection;
        this.type = Type.featureCollection;
        this.name = featCollection.getCollectionName();
        this.restrict = featCollection.getRestrictAccess();
        this.show();
    }

    public DataRoot(DatasetScan scan) {
        this.path = scan.getPath();
        this.dirLocation = scan.getScanLocation();
        this.datasetScan = scan;
        this.catScan = null;
        this.featCollection = null;
        this.type = Type.datasetScan;
        this.name = scan.getName();
        this.restrict = scan.getRestrictAccess();
        this.show();
    }

    public DataRoot(CatalogScan catScan) {
        this.path = catScan.getPath();
        this.dirLocation = catScan.getLocation();
        this.datasetScan = null;
        this.catScan = catScan;
        this.featCollection = null;
        this.type = Type.catalogScan;
        this.name = catScan.getName();
        this.restrict = null;
        this.show();
    }

    public DataRoot(String path, String dirLocation, String restrict) {
        this.path = path;
        this.dirLocation = dirLocation;
        this.datasetScan = null;
        this.catScan = null;
        this.featCollection = null;
        this.type = Type.datasetRoot;
        this.name = null;
        this.restrict = restrict;
        this.show();
    }

    private void show() {
    }

    public String getPath() {
        return this.path;
    }

    public String getDirLocation() {
        return this.dirLocation;
    }

    public Type getType() {
        return this.type;
    }

    public DatasetScan getDatasetScan() {
        return this.datasetScan;
    }

    public CatalogScan getCatalogScan() {
        return this.catScan;
    }

    public FeatureCollectionRef getFeatureCollection() {
        return this.featCollection;
    }

    public String getName() {
        return this.name;
    }

    public String getRestrict() {
        return this.restrict;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRoot root = (DataRoot)o;
        return this.path.equals(root.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String getFileLocationFromRequestPath(String reqPath) {
        if (this.datasetScan != null) {
            return this.getFileLocationFromRequestPath(reqPath, this.datasetScan.getPath(), this.datasetScan.getScanLocation(), false);
        }
        if (this.catScan != null) {
            return this.getFileLocationFromRequestPath(reqPath, this.catScan.getPath(), this.catScan.getLocation(), false);
        }
        if (this.featCollection != null) {
            return this.getFileLocationFromRequestPath(reqPath, this.featCollection.getPath(), this.featCollection.getTopDirectoryLocation(), true);
        }
        return this.getFileLocationFromRequestPath(reqPath, this.getPath(), this.getDirLocation(), false);
    }

    private String getFileLocationFromRequestPath(String reqPath, String rootPath, String rootLocation, boolean isFeatureCollection) {
        if (reqPath == null) {
            return null;
        }
        if (reqPath.length() == 0) {
            return null;
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (!reqPath.startsWith(rootPath)) {
            return null;
        }
        String locationReletive = reqPath.substring(rootPath.length());
        if (isFeatureCollection && locationReletive.startsWith("/files")) {
            locationReletive = locationReletive.substring(7);
        }
        if (locationReletive.startsWith("/")) {
            locationReletive = locationReletive.substring(1);
        }
        if (!rootLocation.endsWith("/")) {
            rootLocation = rootLocation.startsWith("cdms3") || rootLocation.startsWith("s3") ? rootLocation + "?" : rootLocation + "/";
        }
        return locationReletive.length() > 1 ? rootLocation + locationReletive : rootLocation;
    }

    public static enum Type {
        datasetRoot,
        datasetScan,
        catalogScan,
        featureCollection;

    }
}

