/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Formatter;
import thredds.server.catalog.DataRoot;
import thredds.server.catalog.tracker.ConfigCatalogExtProto;

public class DataRootExt
implements Comparable<DataRootExt> {
    public static int total_count = 0;
    public static long total_nbytes = 0L;
    private static final boolean debug = false;
    private String path;
    private String dirLocation;
    private DataRoot.Type type;
    private String catLocation;
    private String name;
    private String restrict;
    private DataRoot dataRoot;
    private static int nrecordsRead = 0;

    public DataRootExt() {
    }

    public DataRootExt(DataRoot dataRoot, String catLocation) {
        this.path = dataRoot.getPath();
        this.dataRoot = dataRoot;
        this.dirLocation = dataRoot.getDirLocation();
        this.type = dataRoot.getType();
        this.name = dataRoot.getName();
        this.catLocation = catLocation;
        this.restrict = dataRoot.getRestrict();
    }

    public String getPath() {
        return this.path;
    }

    public DataRoot getDataRoot() {
        if (this.dataRoot != null) {
            return this.dataRoot;
        }
        if (this.type == DataRoot.Type.datasetRoot) {
            this.dataRoot = new DataRoot(this.path, this.dirLocation, this.restrict);
        }
        return this.dataRoot;
    }

    public void setDataRoot(DataRoot dataRoot) {
        this.dataRoot = dataRoot;
        this.restrict = dataRoot.getRestrict();
    }

    public String getCatLocation() {
        return this.catLocation;
    }

    public String getDirLocation() {
        return this.dirLocation;
    }

    public DataRoot.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getRestrict() {
        return this.restrict;
    }

    public void writeExternal(DataOutputStream out) throws IOException {
        ConfigCatalogExtProto.DataRoot.Builder builder = ConfigCatalogExtProto.DataRoot.newBuilder();
        builder.setUrlPath(this.path);
        builder.setDirLocation(this.dirLocation);
        builder.setType(DataRootExt.convertDataRootType(this.type));
        if (this.type != DataRoot.Type.datasetRoot) {
            builder.setCatLocation(this.catLocation);
            builder.setName(this.name);
        }
        if (this.restrict != null) {
            builder.setRestrict(this.restrict);
        }
        ConfigCatalogExtProto.DataRoot index = builder.build();
        byte[] b = index.toByteArray();
        out.writeInt(b.length);
        out.write(b);
        ++total_count;
        total_nbytes += (long)(b.length + 4);
    }

    public void readExternal(DataInputStream in) throws IOException {
        int avail = in.available();
        int len = in.readInt();
        byte[] b = new byte[len];
        int n = in.read(b);
        if (n != len) {
            throw new RuntimeException("DataRootExt.readExternal failed read size=" + len + " in.available=" + avail);
        }
        ConfigCatalogExtProto.DataRoot dsp = ConfigCatalogExtProto.DataRoot.parseFrom(b);
        this.path = dsp.getUrlPath();
        this.dirLocation = dsp.getDirLocation();
        this.type = DataRootExt.convertDataRootType(dsp.getType());
        if (dsp.getCatLocation().length() > 0) {
            this.catLocation = dsp.getCatLocation();
        }
        if (dsp.getName().length() > 0) {
            this.name = dsp.getName();
        }
        if (dsp.getRestrict().length() > 0) {
            this.restrict = dsp.getRestrict();
        }
    }

    public static DataRoot.Type convertDataRootType(ConfigCatalogExtProto.DataRootType type) {
        switch (type) {
            case datasetRoot: {
                return DataRoot.Type.datasetRoot;
            }
            case datasetScan: {
                return DataRoot.Type.datasetScan;
            }
            case catalogScan: {
                return DataRoot.Type.catalogScan;
            }
            case featureCollection: {
                return DataRoot.Type.featureCollection;
            }
        }
        throw new IllegalStateException("illegal DataRootType " + (Object)((Object)type));
    }

    public static ConfigCatalogExtProto.DataRootType convertDataRootType(DataRoot.Type type) {
        switch (type) {
            case datasetRoot: {
                return ConfigCatalogExtProto.DataRootType.datasetRoot;
            }
            case datasetScan: {
                return ConfigCatalogExtProto.DataRootType.datasetScan;
            }
            case catalogScan: {
                return ConfigCatalogExtProto.DataRootType.catalogScan;
            }
            case featureCollection: {
                return ConfigCatalogExtProto.DataRootType.featureCollection;
            }
        }
        throw new IllegalStateException("illegal DataRootType " + (Object)((Object)type));
    }

    @Override
    public int compareTo(DataRootExt o) {
        return this.path.compareTo(o.getPath());
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("%s -> %s; type=%s", new Object[]{this.path, this.dirLocation, this.type});
        if (this.restrict != null) {
            f.format("; restrict=%s", this.restrict);
        }
        return f.toString();
    }
}

