/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.DatasetRootConfig;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.builder.CatalogScanBuilder;
import thredds.server.catalog.builder.FeatureCollectionRefBuilder;

@Immutable
public class ConfigCatalog
extends Catalog {
    public ConfigCatalog(URI baseURI, String name, Map<String, Object> flds, List<DatasetBuilder> datasets) {
        super(baseURI, name, flds, datasets);
    }

    public List<DatasetRootConfig> getDatasetRoots() {
        return this.getLocalFieldAsList("DatasetRoots");
    }

    public List<CatalogScan> getCatalogScans() {
        ArrayList<CatalogScan> result = new ArrayList<CatalogScan>();
        for (Dataset ds : this.getDatasetsLocal()) {
            if (!(ds instanceof CatalogScan)) continue;
            result.add((CatalogScan)ds);
        }
        return result;
    }

    public CatalogBuilder makeCatalogBuilder() {
        CatalogBuilder builder = new CatalogBuilder((Catalog)this);
        for (Dataset ds : this.getDatasetsLocal()) {
            builder.addDataset(this.makeDatasetBuilder(null, ds));
        }
        return builder;
    }

    private DatasetBuilder makeDatasetBuilder(DatasetBuilder parent, Dataset ds) {
        Object builder = ds instanceof CatalogScan ? new CatalogScanBuilder(parent, (CatalogScan)ds) : (ds instanceof FeatureCollectionRef ? new FeatureCollectionRefBuilder(parent, (FeatureCollectionRef)ds) : (ds instanceof CatalogRef ? new CatalogRefBuilder(parent, (CatalogRef)ds) : new DatasetBuilder(parent, ds)));
        List accesses = ds.getLocalFieldAsList("Access");
        for (Access access : accesses) {
            builder.addAccess(new AccessBuilder(builder, access));
        }
        if (!(ds instanceof CatalogRef)) {
            for (Dataset nested : ds.getDatasetsLocal()) {
                builder.addDataset(this.makeDatasetBuilder((DatasetBuilder)builder, nested));
            }
        }
        return builder;
    }
}

