/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Dataset;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.tracker.DatasetTracker;

public class DatasetTrackerInMem
implements DatasetTracker {
    private static final Logger logger = LoggerFactory.getLogger(DatasetTracker.class);
    private HashMap<String, String> resourceControlHash = new HashMap();
    private boolean hasResourceControl = false;
    private Map<String, String> ncmlDatasetHash = new HashMap<String, String>();

    public boolean init(String dirPath, long maxDatasets) {
        return true;
    }

    @Override
    public boolean trackDataset(long catId, Dataset dataset, DatasetTracker.Callback callback) {
        if (callback != null) {
            callback.hasDataset(dataset);
        }
        if (dataset.getRestrictAccess() != null) {
            if (callback != null) {
                callback.hasRestriction(dataset);
            } else {
                this.putResourceControl(dataset);
            }
        }
        if (dataset instanceof DatasetScan) {
            return false;
        }
        if (dataset instanceof FeatureCollectionRef) {
            return false;
        }
        if (dataset.getNcmlElement() != null) {
            if (callback != null) {
                callback.hasNcml(dataset);
            }
            Element ncmlElem = dataset.getNcmlElement();
            XMLOutputter xmlOut = new XMLOutputter();
            String ncml = xmlOut.outputString(ncmlElem);
            System.out.printf("%s%n", ncml);
            this.ncmlDatasetHash.put(dataset.getUrlPath(), ncml);
        }
        return true;
    }

    void putResourceControl(Dataset ds) {
        if (logger.isDebugEnabled()) {
            logger.debug("putResourceControl " + ds.getRestrictAccess() + " for " + ds.getName());
        }
        this.resourceControlHash.put(ds.getUrlPath(), ds.getRestrictAccess());
        this.hasResourceControl = true;
    }

    @Override
    public String findResourceControl(String path) {
        if (!this.hasResourceControl) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.resourceControlHash.get(path);
    }

    @Override
    public String findNcml(String path) {
        return this.ncmlDatasetHash.get(path);
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean reinit() {
        this.resourceControlHash = new HashMap();
        this.ncmlDatasetHash = new HashMap<String, String>();
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void save() {
    }

    @Override
    public void showDB(Formatter f) {
        f.format("DatasetTrackerInMem%n", new Object[0]);
        for (Map.Entry<String, String> entry : this.ncmlDatasetHash.entrySet()) {
            f.format(" %s == %s%n", entry.getKey(), entry.getValue());
        }
    }
}

