/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Formatter;
import thredds.server.catalog.tracker.ConfigCatalogExtProto;

public class DatasetExt {
    public static int total_count = 0;
    public static long total_nbytes = 0L;
    private static final boolean showParsedXML = false;
    long catId;
    String ncml;
    String restrictedAccess;

    public String getNcml() {
        return this.ncml;
    }

    public String getRestrictAccess() {
        return this.restrictedAccess;
    }

    public DatasetExt() {
    }

    public DatasetExt(long catId, String restrictedAccess, String ncml) {
        this.catId = catId;
        this.restrictedAccess = restrictedAccess;
        this.ncml = ncml;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("DatasetTrackerInfo{ catId=%d, restrict=%s", this.catId, this.restrictedAccess);
        if (this.ncml != null) {
            f.format("%n%s%n", this.ncml);
        }
        f.format("}", new Object[0]);
        return f.toString();
    }

    public byte[] toProtoBytes() {
        ConfigCatalogExtProto.Dataset.Builder builder = ConfigCatalogExtProto.Dataset.newBuilder();
        builder.setCatId(this.catId);
        builder.setName("");
        if (this.restrictedAccess != null) {
            builder.setRestrict(this.restrictedAccess);
        }
        if (this.ncml != null) {
            builder.setNcml(this.ncml);
        }
        ConfigCatalogExtProto.Dataset index = builder.build();
        byte[] protoBytes = index.toByteArray();
        ++total_count;
        total_nbytes += (long)(protoBytes.length + 4);
        return protoBytes;
    }

    public void fromProtoBytes(byte[] b) throws InvalidProtocolBufferException {
        ConfigCatalogExtProto.Dataset pDataset = ConfigCatalogExtProto.Dataset.parseFrom(b);
        this.catId = pDataset.getCatId();
        if (pDataset.getRestrict().length() > 0) {
            this.restrictedAccess = pDataset.getRestrict();
        }
        if (pDataset.getNcml().length() > 0) {
            this.ncml = pDataset.getNcml();
        }
    }
}

