/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.tools.DataFactory;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class ThreddsMetadataExtractor {
    private static Logger logger = LoggerFactory.getLogger(ThreddsMetadataExtractor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ThreddsMetadata extract(Dataset threddsDataset) throws IOException {
        ThreddsMetadata metadata = new ThreddsMetadata();
        Map flds = metadata.getFlds();
        try (DataFactory.Result result = new DataFactory().openFeatureDataset(threddsDataset, null);){
            ThreddsMetadata.VariableGroup vars;
            CalendarDateRange tc;
            if (result.fatalError) {
                logger.warn(" openFeatureDataset failed, errs=%s%n", (Object)result.errLog);
                ThreddsMetadata threddsMetadata = null;
                return threddsMetadata;
            }
            if (result.featureType.isCoverageFeatureType()) {
                ThreddsMetadata.VariableGroup vars2;
                GridDataset gridDataset = (GridDataset)result.featureDataset;
                flds.put("GeospatialCoverage", this.extractGeospatial(gridDataset));
                CalendarDateRange tc2 = this.extractCalendarDateRange(gridDataset);
                if (tc2 != null) {
                    flds.put("TimeCoverage", tc2);
                }
                if ((vars2 = this.extractVariables(threddsDataset.getDataFormatName(), gridDataset)) == null) return metadata;
                flds.put("VariableGroups", vars2);
                return metadata;
            }
            if (!result.featureType.isPointFeatureType()) return metadata;
            PointDatasetImpl pobsDataset = (PointDatasetImpl)result.featureDataset;
            LatLonRect llbb = pobsDataset.getBoundingBox();
            if (null != llbb) {
                flds.put("GeospatialCoverage", new ThreddsMetadata.GeospatialCoverage(llbb, null, 0.0, 0.0));
            }
            if ((tc = this.extractCalendarDateRange((FeatureDatasetPoint)pobsDataset)) != null) {
                flds.put("TimeCoverage", tc);
            }
            if ((vars = this.extractVariables((FeatureDatasetPoint)pobsDataset)) == null) return metadata;
            flds.put("VariableGroups", vars);
            return metadata;
        }
        catch (IOException ioe) {
            logger.error("Error opening dataset " + threddsDataset.getName(), (Throwable)ioe);
        }
        return metadata;
    }

    public ThreddsMetadata.GeospatialCoverage extractGeospatial(GridDataset gridDataset) {
        LatLonRect llbb = null;
        CoordinateAxis1D vaxis = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            if (llbb == null) {
                llbb = gsys.getLatLonBoundingBox();
            }
            CoordinateAxis1D vaxis2 = gsys.getVerticalAxis();
            if (vaxis == null) {
                vaxis = vaxis2;
                continue;
            }
            if (vaxis2 == null || vaxis2.getSize() <= vaxis.getSize()) continue;
            vaxis = vaxis2;
        }
        return new ThreddsMetadata.GeospatialCoverage(llbb, vaxis, 0.0, 0.0);
    }

    public ThreddsMetadata.VariableGroup extractVariables(String fileFormat, GridDataset gridDataset) {
        ArrayList<ThreddsMetadata.Variable> vars = new ArrayList<ThreddsMetadata.Variable>();
        String vocab = fileFormat;
        DataFormatType fileType = DataFormatType.getType((String)fileFormat);
        if (fileType != null && (fileType == DataFormatType.GRIB1 || fileType == DataFormatType.GRIB2)) {
            for (GridDatatype grid : gridDataset.getGrids()) {
                String name = grid.getShortName();
                String desc = grid.getDescription();
                String units = grid.getUnitsString();
                String vname = null;
                String id = null;
                Attribute att = grid.findAttributeIgnoreCase("Grib_Variable_Id");
                if (att != null) {
                    id = att.getStringValue();
                    vname = att.getStringValue();
                }
                vars.add(new ThreddsMetadata.Variable(name, desc, vname, units, id));
            }
        } else {
            vocab = "CF-1.0";
            for (GridDatatype grid : gridDataset.getGrids()) {
                String name = grid.getShortName();
                String desc = grid.getDescription();
                String units = grid.getUnitsString();
                String vname = null;
                String id = null;
                Attribute att = grid.findAttributeIgnoreCase("standard_name");
                if (att != null) {
                    vname = att.getStringValue();
                }
                vars.add(new ThreddsMetadata.Variable(name, desc, vname, units, id));
            }
        }
        Collections.sort(vars);
        return new ThreddsMetadata.VariableGroup(vocab, null, null, vars);
    }

    public ThreddsMetadata.GeospatialCoverage extractGeospatial(FeatureDatasetPoint fd) {
        LatLonRect llbb = fd.getBoundingBox();
        if (llbb != null) {
            return new ThreddsMetadata.GeospatialCoverage(llbb, null, 0.0, 0.0);
        }
        return null;
    }

    public ThreddsMetadata.VariableGroup extractVariables(FeatureDatasetPoint fd) {
        ArrayList<ThreddsMetadata.Variable> vars = new ArrayList<ThreddsMetadata.Variable>();
        List dataVars = fd.getDataVariables();
        if (dataVars == null) {
            return null;
        }
        for (VariableSimpleIF v : dataVars) {
            String name = v.getShortName();
            String desc = v.getDescription();
            String units = v.getUnitsString();
            String vname = null;
            String id = null;
            Attribute att = v.attributes().findAttributeIgnoreCase("standard_name");
            if (att != null) {
                vname = att.getStringValue();
            }
            vars.add(new ThreddsMetadata.Variable(name, desc, vname, units, id));
        }
        Collections.sort(vars);
        return new ThreddsMetadata.VariableGroup("CF-1.0", null, null, vars);
    }

    public CalendarDateRange extractCalendarDateRange(FeatureDatasetPoint fd) {
        return fd.getCalendarDateRange();
    }

    public CalendarDateRange extractCalendarDateRange(GridDataset gridDataset) {
        CalendarDateRange maxDateRange = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            CalendarDateRange dateRange;
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            CoordinateAxis1DTime time1D = gsys.getTimeAxis1D();
            if (time1D != null) {
                dateRange = time1D.getCalendarDateRange();
            } else {
                CoordinateAxis time = gsys.getTimeAxis();
                if (time == null) continue;
                try {
                    CalendarDateUnit du = CalendarDateUnit.of(null, (String)time.getUnitsString());
                    CalendarDate minDate = du.makeCalendarDate(time.getMinValue());
                    CalendarDate maxDate = du.makeCalendarDate(time.getMaxValue());
                    dateRange = CalendarDateRange.of((CalendarDate)minDate, (CalendarDate)maxDate);
                }
                catch (Exception e) {
                    logger.warn("Illegal Date Unit " + time.getUnitsString());
                    continue;
                }
            }
            if (maxDateRange == null) {
                maxDateRange = dateRange;
                continue;
            }
            maxDateRange = maxDateRange.extend(dateRange);
        }
        return maxDateRange;
    }
}

