/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Formatter;
import java.util.stream.Stream;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.cache.DiskPersistedCache;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;
import thredds.server.catalog.tracker.DatasetExt;
import thredds.server.catalog.tracker.DatasetTracker;

public class DatasetTrackerDiskPersistedCache
implements DatasetTracker,
AutoCloseable {
    private static Logger catalogInitLog = LoggerFactory.getLogger((String)"catalogInit");
    private DiskPersistedCache<String, DatasetExt> datasetMap;
    private DiskPersistedCache.Builder<String, DatasetExt> builder;

    public static void cleanupBefore(String pathname, long trackerNumber) {
        for (long tnum = trackerNumber - 1L; tnum > 0L; --tnum) {
            Path location = DatasetTrackerDiskPersistedCache.trackerLocation(pathname, tnum);
            if (!Files.exists(location, new LinkOption[0]) || !Files.isDirectory(location, new LinkOption[0])) continue;
            try (Stream<Path> tree = Files.walk(location, new FileVisitOption[0]);){
                tree.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                catalogInitLog.info("DatasetTrackerDiskPersistedCache deleted {} ", (Object)location);
                continue;
            }
            catch (IOException ioe) {
                catalogInitLog.error("DatasetTrackerDiskPersistedCache not able to delete {}", (Object)location, (Object)ioe);
            }
        }
    }

    private static Path trackerLocation(String trackerDir, long trackerNumber) {
        return Paths.get(trackerDir, new String[0]).resolve(String.format("store_%s", trackerNumber));
    }

    public DatasetTrackerDiskPersistedCache(String trackerDir, long maxDatasets) {
        this(trackerDir, 0L, maxDatasets);
    }

    public DatasetTrackerDiskPersistedCache(String trackerDir, long trackerNumber, long maxDatasets) {
        Path location = DatasetTrackerDiskPersistedCache.trackerLocation(trackerDir, trackerNumber);
        try {
            this.builder = DiskPersistedCache.at(location);
            this.builder.maxInMemoryEntities(maxDatasets).named(String.format("datasetTracker_%s", trackerNumber));
            this.datasetMap = this.builder.build();
        }
        catch (IOException e) {
            catalogInitLog.error("Failed to setup DatasetTracker at {}", (Object)location, (Object)e);
        }
    }

    @Override
    public void save() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.datasetMap.shutdown();
    }

    @Override
    public boolean exists() {
        return this.datasetMap != null && this.datasetMap.running();
    }

    @Override
    public boolean reinit() {
        this.datasetMap.reinit();
        return true;
    }

    @Override
    public boolean trackDataset(long catId, Dataset dataset, DatasetTracker.Callback callback) {
        boolean hasNcml;
        if (callback != null) {
            callback.hasDataset(dataset);
            boolean track = false;
            if (dataset.getRestrictAccess() != null) {
                callback.hasRestriction(dataset);
                track = true;
            }
            if (dataset.getNcmlElement() != null) {
                callback.hasNcml(dataset);
                track = true;
            }
            if (track) {
                callback.hasTrackedDataset(dataset);
            }
        }
        boolean hasRestrict = dataset.getRestrictAccess() != null;
        boolean bl = hasNcml = dataset.getNcmlElement() != null && !(dataset instanceof DatasetScan) && !(dataset instanceof FeatureCollectionRef);
        if (!hasRestrict && !hasNcml) {
            return false;
        }
        String path = null;
        if (dataset instanceof DatasetScan) {
            path = ((DatasetScan)dataset).getPath();
        } else if (dataset instanceof FeatureCollectionRef) {
            path = ((FeatureCollectionRef)dataset).getPath();
        } else {
            for (Access access : dataset.getAccess()) {
                ServiceType st = access.getService().getType();
                if (st == null || !st.isStandardTdsService()) continue;
                String accessPath = access.getUrlPath();
                if (accessPath == null) {
                    catalogInitLog.warn("trackDataset {} access {} has null path", (Object)dataset, (Object)access);
                    continue;
                }
                if (path == null) {
                    path = accessPath;
                    continue;
                }
                if (path.equals(accessPath)) continue;
                System.out.printf(" paths differ: %s%n %s%n%n", path, accessPath);
                catalogInitLog.warn(" paths differ: {} != {}", (Object)path, (Object)accessPath);
            }
            if (path == null) {
                path = dataset.getUrlPath();
            }
        }
        if (path == null) {
            catalogInitLog.debug("trackDataset {} has null path", (Object)dataset);
            return false;
        }
        String ncml = null;
        if (hasNcml) {
            Element ncmlElem = dataset.getNcmlElement();
            XMLOutputter xmlOut = new XMLOutputter(Format.getCompactFormat());
            ncml = xmlOut.outputString(ncmlElem);
        }
        DatasetExt dsext = new DatasetExt(catId, dataset.getRestrictAccess(), ncml);
        if (this.datasetMap == null) {
            catalogInitLog.error("DatasetTracker cache not properly initialized. Can't track dataset {}", (Object)dataset);
            return false;
        }
        this.datasetMap.put(path, dsext);
        return true;
    }

    @Override
    public String findResourceControl(String path) {
        if (this.datasetMap == null) {
            return null;
        }
        DatasetExt dext = this.datasetMap.get(path);
        if (dext == null) {
            return null;
        }
        return dext.getRestrictAccess();
    }

    @Override
    public String findNcml(String path) {
        if (this.datasetMap == null) {
            return null;
        }
        DatasetExt dext = this.datasetMap.get(path);
        if (dext == null) {
            return null;
        }
        return dext.getNcml();
    }

    @Override
    public void showDB(Formatter f) {
        if (this.datasetMap == null) {
            return;
        }
        f.format("DiskPersistedCache %s%n", this.datasetMap.name());
        f.format("Level 1:%n", new Object[0]);
        this.datasetMap.showL1Db(f);
        f.format("%n", new Object[0]);
        f.format("Level 2:%n", new Object[0]);
        this.datasetMap.showL2Db(f, 10);
    }

    long getCount() {
        return this.datasetMap != null ? this.datasetMap.numL2Keys() : -1L;
    }
}

