/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import com.google.common.eventbus.EventBus;
import java.util.Date;
import javax.annotation.concurrent.ThreadSafe;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateEvent;
import thredds.inventory.CollectionUpdateType;

@Component
@ThreadSafe
public class CollectionUpdater {
    private static final Logger fcLogger = LoggerFactory.getLogger(CollectionUpdater.class);
    private static final String COLLECTION_NAME = "collectionName";
    private static final String EVENT_BUS = "eventBus";
    private static final String LOGGER = "logger";
    private static final String UpdateType = "updateType";
    private static final String Source = "Source";
    private static final long startupWait = 3000L;
    private static boolean disabled = false;
    @Autowired
    @Qualifier(value="fcTriggerEventBus")
    private EventBus eventBus;
    private Scheduler scheduler = null;
    private boolean failed = false;
    private boolean isTdm = false;

    public void setTdm(boolean tdm) {
        this.isTdm = tdm;
    }

    public boolean isTdm() {
        return this.isTdm;
    }

    public CollectionUpdater() {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
        }
        catch (Throwable e) {
            this.failed = true;
            throw new RuntimeException("quartz scheduler failed to initialize", e);
        }
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void scheduleTasks(FeatureCollectionConfig config, Logger logger) {
        FeatureCollectionConfig.UpdateConfig updateConfig;
        if (disabled || this.failed) {
            return;
        }
        if (logger == null) {
            logger = fcLogger;
        }
        FeatureCollectionConfig.UpdateConfig updateConfig2 = updateConfig = this.isTdm ? config.tdmConfig : config.updateConfig;
        if (updateConfig == null || updateConfig.updateType == CollectionUpdateType.never) {
            return;
        }
        String collectionName = config.getCollectionName();
        JobDataMap map = new JobDataMap();
        map.put(EVENT_BUS, (Object)this.eventBus);
        map.put(COLLECTION_NAME, collectionName);
        map.put(LOGGER, (Object)logger);
        JobDetail updateJob = JobBuilder.newJob(UpdateCollectionJob.class).withIdentity(collectionName, "UpdateCollection").storeDurably().usingJobData(map).build();
        try {
            if (!this.scheduler.checkExists(updateJob.getKey())) {
                this.scheduler.addJob(updateJob, false);
            } else {
                logger.warn("scheduler failed to add updateJob for " + String.valueOf(updateJob.getKey()) + ". Another Job exists with that identification.");
            }
        }
        catch (Throwable e) {
            logger.error("scheduler failed to add updateJob for " + String.valueOf(config), e);
            return;
        }
        if (updateConfig.startupType != CollectionUpdateType.never) {
            map = new JobDataMap();
            map.put(UpdateType, (Object)updateConfig.startupType);
            map.put(Source, "startup");
            Date runTime = new Date(new Date().getTime() + 3000L);
            SimpleTrigger startupTrigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(collectionName, "startup").startAt(runTime).forJob(updateJob).usingJobData(map).build();
            try {
                this.scheduler.scheduleJob((Trigger)startupTrigger);
                logger.info("scheduleJob startup scan force={} for '{}' at {}", new Object[]{updateConfig.startupType.toString(), config.collectionName, runTime});
            }
            catch (Throwable e) {
                logger.error("scheduleJob failed to schedule startup Job for " + String.valueOf(config), e);
                return;
            }
        }
        if (updateConfig.rescan != null) {
            map = new JobDataMap();
            map.put(UpdateType, (Object)updateConfig.updateType);
            map.put(Source, "rescan");
            CronTrigger rescanTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(collectionName, "rescan").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)updateConfig.rescan)).forJob(updateJob).usingJobData(map).build();
            try {
                this.scheduler.scheduleJob((Trigger)rescanTrigger);
                logger.info("scheduleJob recurring scan for '{}' cronExpr={}", (Object)config.collectionName, (Object)updateConfig.rescan);
            }
            catch (Throwable e) {
                logger.error("scheduleJob failed to schedule cron Job", e);
            }
        }
    }

    public void shutdown() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown(true);
            System.out.printf("Quartz scheduler shutdown%n", new Object[0]);
        }
        catch (Throwable e) {
            fcLogger.error("Scheduler failed to shutdown", e);
            this.scheduler = null;
        }
    }

    public static class UpdateCollectionJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            block2: {
                EventBus eventBus = (EventBus)context.getJobDetail().getJobDataMap().get((Object)CollectionUpdater.EVENT_BUS);
                String collectionName = (String)context.getJobDetail().getJobDataMap().get((Object)CollectionUpdater.COLLECTION_NAME);
                Logger loggerfc = (Logger)context.getJobDetail().getJobDataMap().get((Object)CollectionUpdater.LOGGER);
                CollectionUpdateType type = (CollectionUpdateType)context.getTrigger().getJobDataMap().get((Object)CollectionUpdater.UpdateType);
                String source = (String)context.getTrigger().getJobDataMap().get((Object)CollectionUpdater.Source);
                String groupName = context.getTrigger().getKey().getGroup();
                try {
                    eventBus.post((Object)new CollectionUpdateEvent(type, collectionName, source));
                    fcLogger.debug("CollectionUpdate post event {} on {}", (Object)type, (Object)collectionName);
                }
                catch (Throwable e) {
                    if (loggerfc == null) break block2;
                    loggerfc.error("UpdateCollectionJob.execute " + groupName + " failed collection=" + collectionName, e);
                }
            }
        }
    }
}

