/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import thredds.server.catalog.CatalogReader;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.builder.ConfigCatalogBuilder;
import ucar.unidata.util.StringUtil2;

@Component
public class ConfigCatalogCache
implements CatalogReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigCatalogCache.class);
    private static final String ERROR = "*** ERROR ";
    private String context;
    private String rootPath;
    private Cache<String, ConfigCatalog> cache;
    private List<String> rootCatalogKeys;

    public ConfigCatalogCache() {
    }

    public ConfigCatalogCache(String rootPath, int maxSize) {
        this.rootPath = rootPath;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).recordStats().build();
    }

    public void init(String rootPath, int maxSize, final String context) {
        this.rootPath = rootPath;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).recordStats().build((CacheLoader)new CacheLoader<String, ConfigCatalog>(){

            public ConfigCatalog load(String key) throws IOException {
                return ConfigCatalogCache.readCatalog(key, context);
            }
        });
        this.context = context;
    }

    public void put(String catKey, ConfigCatalog cat) throws IOException {
        this.cache.put((Object)catKey, (Object)cat);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public ConfigCatalog getFromAbsolutePath(String catalogFullPath) throws IOException {
        if ((catalogFullPath = catalogFullPath.replace("\\", "/")).startsWith(this.rootPath)) {
            String catKey = catalogFullPath.substring(this.rootPath.length());
            return this.get(catKey);
        }
        return ConfigCatalogCache.readCatalog(catalogFullPath, this.context);
    }

    public ConfigCatalog get(String catKey) throws IOException {
        try {
            return (ConfigCatalog)((Object)this.cache.get((Object)catKey, () -> ConfigCatalogCache.readCatalog(this.rootPath + catKey, this.context)));
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            if (c instanceof IOException) {
                throw (IOException)c;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static ConfigCatalog readCatalog(String catalogFullPath) throws IOException {
        String defaultContext = "thredds";
        return ConfigCatalogCache.readCatalog(catalogFullPath, "thredds");
    }

    public static ConfigCatalog readCatalog(String catalogFullPath, String context) throws IOException {
        URI uri;
        File catFile = new File(catalogFullPath);
        if (!catFile.exists() || catFile.isDirectory()) {
            throw new FileNotFoundException(ConfigCatalogCache.getFileName(catalogFullPath));
        }
        try {
            uri = new URI("file:" + StringUtil2.escape((String)catalogFullPath, (String)"/:-_."));
        }
        catch (URISyntaxException e) {
            logger.error("*** ERROR readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        ConfigCatalogBuilder builder = new ConfigCatalogBuilder(context);
        ConfigCatalog cat = (ConfigCatalog)builder.buildFromURI(uri);
        if (builder.hasFatalError()) {
            throw new IOException("invalid catalog: " + ConfigCatalogCache.getFileName(catalogFullPath));
        }
        return cat;
    }

    private static String getFileName(String catalogFullPath) {
        String contentDirName = "/thredds/";
        int pos = catalogFullPath.lastIndexOf("/thredds/");
        return pos > 0 ? catalogFullPath.substring(pos + "/thredds/".length()) : catalogFullPath;
    }

    public void setRootCatalogKeys(List<String> rootCatalogKeys) {
        this.rootCatalogKeys = rootCatalogKeys;
    }

    public List<String> getRootCatalogKeys() {
        return this.rootCatalogKeys;
    }

    public boolean isRoot(String catName) {
        return this.rootCatalogKeys.contains(catName);
    }
}

