/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.builder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Property;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.DatasetScanConfig;

public class DatasetScanBuilder
extends DatasetBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DatasetScanBuilder.class);
    DatasetScanConfig config;
    String context = "thredds";

    public DatasetScanBuilder(DatasetBuilder parent, DatasetScanConfig config, String context) {
        super(parent);
        this.config = config;
        this.context = context;
    }

    public DatasetScan makeDataset(DatasetNode parent) {
        this.addToList("Properties", new Property("DatasetScan", "true"));
        String xlink = "/" + this.context + "/catalog/" + this.config.path + "/catalog.xml";
        DatasetScan dscan = new DatasetScan(parent, this.name, xlink, this.flds, this.accessBuilders, this.datasetBuilders, this.config);
        if (null == dscan.getServiceNameDefault() && null == dscan.getFeatureType()) {
            logger.error("DatasetScan " + this.name + " does not have a default serviceName or dataType/featureType");
        }
        return dscan;
    }
}

