/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFile;
import thredds.inventory.TimePartitionCollection;
import thredds.tdm.CatalogReader;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;

public class TdmRunner {
    private static boolean seperateFiles = true;
    private static String serverName = "http://localhost:8080/";
    private static HTTPSession session;
    private ExecutorService executor;
    private Resource catalog;
    private boolean indexOnly = false;
    private boolean showOnly = false;
    private static String user;
    private static String pass;
    private static boolean sendTriggers;

    public void setShowOnly(boolean showOnly) {
        this.showOnly = showOnly;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setCatalog(Resource catalog) {
        this.catalog = catalog;
    }

    public void setTdsServer(String serverName) {
        TdmRunner.serverName = serverName;
    }

    void start() throws IOException {
        System.out.printf("Tdm startup at %s%n", new Date());
        CatalogReader reader = new CatalogReader(this.catalog);
        List<InvDatasetFeatureCollection> fcList = reader.getFcList();
        if (this.showOnly) {
            ArrayList<String> result = new ArrayList<String>();
            for (InvDatasetFeatureCollection fc : fcList) {
                CollectionManager dcm = fc.getDatasetCollectionManager();
                result.add(dcm.getRoot());
            }
            Collections.sort(result);
            System.out.printf("Directories:%n", new Object[0]);
            for (String dir : result) {
                System.out.printf(" %s%n", dir);
            }
            return;
        }
        for (InvDatasetFeatureCollection fc : fcList) {
            CollectionManager dcm = fc.getDatasetCollectionManager();
            FeatureCollectionConfig fcConfig = fc.getConfig();
            if (fcConfig != null && fcConfig.gribConfig != null && fcConfig.gribConfig.gdsHash != null) {
                dcm.putAuxInfo("gdsHash", (Object)fcConfig.gribConfig.gdsHash);
            }
            dcm.addEventListener((CollectionManager.TriggerListener)new Listener(fc, dcm));
            dcm.removeEventListener((CollectionManager.TriggerListener)fc);
        }
        Formatter f = new Formatter();
        f.format("Feature Collections found:%n", new Object[0]);
        for (InvDatasetFeatureCollection fc : fcList) {
            CollectionManager dcm = fc.getDatasetCollectionManager();
            f.format("  %s == %s%n%s%n%n", fc, fc.getClass().getName(), dcm);
        }
        System.out.printf("%s%n", f.toString());
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        FileSystemXmlApplicationContext springContext = new FileSystemXmlApplicationContext("classpath:resources/application-config.xml");
        TdmRunner driver = (TdmRunner)springContext.getBean("testDriver");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help")) {
                System.out.printf("usage: TdmRunner [-catalog <cat>] [-server <tdsServer>] [-cred <user:passwd>] [-showDirs] %n", new Object[0]);
                System.out.printf("example: TdmRunner -catalog classpath:/resources/indexNomads.xml -server http://localhost:8080/ -cred user:password %n", new Object[0]);
                System.exit(0);
            }
            if (args[i].equalsIgnoreCase("-showDirs")) {
                driver.setShowOnly(true);
            }
            if (args[i].equalsIgnoreCase("-server")) {
                driver.setTdsServer(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase("-cred")) {
                String cred = args[i + 1];
                String[] split = cred.split(":");
                user = split[0];
                pass = split[1];
                sendTriggers = true;
            }
            if (!args[i].equalsIgnoreCase("-catalog")) continue;
            FileSystemResource cat = new FileSystemResource(args[i + 1]);
            driver.setCatalog((Resource)cat);
        }
        if (sendTriggers) {
            session = new HTTPSession(serverName);
            session.setCredentialsProvider(new CredentialsProvider(){

                public Credentials getCredentials(AuthScheme authScheme, String s, int i, boolean b) throws CredentialsNotAvailableException {
                    return new UsernamePasswordCredentials(user, pass);
                }
            });
            session.setUserAgent("tdmRunner");
            HTTPSession.setGlobalUserAgent((String)"TDM v4.3");
        }
        CollectionUpdater.INSTANCE.setTdm(true);
        driver.start();
    }

    private class Listener
    implements CollectionManager.TriggerListener {
        InvDatasetFeatureCollection fc;
        CollectionManager dcm;
        AtomicBoolean inUse = new AtomicBoolean(false);
        Logger logger;

        private Listener(InvDatasetFeatureCollection fc, CollectionManager dcm) {
            this.fc = fc;
            this.dcm = dcm;
            if (seperateFiles) {
                try {
                    PatternLayout layout = new PatternLayout("%d{yyyy-MM-dd'T'HH:mm:ss.SSS Z} %-5p - %c - %m%n");
                    String loggerName = fc.getName() + ".log";
                    FileAppender app = new FileAppender((Layout)layout, loggerName);
                    org.apache.log4j.Logger log4j = LogManager.getLogger((String)fc.getName());
                    log4j.addAppender((Appender)app);
                    log4j.setLevel(Level.DEBUG);
                    this.logger = LoggerFactory.getLogger((String)fc.getName());
                }
                catch (IOException ioe) {}
            } else {
                this.logger = LoggerFactory.getLogger(this.getClass());
            }
        }

        public void handleCollectionEvent(CollectionManager.TriggerEvent event) {
            if (event.getType() != CollectionManager.TriggerType.update) {
                return;
            }
            if (this.inUse.get()) {
                this.logger.debug("** Update already in progress for {} {}", (Object)this.fc.getName(), (Object)event.getType());
                return;
            }
            if (!this.inUse.compareAndSet(false, true)) {
                return;
            }
            TdmRunner.this.executor.execute(new IndexTask(this.fc, this.dcm, this, this.logger));
        }
    }

    private class IndexTask
    implements Runnable {
        String name;
        InvDatasetFeatureCollection fc;
        CollectionManager dcm;
        Listener liz;
        Logger logger;

        private IndexTask(InvDatasetFeatureCollection fc, CollectionManager dcm, Listener liz, Logger logger) {
            this.name = fc.getName();
            this.fc = fc;
            this.dcm = dcm;
            this.liz = liz;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                try {
                    FeatureCollectionConfig config = this.fc.getConfig();
                    DataFormatType format = this.fc.getDataFormatType();
                    if (this.dcm instanceof TimePartitionCollection) {
                        TimePartitionCollection tpc = (TimePartitionCollection)this.dcm;
                        this.logger.debug("**** running TimePartitionBuilder.factory {} thread {}", (Object)this.name, (Object)Thread.currentThread().hashCode());
                        Formatter f = new Formatter();
                        try {
                            TimePartition tp = TimePartition.factory((format == DataFormatType.GRIB1 ? 1 : 0) != 0, (TimePartitionCollection)tpc, (CollectionManager.Force)CollectionManager.Force.always, (Formatter)f);
                            tp.close();
                            if (config.tdmConfig.triggerOk && sendTriggers) {
                                String url = serverName + "thredds/admin/collection/trigger?nocheck&collection=" + this.fc.getName();
                                int status = this.sendTrigger(url, f);
                                f.format(" trigger %s status = %d%n", url, status);
                            }
                            f.format("**** TimePartitionBuilder.factory complete %s%n", this.name);
                        }
                        catch (Throwable e) {
                            this.logger.error("TimePartitionBuilder.factory " + this.name, e);
                        }
                        this.logger.debug("\n------------------------\n{}\n------------------------\n", (Object)f.toString());
                        break block11;
                    }
                    this.logger.debug("**** running GribCollectionBuilder.factory {} Thread {}", (Object)this.name, (Object)Thread.currentThread().hashCode());
                    Formatter f = new Formatter();
                    try {
                        GribCollection gc = GribCollection.factory((format == DataFormatType.GRIB1 ? 1 : 0) != 0, (CollectionManager)this.dcm, (CollectionManager.Force)CollectionManager.Force.always, (Formatter)f);
                        gc.close();
                        if (config.tdmConfig.triggerOk && sendTriggers) {
                            String url = serverName + "thredds/admin/collection/trigger?nocheck&collection=" + this.fc.getName();
                            int status = this.sendTrigger(url, f);
                            f.format(" trigger %s status = %d%n", url, status);
                        }
                        f.format("**** GribCollectionBuilder.factory complete %s%n", this.name);
                    }
                    catch (Throwable e) {
                        this.logger.error("GribCollectionBuilder.factory " + this.name, e);
                    }
                    this.logger.debug("\n------------------------\n{}\n------------------------\n", (Object)f.toString());
                }
                finally {
                    if (!this.liz.inUse.getAndSet(false)) {
                        this.logger.warn("Listener InUse should have been set");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int sendTrigger(String url, Formatter f) {
            this.logger.debug("send trigger to {}", (Object)url);
            HTTPMethod m = null;
            try {
                m = HTTPMethod.Get((HTTPSession)session, (String)url);
                int status = m.execute();
                String s = m.getResponseAsString();
                f.format("%s == %s", url, s);
                System.out.printf("Trigger response = %s%n", s);
                int n = status;
                return n;
            }
            catch (HTTPException e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                f.format("%s == %s", url, bos.toString());
                e.printStackTrace();
                int n = -1;
                return n;
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
        }

        private void doManage(String deleteAfterS) {
            TimeDuration deleteAfter = null;
            if (deleteAfterS != null) {
                try {
                    deleteAfter = new TimeDuration(deleteAfterS);
                }
                catch (Exception e) {
                    this.logger.error(this.dcm.getCollectionName() + ": Invalid time unit for deleteAfter = {}", (Object)deleteAfter);
                    return;
                }
            }
            double val = deleteAfter.getValue();
            CalendarPeriod.Field unit = CalendarPeriod.fromUnitString((String)deleteAfter.getTimeUnit().getUnitString());
            CalendarPeriod period = CalendarPeriod.of((int)1, (CalendarPeriod.Field)unit);
            CalendarDate now = CalendarDate.of((Date)new Date());
            CalendarDate last = now.add(-val, unit);
            for (MFile mfile : this.dcm.getFiles()) {
                CalendarDate cd = this.dcm.extractRunDate(mfile);
                int n = period.subtract(cd, now);
                if (cd.isBefore(last)) {
                    this.logger.info("delete={} age = {}", (Object)mfile.getPath(), (Object)(n + " " + unit));
                    continue;
                }
                this.logger.debug("dont delete={} age = {}", (Object)mfile.getPath(), (Object)(n + " " + unit));
            }
        }
    }
}

