/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFile;
import thredds.inventory.TimePartitionCollection;
import thredds.tdm.CatalogReader;
import thredds.util.LoggerFactorySpecial;
import thredds.util.ThreddsConfigReader;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;

public class TdmRunner {
    private static Logger log = LoggerFactory.getLogger(TdmRunner.class);
    private File contentDir;
    private String user;
    private String pass;
    private boolean sendTriggers;
    private List<Server> servers;
    private ExecutorService executor;
    private Resource catalog;
    private boolean showOnly = false;

    public void setContentDir(String contentDir) {
        this.contentDir = new File(contentDir);
        this.catalog = new FileSystemResource(new File(contentDir, "catalog.xml"));
    }

    public void setShowOnly(boolean showOnly) {
        this.showOnly = showOnly;
    }

    public void setNThreads(int n) {
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setCatalog(Resource catalog) {
        this.catalog = catalog;
    }

    public void setServerNames(String[] serverNames) throws HTTPException {
        if (serverNames == null) {
            this.servers = new ArrayList<Server>();
            return;
        }
        this.servers = new ArrayList<Server>(serverNames.length);
        for (String name : serverNames) {
            HTTPSession session = new HTTPSession(name);
            session.setCredentialsProvider(new CredentialsProvider(){

                public Credentials getCredentials(AuthScheme authScheme, String s, int i, boolean b) throws CredentialsNotAvailableException {
                    return new UsernamePasswordCredentials(TdmRunner.this.user, TdmRunner.this.pass);
                }
            });
            session.setUserAgent("tdmRunner");
            this.servers.add(new Server(name, session));
        }
    }

    boolean init() {
        File configFile = new File(this.contentDir, "threddsConfig.xml");
        if (!configFile.exists()) {
            log.error("config file {} does not exist, set -contentDir <dir>", (Object)configFile.getPath());
            return false;
        }
        ThreddsConfigReader reader = new ThreddsConfigReader(configFile.getPath(), log);
        String gribIndexDir = reader.get("GribIndex.dir", new File(this.contentDir, "/cache/grib/").getPath());
        Boolean gribIndexAlwaysUse = reader.getBoolean("GribIndex.alwaysUse", false);
        String gribIndexPolicy = reader.get("GribIndex.policy", null);
        DiskCache2 gribCache = new DiskCache2(gribIndexDir, false, -1, -1);
        gribCache.setPolicy(gribIndexPolicy);
        gribCache.setAlwaysUseCache(gribIndexAlwaysUse.booleanValue());
        GribCollection.setDiskCache2((DiskCache2)gribCache);
        return true;
    }

    void start() throws IOException {
        System.out.printf("Tdm startup at %s%n", new Date());
        CatalogReader reader = new CatalogReader(this.catalog);
        List<InvDatasetFeatureCollection> fcList = reader.getFcList();
        if (this.showOnly) {
            ArrayList<String> result = new ArrayList<String>();
            for (InvDatasetFeatureCollection fc : fcList) {
                CollectionManager dcm = fc.getDatasetCollectionManager();
                result.add(dcm.getRoot());
            }
            Collections.sort(result);
            System.out.printf("Directories:%n", new Object[0]);
            for (String dir : result) {
                System.out.printf(" %s%n", dir);
            }
            return;
        }
        for (InvDatasetFeatureCollection fc : fcList) {
            CollectionManager dcm = fc.getDatasetCollectionManager();
            FeatureCollectionConfig fcConfig = fc.getConfig();
            if (fcConfig != null && fcConfig.gribConfig != null && fcConfig.gribConfig.gdsHash != null) {
                dcm.putAuxInfo("gdsHash", (Object)fcConfig.gribConfig.gdsHash);
            }
            dcm.addEventListener((CollectionManager.TriggerListener)new Listener(fc, dcm));
            dcm.removeEventListener((CollectionManager.TriggerListener)fc);
        }
        Formatter f = new Formatter();
        f.format("Feature Collections found:%n", new Object[0]);
        for (InvDatasetFeatureCollection fc : fcList) {
            CollectionManager dcm = fc.getDatasetCollectionManager();
            f.format("  %s == %s%n%s%n%n", fc, fc.getClass().getName(), dcm);
        }
        System.out.printf("%s%n", f.toString());
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        FileSystemXmlApplicationContext springContext = new FileSystemXmlApplicationContext("classpath:resources/application-config.xml");
        TdmRunner driver = (TdmRunner)springContext.getBean("testDriver");
        HTTPSession.setGlobalUserAgent((String)"TDM v4.3");
        String logLevel = "INFO";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help")) {
                System.out.printf("usage: <Java> <Java_OPTS> -contentDir <contentDir> [-catalog <cat>] [-tds <tdsServer>] [-cred <user:passwd>] [-showOnly] [-log level]%n", new Object[0]);
                System.out.printf("example: /opt/jdk/bin/java -d64 -Xmx8g -server -jar tdm-4.3.jar -catalog /tomcat/webapps/thredds/WEB-INF/altContent/idd/thredds/catalog.xml -cred user:passwd%n", new Object[0]);
                System.exit(0);
            }
            if (args[i].equalsIgnoreCase("-contentDir")) {
                driver.setContentDir(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-catalog")) {
                FileSystemResource cat = new FileSystemResource(args[i + 1]);
                driver.setCatalog((Resource)cat);
                continue;
            }
            if (args[i].equalsIgnoreCase("-tds")) {
                String tds = args[i + 1];
                if (tds.equalsIgnoreCase("none")) {
                    driver.setServerNames(null);
                    driver.sendTriggers = false;
                    continue;
                }
                String[] tdss = tds.split(",");
                driver.setServerNames(tdss);
                continue;
            }
            if (args[i].equalsIgnoreCase("-cred")) {
                String cred = args[i + 1];
                String[] split = cred.split(":");
                driver.user = split[0];
                driver.pass = split[1];
                driver.sendTriggers = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-nthreads")) {
                int n = Integer.parseInt(args[i + 1]);
                driver.setNThreads(n);
                continue;
            }
            if (args[i].equalsIgnoreCase("-showOnly")) {
                driver.setShowOnly(true);
                continue;
            }
            if (!args[i].equalsIgnoreCase("-log")) continue;
            logLevel = args[i + 1];
        }
        InvDatasetFeatureCollection.setLoggerFactory((ucar.nc2.util.log.LoggerFactory)new LoggerFactorySpecial(1000000L, 5, logLevel));
        CollectionUpdater.INSTANCE.setTdm(true);
        if (driver.init()) {
            driver.start();
        } else {
            System.out.printf("EXIT DUE TO ERRORS%n", new Object[0]);
        }
    }

    private class Listener
    implements CollectionManager.TriggerListener {
        InvDatasetFeatureCollection fc;
        CollectionManager dcm;
        AtomicBoolean inUse = new AtomicBoolean(false);
        Logger logger;

        private Listener(InvDatasetFeatureCollection fc, CollectionManager dcm) {
            this.fc = fc;
            this.dcm = dcm;
            this.logger = fc.getLogger();
        }

        public void handleCollectionEvent(CollectionManager.TriggerEvent event) {
            if (event.getType() != CollectionManager.TriggerType.update) {
                return;
            }
            if (this.inUse.get()) {
                this.logger.debug("** Update already in progress for {} {}", (Object)this.fc.getName(), (Object)event.getType());
                return;
            }
            if (!this.inUse.compareAndSet(false, true)) {
                return;
            }
            TdmRunner.this.executor.execute(new IndexTask(this.fc, this.dcm, this, this.logger));
        }
    }

    private class IndexTask
    implements Runnable {
        String name;
        InvDatasetFeatureCollection fc;
        CollectionManager dcm;
        Listener liz;
        Logger logger;

        private IndexTask(InvDatasetFeatureCollection fc, CollectionManager dcm, Listener liz, Logger logger) {
            this.name = fc.getName();
            this.fc = fc;
            this.dcm = dcm;
            this.liz = liz;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                try {
                    FeatureCollectionConfig config = this.fc.getConfig();
                    DataFormatType format = this.fc.getDataFormatType();
                    if (this.dcm instanceof TimePartitionCollection) {
                        TimePartitionCollection tpc = (TimePartitionCollection)this.dcm;
                        this.logger.debug("**** running TimePartitionBuilder.factory {} thread {}", (Object)this.name, (Object)Thread.currentThread().hashCode());
                        Formatter f = new Formatter();
                        try {
                            TimePartition tp = TimePartition.factory((format == DataFormatType.GRIB1 ? 1 : 0) != 0, (TimePartitionCollection)tpc, (CollectionManager.Force)CollectionManager.Force.always, (Logger)this.logger);
                            tp.close();
                            if (config.tdmConfig.triggerOk && TdmRunner.this.sendTriggers) {
                                String path = "thredds/admin/collection/trigger?nocheck&collection=" + this.fc.getName();
                                this.sendTriggers(path, f);
                            }
                            f.format("**** TimePartitionBuilder.factory complete %s%n", this.name);
                        }
                        catch (Throwable e) {
                            this.logger.error("TimePartitionBuilder.factory " + this.name, e);
                        }
                        this.logger.debug("\n------------------------\n{}\n------------------------\n", (Object)f.toString());
                        break block11;
                    }
                    this.logger.debug("**** running GribCollectionBuilder.factory {} Thread {}", (Object)this.name, (Object)Thread.currentThread().hashCode());
                    Formatter f = new Formatter();
                    try {
                        GribCollection gc = GribCollection.factory((format == DataFormatType.GRIB1 ? 1 : 0) != 0, (CollectionManager)this.dcm, (CollectionManager.Force)CollectionManager.Force.always, (Logger)this.logger);
                        gc.close();
                        if (config.tdmConfig.triggerOk && TdmRunner.this.sendTriggers) {
                            String path = "thredds/admin/collection/trigger?nocheck&collection=" + this.fc.getName();
                            this.sendTriggers(path, f);
                        }
                        f.format("**** GribCollectionBuilder.factory complete %s%n", this.name);
                    }
                    catch (Throwable e) {
                        this.logger.error("GribCollectionBuilder.factory " + this.name, e);
                    }
                    this.logger.debug("------------------------\n{}\n------------------------\n", (Object)f.toString());
                }
                finally {
                    if (!this.liz.inUse.getAndSet(false)) {
                        this.logger.warn("Listener InUse should have been set");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendTriggers(String path, Formatter f) {
            for (Server server : TdmRunner.this.servers) {
                String url = server.name + path;
                this.logger.debug("send trigger to {}", (Object)url);
                HTTPMethod m = null;
                try {
                    m = HTTPMethod.Get((HTTPSession)server.session, (String)url);
                    int status = m.execute();
                    String statuss = m.getResponseAsString();
                    f.format(" trigger %s status = %d (%s)%n", url, status, statuss);
                }
                catch (HTTPException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ConnectException) {
                        this.logger.info("server {} not running", (Object)server.name);
                        continue;
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                    e.printStackTrace(new PrintStream(bos));
                    f.format("%s == %s", url, bos.toString());
                    e.printStackTrace();
                }
                finally {
                    if (m == null) continue;
                    m.close();
                }
            }
        }

        private void doManage(String deleteAfterS) {
            TimeDuration deleteAfter = null;
            if (deleteAfterS != null) {
                try {
                    deleteAfter = new TimeDuration(deleteAfterS);
                }
                catch (Exception e) {
                    this.logger.error(this.dcm.getCollectionName() + ": Invalid time unit for deleteAfter = {}", (Object)deleteAfter);
                    return;
                }
            }
            double val = deleteAfter.getValue();
            CalendarPeriod.Field unit = CalendarPeriod.fromUnitString((String)deleteAfter.getTimeUnit().getUnitString());
            CalendarPeriod period = CalendarPeriod.of((int)1, (CalendarPeriod.Field)unit);
            CalendarDate now = CalendarDate.of((Date)new Date());
            CalendarDate last = now.add(-val, unit);
            for (MFile mfile : this.dcm.getFiles()) {
                CalendarDate cd = this.dcm.extractRunDate(mfile);
                int n = period.subtract(cd, now);
                if (cd.isBefore(last)) {
                    this.logger.info("delete={} age = {}", (Object)mfile.getPath(), (Object)(n + " " + unit));
                    continue;
                }
                this.logger.debug("dont delete={} age = {}", (Object)mfile.getPath(), (Object)(n + " " + unit));
            }
        }
    }

    private class Server {
        String name;
        HTTPSession session;

        private Server(String name, HTTPSession session) {
            this.name = name;
            this.session = session;
        }
    }
}

