/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionUpdateListener;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.CollectionUpdater;
import thredds.tdm.CatalogConfigReader;
import thredds.util.AliasHandler;
import thredds.util.LoggerFactorySpecial;
import thredds.util.PathAliasReplacement;
import thredds.util.PathAliasReplacementImpl;
import thredds.util.ThreddsConfigReader;
import ucar.httpclient.HTTPException;
import ucar.httpclient.HTTPFactory;
import ucar.httpclient.HTTPMethod;
import ucar.httpclient.HTTPSession;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.io.RandomAccessFile;

public class Tdm {
    private static Logger log = LoggerFactory.getLogger(Tdm.class);
    private static final boolean debug = false;
    private Path contentDir;
    private Path contentThreddsDir;
    private Path contentTdmDir;
    private Path threddsConfig;
    private String user;
    private String pass;
    private boolean sendTriggers;
    private List<Server> servers;
    private ExecutorService executor;
    private Resource catalog;
    private boolean showOnly = false;
    private String loglevel;
    private boolean forceOnStartup = false;
    ucar.nc2.util.log.LoggerFactory loggerFactory;
    AliasHandler aliasHandler;

    public void setContentDir(String contentDir) throws IOException {
        System.out.printf("contentDir=%s%n", contentDir);
        this.contentDir = Paths.get(contentDir, new String[0]);
        this.contentThreddsDir = Paths.get(contentDir, "thredds");
        this.threddsConfig = Paths.get(contentDir, "thredds", "threddsConfig.xml");
        this.contentTdmDir = Paths.get(contentDir, "tdm");
        this.catalog = new FileSystemResource(this.contentThreddsDir.toString() + "/catalog.xml");
        System.out.printf("catalog=%s%n", this.catalog.getFile().getPath());
    }

    public void setShowOnly(boolean showOnly) {
        this.showOnly = showOnly;
    }

    public void setNThreads(int n) {
        this.executor = Executors.newFixedThreadPool(n);
    }

    public void setForceOnStartup(boolean forceOnStartup) {
        this.forceOnStartup = forceOnStartup;
    }

    public void setLoglevel(String loglevel) {
        this.loglevel = loglevel;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setCatalog(Resource catalog) {
        this.catalog = catalog;
    }

    public void setServerNames(String[] serverNames) throws HTTPException {
        if (serverNames == null) {
            this.servers = new ArrayList<Server>();
            return;
        }
        this.servers = new ArrayList<Server>(serverNames.length);
        for (String name : serverNames) {
            HTTPSession session = new HTTPSession(name);
            session.setCredentialsProvider(new CredentialsProvider(){

                public Credentials getCredentials(AuthScope scope) {
                    return new UsernamePasswordCredentials(Tdm.this.user, Tdm.this.pass);
                }

                public void setCredentials(AuthScope scope, Credentials creds) {
                }

                public void clear() {
                }
            });
            session.setUserAgent("TDM");
            this.servers.add(new Server(name, session));
        }
    }

    public void setPathAliasReplacements(List<PathAliasReplacement> aliasExpanders) {
        this.aliasHandler = new AliasHandler(aliasExpanders);
    }

    boolean init() {
        System.setProperty("tds.log.dir", this.contentTdmDir.toString());
        if (!Files.exists(this.threddsConfig, new LinkOption[0])) {
            log.error("config file {} does not exist, set -Dtds.content.root.path=<dir>", (Object)this.threddsConfig);
            System.out.printf("threddsConfig does not exist=%s%n", this.threddsConfig);
            return false;
        }
        ThreddsConfigReader reader = new ThreddsConfigReader(this.threddsConfig.toString(), log);
        long maxFileSize = reader.getBytes("FeatureCollection.RollingFileAppender.MaxFileSize", 1000000L);
        int maxBackupIndex = reader.getInt("FeatureCollection.RollingFileAppender.MaxBackups", 10);
        String level = reader.get("FeatureCollection.RollingFileAppender.Level", "INFO");
        if (this.loglevel != null) {
            level = this.loglevel;
        }
        this.loggerFactory = new LoggerFactorySpecial(maxFileSize, maxBackupIndex, level);
        String gribIndexDir = reader.get("GribIndex.dir", new File(this.contentThreddsDir.toString(), "cache/grib/").getPath());
        Boolean gribIndexAlwaysUse = reader.getBoolean("GribIndex.alwaysUse", false);
        Boolean gribIndexNeverUse = reader.getBoolean("GribIndex.neverUse", false);
        String gribIndexPolicy = reader.get("GribIndex.policy", null);
        DiskCache2 gribCache = gribIndexNeverUse != false ? DiskCache2.getNoop() : new DiskCache2(gribIndexDir, false, -1, -1);
        gribCache.setPolicy(gribIndexPolicy);
        gribCache.setAlwaysUseCache(gribIndexAlwaysUse.booleanValue());
        gribCache.setNeverUseCache(gribIndexNeverUse.booleanValue());
        GribCollection.setDiskCache2((DiskCache2)gribCache);
        return true;
    }

    void start() throws IOException {
        System.out.printf("Tdm startup at %s%n", new Date());
        CatalogConfigReader reader = new CatalogConfigReader(this.catalog, this.aliasHandler);
        List<FeatureCollectionConfig> fcList = reader.getFcList();
        if (this.showOnly) {
            ArrayList<String> result = new ArrayList<String>();
            for (FeatureCollectionConfig config : fcList) {
                result.add(config.name);
            }
            Collections.sort(result);
            System.out.printf("Feature Collection names:%n", new Object[0]);
            for (String name : result) {
                System.out.printf(" %s%n", name);
            }
            System.out.printf("%nTriggers:%n", new Object[0]);
            for (String name : result) {
                System.out.printf(" %s%n", this.makeTriggerUrl(name));
            }
            return;
        }
        for (FeatureCollectionConfig config : fcList) {
            if (config.type != FeatureCollectionType.GRIB1 && config.type != FeatureCollectionType.GRIB2) continue;
            System.out.printf("FeatureCollection %s scheduled %n", config.name);
            if (this.forceOnStartup) {
                config.tdmConfig.startupType = CollectionUpdateType.always;
            }
            Logger logger = this.loggerFactory.getLogger("fc." + config.name);
            logger.info("FeatureCollection config=" + config);
            CollectionUpdater.INSTANCE.scheduleTasks(config, (CollectionUpdateListener)new Listener(config, logger), logger);
        }
    }

    private String makeTriggerUrl(String name) {
        return "thredds/admin/collection/trigger?trigger=never&collection=" + name;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        FileSystemXmlApplicationContext springContext = new FileSystemXmlApplicationContext("classpath:resources/application-config.xml");
        Tdm driver = (Tdm)springContext.getBean("testDriver2");
        Map aliases = (Map)springContext.getBean("dataRootLocationAliasExpanders");
        List aliasExpanders = PathAliasReplacementImpl.makePathAliasReplacements((Map)aliases);
        driver.setPathAliasReplacements(aliasExpanders);
        CollectionUpdater.INSTANCE.setTdm(true);
        String contentDir = System.getProperty("tds.content.root.path");
        if (contentDir == null) {
            contentDir = "../content";
        }
        driver.setContentDir(contentDir);
        RandomAccessFile.setDebugLeaks((boolean)true);
        HTTPSession.setGlobalUserAgent((String)"TDM v4.5");
        String logLevel = "INFO";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help")) {
                System.out.printf("usage: <Java> <Java_OPTS> -Dtds.content.root.path=<contentDir> [-catalog <cat>] [-tds <tdsServer>] [-cred <user:passwd>] [-showOnly] [-forceOnStartup]%n", new Object[0]);
                System.out.printf("example: /opt/jdk/bin/java -Xmx3g -Dtds.content.root.path=/my/content -jar tdm-4.5.jar -tds http://thredds-dev.unidata.ucar.edu/%n", new Object[0]);
                System.exit(0);
            }
            if (args[i].equalsIgnoreCase("-contentDir")) {
                driver.setContentDir(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-catalog")) {
                FileSystemResource cat = new FileSystemResource(args[i + 1]);
                driver.setCatalog((Resource)cat);
                continue;
            }
            if (args[i].equalsIgnoreCase("-tds")) {
                String tds = args[i + 1];
                if (tds.equalsIgnoreCase("none")) {
                    driver.setServerNames(null);
                    driver.sendTriggers = false;
                    continue;
                }
                String[] tdss = tds.split(",");
                driver.setServerNames(tdss);
                driver.sendTriggers = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-cred")) {
                String cred = args[i + 1];
                String[] split = cred.split(":");
                driver.user = split[0];
                driver.pass = split[1];
                driver.sendTriggers = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-nthreads")) {
                int n = Integer.parseInt(args[i + 1]);
                driver.setNThreads(n);
                continue;
            }
            if (args[i].equalsIgnoreCase("-showOnly")) {
                driver.setShowOnly(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("-log")) {
                logLevel = args[i + 1];
                driver.setLoglevel(logLevel);
                continue;
            }
            if (!args[i].equalsIgnoreCase("-forceOnStartup")) continue;
            driver.setForceOnStartup(true);
        }
        if (driver.pass == null && driver.sendTriggers) {
            String ok;
            Scanner scanner = new Scanner(System.in);
            String passw = null;
            do {
                System.out.printf("%nEnter password for tds trigger: ", new Object[0]);
                passw = scanner.nextLine();
                System.out.printf("%nPassword = '%s' OK (Y/N)?", passw);
            } while (!(ok = scanner.nextLine()).equalsIgnoreCase("Y"));
            if (passw != null) {
                driver.pass = passw;
                driver.user = "tdm";
            } else {
                driver.sendTriggers = false;
            }
        }
        if (driver.init()) {
            driver.start();
        } else {
            System.out.printf("EXIT DUE TO ERRORS%n", new Object[0]);
        }
    }

    private class IndexTask
    implements Runnable {
        String name;
        FeatureCollectionConfig config;
        CollectionUpdateType updateType;
        Listener liz;
        Logger logger;

        private IndexTask(FeatureCollectionConfig config, Listener liz, CollectionUpdateType updateType, Logger logger) {
            this.name = config.name;
            this.config = config;
            this.liz = liz;
            this.updateType = updateType;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List openFiles;
            try {
                boolean changed = GribCdmIndex.updateGribCollection((FeatureCollectionConfig)this.config, (CollectionUpdateType)this.updateType, (Logger)this.logger);
                this.logger.debug("{} {} changed {}", new Object[]{CalendarDate.present(), this.config.name, changed});
                if (changed) {
                    System.out.printf("%s %s changed%n", CalendarDate.present(), this.config.name);
                }
                if (changed && this.config.tdmConfig.triggerOk && Tdm.this.sendTriggers) {
                    String path = Tdm.this.makeTriggerUrl(this.name);
                    this.sendTriggers(path);
                }
            }
            catch (Throwable e) {
                this.logger.error("Tdm.IndexTask " + this.name, e);
                e.printStackTrace();
            }
            finally {
                if (!this.liz.inUse.getAndSet(false)) {
                    this.logger.warn("Listener InUse should have been set");
                }
            }
            if ((openFiles = RandomAccessFile.getOpenFiles()).size() > 0) {
                System.out.printf("Open Files%n", new Object[0]);
                for (String filename : RandomAccessFile.getOpenFiles()) {
                    System.out.printf("  %s%n", filename);
                }
                System.out.printf("End Open Files%n", new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendTriggers(String path) {
            for (Server server : Tdm.this.servers) {
                String url = server.name + path;
                HTTPMethod m = null;
                try {
                    m = HTTPFactory.Get((HTTPSession)server.session, (String)url);
                    int status = m.execute();
                    if (status == 200) {
                        this.logger.info("send trigger to {} status = {}", (Object)url, (Object)status);
                        continue;
                    }
                    this.logger.warn("FAIL send trigger to {} status = {}", (Object)url, (Object)status);
                }
                catch (HTTPException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ConnectException) {
                        this.logger.warn("server {} not running", (Object)server.name);
                        continue;
                    }
                    e.printStackTrace();
                    this.logger.error("FAIL send trigger to " + url + " failed", cause);
                }
                finally {
                    if (m == null) continue;
                    m.close();
                }
            }
        }
    }

    private class Listener
    implements CollectionUpdateListener {
        FeatureCollectionConfig config;
        AtomicBoolean inUse = new AtomicBoolean(false);
        Logger logger;

        private Listener(FeatureCollectionConfig config, Logger logger) {
            this.config = config;
            this.logger = logger;
        }

        public String getCollectionName() {
            return this.config.name;
        }

        public void sendEvent(CollectionUpdateType event) {
            if (!this.inUse.compareAndSet(false, true)) {
                return;
            }
            Tdm.this.executor.execute(new IndexTask(this.config, this, event, this.logger));
        }
    }

    private class Server {
        String name;
        HTTPSession session;

        private Server(String name, HTTPSession session) {
            this.name = name;
            this.session = session;
            System.out.printf("Server added %s%n", name);
            log.info("Server added " + name);
        }
    }
}

