/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import thredds.catalog.parser.jdom.FeatureCollectionReader;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionSpecParser;
import thredds.util.AliasHandler;

public class CatalogConfigReader {
    private static final Logger log = LoggerFactory.getLogger(CatalogConfigReader.class);
    private static final boolean debug = false;
    private final Set<String> staticCatalogHash = new HashSet<String>();
    private final List<FeatureCollectionConfig> fcList = new ArrayList<FeatureCollectionConfig>();
    private AliasHandler aliasHandler;

    public List<FeatureCollectionConfig> getFcList() {
        return this.fcList;
    }

    public CatalogConfigReader(Resource catR, AliasHandler aliasHandler) throws IOException {
        this.aliasHandler = aliasHandler;
        this.readCatalog(catR);
    }

    private boolean readCatalog(Resource catR) throws IOException {
        Document doc;
        File catFile = catR.getFile();
        String fcName = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(catFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Element root = doc.getRootElement();
        try {
            ArrayList<Element> fcElems = new ArrayList<Element>();
            this.findFeatureCollections(root, fcName, fcElems);
            for (Element fcElem : fcElems) {
                String name = "";
                try {
                    FeatureCollectionConfig config = FeatureCollectionReader.readFeatureCollection((Element)fcElem);
                    name = config.name;
                    config.spec = this.aliasHandler.replaceAlias(config.spec);
                    Formatter errlog = new Formatter();
                    CollectionSpecParser specp = new CollectionSpecParser(config.spec, errlog);
                    Path rootPath = Paths.get(specp.getRootDir(), new String[0]);
                    if (!Files.exists(rootPath, new LinkOption[0])) {
                        System.out.printf("Root path %s does not exist fc='%s' from catalog=%s %n", rootPath.getFileName(), config.name, catFile.getPath());
                        log.error("Root path {} does not exist fc='{}' from catalog={}", new Object[]{rootPath.getFileName(), config.name, catFile.getPath()});
                        continue;
                    }
                    this.fcList.add(config);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    log.error("Error reading collection " + name + " skipping collection ", e);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("Error reading catalog " + catFile.getPath() + " skipping ", e);
        }
        try {
            ArrayList<Element> catrefElems = new ArrayList<Element>();
            this.findCatalogRefs(root, catrefElems);
            for (Element catrefElem : catrefElems) {
                String href = catrefElem.getAttributeValue("href", InvCatalogFactory10.xlinkNS);
                File refCat = new File(catFile.getParent(), href);
                FileSystemResource catRnested = new FileSystemResource(refCat);
                if (!catRnested.exists()) {
                    log.error("Relative catalog {} does not exist", (Object)refCat);
                    continue;
                }
                this.readCatalog((Resource)catRnested);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            log.error("Error follow catrefs in " + catFile.getPath() + " skipping ", (Throwable)e);
        }
        return true;
    }

    private void findFeatureCollections(Element parent, String name, List<Element> fcElems) {
        List elist = parent.getChildren("featureCollection", InvCatalogFactory10.defNS);
        if (name == null) {
            fcElems.addAll(elist);
        } else {
            for (Element elem : elist) {
                if (!name.equals(elem.getAttributeValue("name"))) continue;
                fcElems.add(elem);
            }
        }
        for (Element child : parent.getChildren("dataset", InvCatalogFactory10.defNS)) {
            this.findFeatureCollections(child, name, fcElems);
        }
    }

    private void findCatalogRefs(Element parent, List<Element> catrefElems) {
        List elist = parent.getChildren("catalogRef", InvCatalogFactory10.defNS);
        catrefElems.addAll(elist);
        for (Element child : parent.getChildren("dataset", InvCatalogFactory10.defNS)) {
            this.findCatalogRefs(child, catrefElems);
        }
    }
}

