/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.util.PathAliasReplacement;
import ucar.nc2.time.CalendarDate;

public class CatalogReader {
    private static final Logger log = LoggerFactory.getLogger(CatalogReader.class);
    private final Set<String> staticCatalogHash = new HashSet<String>();
    private final List<InvDatasetFeatureCollection> fcList = new ArrayList<InvDatasetFeatureCollection>();
    List<PathAliasReplacement> aliasExpanders;

    public CatalogReader(Resource catR, List<PathAliasReplacement> aliasExpanders) {
        this.aliasExpanders = aliasExpanders;
        try {
            log.info("\n**************************************\nCatalog init " + catR + "\n[" + CalendarDate.present() + "]");
            this.initCatalog(catR, true);
        }
        catch (Throwable e) {
            log.error("initCatalogs(): Error initializing catalog " + catR + "; " + e.getMessage(), e);
        }
    }

    private void initCatalog(Resource catR, boolean recurse) throws IOException {
        String path = catR.getURI().toString();
        if (this.staticCatalogHash.contains(path)) {
            log.warn("initCatalog(): Catalog [" + path + "] already seen, possible loop (skip).");
            return;
        }
        this.staticCatalogHash.add(path);
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)true);
        factory.setDataRootLocationAliasExpanders(this.aliasExpanders);
        InvCatalogImpl cat = this.readCatalog(factory, catR);
        if (cat == null) {
            log.warn("initCatalog(): failed to read catalog <" + catR + ">.");
            return;
        }
        this.initSpecialDatasets(cat.getDatasets());
        if (recurse) {
            try {
                File catFile = catR.getFile();
                if (catFile.exists()) {
                    this.initFollowCatrefs(catFile, cat.getDatasets());
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvCatalogImpl readCatalog(InvCatalogFactory factory, Resource catR) throws IOException {
        InputStream ios = catR.getInputStream();
        InvCatalogImpl cat = null;
        try {
            cat = factory.readXML(ios, catR.getURI());
            StringBuilder sbuff = new StringBuilder();
            if (!cat.check(sbuff)) {
                log.error("readCatalog(): invalid catalog -- " + sbuff.toString());
                InvCatalogImpl invCatalogImpl = null;
                return invCatalogImpl;
            }
            log.info("readCatalog(): valid catalog -- " + sbuff.toString());
        }
        catch (Throwable t) {
            String msg = cat == null ? "null catalog" : cat.getLog();
            log.error("readCatalog(): Exception on catalog=" + catR + " " + t.getMessage() + "\n log=" + msg, t);
            InvCatalogImpl invCatalogImpl = null;
            return invCatalogImpl;
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException e) {
                    log.error("readCatalog(): error closing" + catR);
                }
            }
        }
        return cat;
    }

    private void initSpecialDatasets(List<InvDataset> dsList) {
        for (InvDataset invds : dsList) {
            InvDatasetImpl invDataset = (InvDatasetImpl)invds;
            if (invDataset instanceof InvDatasetFeatureCollection) {
                InvDatasetFeatureCollection fc = (InvDatasetFeatureCollection)invDataset;
                this.fcList.add(fc);
            }
            if (invDataset instanceof InvCatalogRef) continue;
            this.initSpecialDatasets(invDataset.getDatasets());
        }
    }

    private void initFollowCatrefs(File catFile, List<InvDataset> datasets) throws IOException {
        for (InvDataset invDataset : datasets) {
            if (invDataset instanceof InvCatalogRef && !(invDataset instanceof InvDatasetScan) && !(invDataset instanceof InvDatasetFeatureCollection)) {
                File refCat;
                FileSystemResource catR;
                InvCatalogRef catref = (InvCatalogRef)invDataset;
                String href = catref.getXlinkHref();
                if (log.isDebugEnabled()) {
                    log.debug("  catref.getXlinkHref=" + href);
                }
                if (href.startsWith("http:")) continue;
                if (href.startsWith("./")) {
                    href = href.substring(2);
                }
                if (!(catR = new FileSystemResource(refCat = new File(catFile.getParent(), href))).exists()) {
                    log.error("Reletive catalog {} does not exist", (Object)catR);
                    continue;
                }
                this.initCatalog((Resource)catR, true);
                continue;
            }
            if (invDataset instanceof InvDatasetScan || invDataset instanceof InvDatasetFeatureCollection) continue;
            this.initFollowCatrefs(catFile, invDataset.getDatasets());
        }
    }

    public List<InvDatasetFeatureCollection> getFcList() {
        return this.fcList;
    }
}

