/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.filter.StreamFilter;
import thredds.inventory.partition.DirectoryBuilder;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.DirectoryPartition;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Variable;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Variable;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CloseableIterator;
import ucar.nc2.util.Counters;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.Indent;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class GCpass1 {
    private static final Logger logger = LoggerFactory.getLogger(GCpass1.class);
    FeatureCollectionConfig config;
    FeatureCollectionConfig.GribConfig gribConfig;
    Formatter fm;
    Counters countersAll;
    Accum accumAll = new Accum(2);
    Grib1Customizer cust1 = null;
    Grib2Customizer cust2 = null;

    public static void main(String[] args) throws IOException {
        Boolean useTableVersion;
        String usage = "usage: thredds.tdm.GCpass1 -spec <collectionSpec> [-isGrib2] -partition [none|file|directory] -useTableVersion [true|false] -useCacheDir <dir>";
        String def = "default: -isGrib1 -partition directory -useTableVersion false";
        if (args.length < 2) {
            System.out.printf("%s%n%s%n", usage, def);
            System.exit(0);
        }
        String spec = null;
        FeatureCollectionType type = FeatureCollectionType.GRIB1;
        String partition = "directory";
        String useTableVersionS = null;
        String cacheDir = null;
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.equalsIgnoreCase("-spec")) {
                spec = args[i + 1];
            }
            if (s.equalsIgnoreCase("-isGrib2")) {
                type = FeatureCollectionType.GRIB2;
            }
            if (s.equalsIgnoreCase("-partition")) {
                partition = args[i + 1];
            }
            if (s.equalsIgnoreCase("-useTableVersion")) {
                useTableVersionS = args[i + 1];
            }
            if (!s.equalsIgnoreCase("-useCacheDir")) continue;
            cacheDir = args[i + 1];
        }
        Boolean bl = useTableVersion = useTableVersionS != null ? Boolean.valueOf(Boolean.parseBoolean(useTableVersionS)) : null;
        if (cacheDir != null) {
            DiskCache2 gribCache = DiskCache2.getDefault();
            gribCache.setRootDirectory(cacheDir);
            gribCache.setAlwaysUseCache(true);
            GribIndexCache.setDiskCache2((DiskCache2)gribCache);
        }
        Formatter fm = new Formatter(System.out);
        GCpass1 pass1 = new GCpass1(spec, type, partition, useTableVersion, fm);
        pass1.scanAndReport();
    }

    public GCpass1(String spec, FeatureCollectionType fcType, String timePartition, Boolean useTableVersion, Formatter fm) {
        this.config = new FeatureCollectionConfig("GCpass1", "test/GCpass1", fcType, spec, null, null, null, timePartition, null);
        this.gribConfig = this.config.gribConfig;
        if (useTableVersion != null) {
            this.gribConfig.useTableVersion = useTableVersion;
        }
        this.fm = fm;
        this.config.show(fm);
        fm.format("%n", new Object[0]);
        this.countersAll = new Counters();
        this.countersAll.add("referenceDate").setShowRange(true);
        this.countersAll.add("table version");
        this.countersAll.add("variable");
        this.countersAll.add("gds");
        this.countersAll.add("gdsTemplate");
        this.countersAll.add("vertCoordInGDS");
        this.countersAll.add("predefined");
        this.countersAll.add("thin");
    }

    public void reportAll(Indent indent, Formatter fm) {
        fm.format("%n", new Object[0]);
        this.reportOneHeader(indent, fm);
        fm.format("%s%40s", indent, "grand total");
        fm.format("%8d ", this.accumAll.count[0]);
        fm.format("%8d ", this.accumAll.count[1]);
        fm.format("%8d ", this.countersAll.get("variable").getUnique());
        fm.format("%8d ", this.countersAll.get("referenceDate").getUnique());
        fm.format("%8d ", this.countersAll.get("gds").getUnique());
        fm.format("%n", new Object[0]);
        this.countersAll.show(fm);
    }

    public void reportOneHeader(Indent indent, Formatter fm) {
        fm.format("%s%40s #files  #records   #vars  #runtimes    #gds%n", indent, "");
    }

    public CalendarDate reportOneDir(String dir, Accum accum, Counters countersOne, Indent indent, CalendarDate last) {
        this.fm.format("%s%40s", indent, dir + " total");
        this.fm.format("%8d ", accum.count[0]);
        this.fm.format("%8d ", accum.count[1]);
        this.fm.format("%8d ", countersOne.get("variable").getUnique());
        this.fm.format("%8d ", countersOne.get("referenceDate").getUnique());
        this.fm.format("%8d ", countersOne.get("gds").getUnique());
        this.fm.format("%s ", countersOne.get("referenceDate").showRange());
        CalendarDate first = (CalendarDate)countersOne.get("referenceDate").getFirst();
        if (last != null && first.isBefore(last)) {
            this.fm.format(" ***", new Object[0]);
        }
        this.fm.format("%n", new Object[0]);
        return (CalendarDate)countersOne.get("referenceDate").getLast();
    }

    public void reportOneFileHeader(Indent indent, Formatter fm) {
        fm.format("%s%40s #records   #vars  #runtimes #gds%n", indent, "");
    }

    public void reportOneFile(MFile mfile, int nrecords, Counters countersOne, Indent indent, Formatter fm) {
        fm.format("%s%40s", indent, mfile.getName());
        fm.format("%8d ", nrecords);
        fm.format("%8d ", countersOne.get("variable").getUnique());
        fm.format("%8d ", countersOne.get("referenceDate").getUnique());
        fm.format("%8d ", countersOne.get("gds").getUnique());
        int vertCoordInGDS = countersOne.get("vertCoordInGDS").getUnique();
        int predefined = countersOne.get("predefined").getUnique();
        int thin = countersOne.get("thin").getUnique();
        if (vertCoordInGDS != 0) {
            fm.format("vertCoordInGDS=%d ", vertCoordInGDS);
        }
        if (predefined != 0) {
            fm.format("predefined=%d ", vertCoordInGDS);
        }
        if (thin != 0) {
            fm.format("thin=%d ", vertCoordInGDS);
        }
        fm.format("%n", new Object[0]);
    }

    public void scanAndReport() throws IOException {
        Indent indent = new Indent(2);
        if (this.config.ptype != FeatureCollectionConfig.PartitionType.file) {
            this.reportOneHeader(indent, this.fm);
        }
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = this.config.getCollectionSpecParser(errlog);
        Path rootPath = Paths.get(specp.getRootDir(), new String[0]);
        boolean isGrib1 = this.config.type == FeatureCollectionType.GRIB1;
        try (MCollection topCollection = DirectoryBuilder.factory((FeatureCollectionConfig)this.config, (Path)rootPath, (boolean)true, null, (Logger)logger);){
            if (topCollection instanceof DirectoryPartition) {
                DirectoryPartition dpart = (DirectoryPartition)topCollection;
                dpart.putAuxInfo("fcConfig", (Object)this.config);
                this.accumAll.add(this.scanDirectoryPartitionRecurse(isGrib1, dpart, this.config, this.countersAll, logger, indent, this.fm));
            } else if (topCollection instanceof DirectoryCollection) {
                this.accumAll.add(this.scanLeafDirectoryCollection(isGrib1, this.config, this.countersAll, logger, rootPath, true, indent, this.fm));
            }
            this.reportAll(indent, this.fm);
        }
    }

    private Accum scanDirectoryPartitionRecurse(boolean isGrib1, DirectoryPartition dpart, FeatureCollectionConfig config, Counters countersParent, Logger logger, Indent indent, Formatter fm) throws IOException {
        fm.format("%n%sDirectory %s%n", indent, dpart.getRoot());
        indent.incr();
        Counters countersPart = countersParent.makeSubCounters();
        Accum accum = new Accum(2);
        for (MCollection part : dpart.makePartitions(CollectionUpdateType.always)) {
            part.putAuxInfo("fcConfig", (Object)config);
            try {
                if (part instanceof DirectoryPartition) {
                    accum.add(this.scanDirectoryPartitionRecurse(isGrib1, (DirectoryPartition)part, config, countersPart, logger, indent, fm));
                    continue;
                }
                Path partPath = Paths.get(part.getRoot(), new String[0]);
                accum.add(this.scanLeafDirectoryCollection(isGrib1, config, countersPart, logger, partPath, false, indent, fm));
            }
            catch (Throwable t) {
                logger.warn("Error making partition " + part.getRoot(), t);
            }
        }
        countersParent.addTo(countersPart);
        accum.last = this.reportOneDir(dpart.getRoot(), accum, countersPart, indent, accum.last);
        indent.decr();
        return accum;
    }

    private Accum scanLeafDirectoryCollection(boolean isGrib1, FeatureCollectionConfig config, Counters parentCounters, Logger logger, Path dirPath, boolean isTop, Indent indent, Formatter fm) throws IOException {
        if (config.ptype == FeatureCollectionConfig.PartitionType.file) {
            this.reportOneFileHeader(indent, fm);
            fm.format("%sDirectory %s%n", indent, dirPath);
        }
        Accum accum = new Accum(2);
        int nfiles = 0;
        Counters countersThisDir = parentCounters.makeSubCounters();
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = config.getCollectionSpecParser(errlog);
        DirectoryCollection dcm = new DirectoryCollection(config.collectionName, dirPath, isTop, config.olderThan, logger);
        dcm.putAuxInfo("fcConfig", (Object)config);
        if (specp.getFilter() != null) {
            dcm.setStreamFilter((DirectoryStream.Filter)new StreamFilter(specp.getFilter(), specp.getFilterOnName()));
        }
        try (CloseableIterator iter = dcm.getFileIterator();){
            while (iter.hasNext()) {
                MFile mfile = (MFile)iter.next();
                Counters countersOneFile = countersThisDir.makeSubCounters();
                int nrecords = 0;
                if (isGrib1) {
                    Grib1Index grib1Index = this.readGrib1Index(mfile, false);
                    if (grib1Index == null) {
                        System.out.printf("%s%s: read or create failed%n", indent, mfile.getPath());
                        continue;
                    }
                    for (Grib1Record gr : grib1Index.getRecords()) {
                        this.accumGrib1Record(gr, countersOneFile);
                        ++nrecords;
                    }
                } else {
                    Grib2Index grib2Index = this.readGrib2Index(mfile, false);
                    if (grib2Index == null) {
                        System.out.printf("%s%s: read or create failed%n", indent, mfile.getPath());
                        continue;
                    }
                    for (Grib1Record gr : grib2Index.getRecords()) {
                        this.accumGrib2Record((Grib2Record)gr, countersOneFile);
                        ++nrecords;
                    }
                }
                accum.add(1, nrecords);
                countersThisDir.addTo(countersOneFile);
                if (config.ptype == FeatureCollectionConfig.PartitionType.file) {
                    this.reportOneFile(mfile, nrecords, countersOneFile, indent, fm);
                }
                ++nfiles;
            }
        }
        parentCounters.addTo(countersThisDir);
        accum.add(0, nfiles);
        accum.last = this.reportOneDir(dirPath.toString(), accum, countersThisDir, indent, accum.last);
        return accum;
    }

    private void accumGrib1Record(Grib1Record gr, Counters counters) throws IOException {
        if (this.cust1 == null) {
            this.cust1 = Grib1Customizer.factory((Grib1Record)gr, null);
        }
        Grib1SectionGridDefinition gdss = gr.getGDSsection();
        Grib1SectionProductDefinition pds = gr.getPDSsection();
        String table = pds.getCenter() + "-" + pds.getSubCenter() + "-" + pds.getTableVersion();
        counters.count("table version", (Comparable)((Object)table));
        counters.count("referenceDate", (Comparable)pds.getReferenceDate());
        int gdsHash = gr.getGDS().hashCode();
        int cdmHash = Grib1Variable.cdmVariableHash((Grib1Customizer)this.cust1, (Grib1Record)gr, (int)gdsHash, (boolean)this.gribConfig.useTableVersion, (boolean)this.gribConfig.intvMerge, (boolean)this.gribConfig.useCenter);
        String name = Grib1Iosp.makeVariableName((Grib1Customizer)this.cust1, (FeatureCollectionConfig.GribConfig)this.gribConfig, (Grib1SectionProductDefinition)pds);
        counters.count("variable", (Comparable)new Variable(cdmHash, name));
        counters.count("gds", (Comparable)Integer.valueOf(gdsHash));
        counters.count("gdsTemplate", (Comparable)Integer.valueOf(gdss.getGridTemplate()));
        if (gdss.isThin()) {
            counters.count("thin", (Comparable)Integer.valueOf(gdss.getGridTemplate()));
        }
        if (!pds.gdsExists()) {
            counters.count("predefined", (Comparable)Integer.valueOf(gdss.getPredefinedGridDefinition()));
        }
        if (gdss.hasVerticalCoordinateParameters()) {
            counters.count("vertCoordInGDS", (Comparable)Integer.valueOf(pds.getLevelType()));
        }
    }

    private void accumGrib2Record(Grib2Record gr, Counters counters) throws IOException {
        if (this.cust2 == null) {
            this.cust2 = Grib2Customizer.factory((Grib2Record)gr);
        }
        Grib2SectionIdentification id = gr.getId();
        String table = id.getCenter_id() + "-" + id.getSubcenter_id() + "-" + id.getMaster_table_version() + "-" + id.getLocal_table_version();
        counters.count("table version", (Comparable)((Object)table));
        counters.count("referenceDate", (Comparable)gr.getReferenceDate());
        int cdmHash = Grib2Variable.cdmVariableHash((Grib2Customizer)this.cust2, (Grib2Record)gr, (int)0, (boolean)this.gribConfig.intvMerge, (boolean)this.gribConfig.useGenType);
        String name = GribUtils.makeNameFromDescription((String)this.cust2.getVariableName(gr));
        counters.count("variable", (Comparable)new Variable(cdmHash, name));
        counters.count("gds", (Comparable)Integer.valueOf(gr.getGDS().hashCode()));
        counters.count("gdsTemplate", (Comparable)Integer.valueOf(gr.getGDSsection().getGDSTemplateNumber()));
    }

    private Grib1Index readGrib1Index(MFile mf, boolean readOnly) throws IOException {
        Grib1Index index;
        String path = mf.getPath();
        if (path.endsWith(".gbx9")) {
            path = StringUtil2.removeFromEnd((String)path, (String)".gbx9");
        }
        if (!(index = new Grib1Index()).readIndex(path, mf.getLastModified(), CollectionUpdateType.test)) {
            if (readOnly) {
                return null;
            }
            try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
                if (!Grib1RecordScanner.isValidFile((RandomAccessFile)raf)) {
                    Grib1Index grib1Index = null;
                    return grib1Index;
                }
                index.makeIndex(path, raf);
            }
        }
        return index;
    }

    private Grib2Index readGrib2Index(MFile mf, boolean readOnly) throws IOException {
        Grib2Index index;
        String path = mf.getPath();
        if (path.endsWith(".gbx9")) {
            path = StringUtil2.removeFromEnd((String)path, (String)".gbx9");
        }
        if (!(index = new Grib2Index()).readIndex(path, mf.getLastModified(), CollectionUpdateType.test)) {
            if (readOnly) {
                return null;
            }
            try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
                if (!Grib2RecordScanner.isValidFile((RandomAccessFile)raf)) {
                    Grib2Index grib2Index = null;
                    return grib2Index;
                }
                index.makeIndex(path, raf);
            }
        }
        return index;
    }

    static class Variable
    implements Comparable<Variable> {
        int cdmHash;
        String name;

        Variable(int cdmHash, String name) {
            this.cdmHash = cdmHash;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.cdmHash == variable.cdmHash;
        }

        public int hashCode() {
            return this.cdmHash;
        }

        @Override
        public int compareTo(Variable o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.name;
        }
    }

    static class Accum {
        CalendarDate last = null;
        int[] count;

        Accum(int n) {
            this.count = new int[n];
        }

        void add(Accum a) {
            for (int i = 0; i < this.count.length; ++i) {
                int n = i;
                this.count[n] = this.count[n] + a.count[i];
            }
        }

        void add(int idx, int val) {
            int n = idx;
            this.count[n] = this.count[n] + val;
        }
    }
}

